/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command.converters;

import net.minecraft.util.math.Vec3d;
import picocli.CommandLine;

public class Vec3dDataConverter
implements CommandLine.ITypeConverter<Vec3d> {
    private static final String DOUBLE_REGEX = "-?(\\d*\\.\\d+)|(\\d+\\.)|(\\d+)";
    private static final String VECTOR_REGEX = String.format("<%s,%s,%s>", "-?(\\d*\\.\\d+)|(\\d+\\.)|(\\d+)", "-?(\\d*\\.\\d+)|(\\d+\\.)|(\\d+)", "-?(\\d*\\.\\d+)|(\\d+\\.)|(\\d+)");

    @Override
    public Vec3d convert(String value) throws CommandLine.TypeConversionException {
        try {
            if (!value.matches(VECTOR_REGEX)) {
                String trimmedValue = value.substring(1, value.length() - 1);
                String[] doublesInValue = trimmedValue.split(",");
                double posX = Double.parseDouble(doublesInValue[0]);
                double posY = Double.parseDouble(doublesInValue[1]);
                double posZ = Double.parseDouble(doublesInValue[2]);
                return new Vec3d(posX, posY, posZ);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new CommandLine.TypeConversionException("Cannot convert " + value + " to a vector");
    }
}

