/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.valkyrienskies.mod.common.command.config.ConfigCommandEndNode;
import org.valkyrienskies.mod.common.command.config.ConfigCommandNode;
import org.valkyrienskies.mod.common.command.config.ConfigCommandParentNode;
import org.valkyrienskies.mod.common.command.config.ConfigCommandUtils;
import org.valkyrienskies.mod.common.command.config.ShortName;
import org.valkyrienskies.mod.common.command.framework.VSCommandUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VSConfigCommandBase
extends CommandBase {
    private final String name;
    private final ConfigCommandParentNode root;
    private final Method sync;
    private final List<String> aliases;
    private final String usage;

    public VSConfigCommandBase(String name, Class<?> configClass, String ... aliases) {
        try {
            this.sync = configClass.getMethod("sync", new Class[0]);
            if (!Modifier.isStatic(this.sync.getModifiers())) {
                throw new IllegalArgumentException("That class does not have a public static sync method on it!");
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("That class does not have a public static sync method on it!", e);
        }
        this.name = name;
        this.aliases = Arrays.asList(aliases);
        this.root = new ConfigCommandParentNode(name, Collections.emptyMap());
        VSConfigCommandBase.processFields(configClass, this.root);
        this.usage = String.format("/%s <option>\nOptions: %s", name, String.join((CharSequence)", ", this.root.childrenNames()));
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    private static void processFields(Class<?> configClass, ConfigCommandParentNode root) {
        List subcategories = Arrays.stream(configClass.getDeclaredClasses()).filter(c -> !c.isEnum()).collect(Collectors.toList());
        for (Field field : configClass.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            if (subcategories.contains(field.getType())) {
                VSConfigCommandBase.processFieldForSubcategory(field.getType(), field, root);
                continue;
            }
            if (!ConfigCommandUtils.isSupportedType(field.getType())) continue;
            root.addChild(new ConfigCommandEndNode(field, null));
        }
    }

    private static void processFieldForSubcategory(Class<?> subcategory, Field subcatField, ConfigCommandParentNode root) {
        Object subcategoryObj = subcatField.get(null);
        ShortName subcatShortName = subcatField.getAnnotation(ShortName.class);
        String subcatDisplayName = subcatShortName == null ? subcatField.getName() : subcatShortName.value();
        ConfigCommandParentNode subcategoryNode = new ConfigCommandParentNode(subcatDisplayName);
        root.addChild(subcategoryNode);
        for (Field field : subcategory.getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !ConfigCommandUtils.isSupportedType(field.getType())) continue;
            subcategoryNode.addChild(new ConfigCommandEndNode(field, subcategoryObj));
        }
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender sender) {
        return this.usage;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        args = VSCommandUtil.toProperArgs(args);
        ConfigCommandNode currentNode = this.root;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + this.usage));
        }
        for (int i = 0; i < args.length; ++i) {
            if (currentNode instanceof ConfigCommandParentNode) {
                currentNode = ((ConfigCommandParentNode)currentNode).getChild(args[i]);
            }
            if (currentNode instanceof ConfigCommandEndNode && i < args.length - 1) {
                ((ConfigCommandEndNode)currentNode).getOptionSetter().accept(args[i + 1]);
                try {
                    this.sync.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Set " + currentNode.getName() + " = " + ((ConfigCommandEndNode)currentNode).getOptionGetter().get().toString()));
                break;
            }
            if (currentNode instanceof ConfigCommandEndNode && i == args.length - 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString(currentNode.getName() + " = " + ((ConfigCommandEndNode)currentNode).getOptionGetter().get().toString()));
                break;
            }
            if (i == args.length - 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("That is a subcategory, please specify additional fields"));
            }
            if (currentNode != null) continue;
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Unrecognized option: %s", args[i])));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        args = VSCommandUtil.toProperArgs(args);
        ConfigCommandNode currentNode = this.root;
        if (args.length == 0) {
            return this.root.childrenNames();
        }
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
            if (!(currentNode instanceof ConfigCommandParentNode)) continue;
            ConfigCommandNode nextNode = currentNode.getChild(args[i]);
            if (nextNode == null) {
                return currentNode.getChildrenStartingWith(args[i]).stream().map(ConfigCommandNode::getName).collect(Collectors.toList());
            }
            if (i == args.length - 1) {
                if (nextNode instanceof ConfigCommandParentNode) {
                    return ((ConfigCommandParentNode)nextNode).childrenNames();
                }
                if (!(nextNode instanceof ConfigCommandEndNode)) continue;
                return ((ConfigCommandEndNode)nextNode).getAutocompletions();
            }
            currentNode = nextNode;
        }
        return Collections.emptyList();
    }
}

