/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.valkyrienskies.mod.common.command.config.ConfigCommandNode;

class ConfigCommandParentNode
extends ConfigCommandNode {
    private Map<String, ConfigCommandNode> children;

    ConfigCommandParentNode(String name, List<ConfigCommandNode> children) {
        super(name);
        this.children = new HashMap<String, ConfigCommandNode>(children.stream().collect(Collectors.toMap(c -> c.getName().toLowerCase(), c -> c)));
    }

    ConfigCommandParentNode(String name) {
        super(name);
        this.children = new HashMap<String, ConfigCommandNode>();
    }

    ConfigCommandParentNode(String name, Map<String, ConfigCommandNode> children) {
        super(name);
        this.children = new HashMap<String, ConfigCommandNode>(children);
    }

    void addChild(ConfigCommandNode node) {
        this.children.put(node.getName().toLowerCase(), node);
    }

    @Nullable
    ConfigCommandNode getChild(String name) {
        return this.children.get(name.toLowerCase());
    }

    List<String> childrenNames() {
        return this.children.values().stream().map(ConfigCommandNode::getName).collect(Collectors.toList());
    }

    List<ConfigCommandNode> getChildrenStartingWith(String prefix) {
        return this.children.values().stream().filter(c -> c.getName().toLowerCase().startsWith(prefix.toLowerCase())).collect(Collectors.toList());
    }

    public Map<String, ConfigCommandNode> getChildren() {
        return this.children;
    }
}

