/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command.config;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.valkyrienskies.mod.common.command.config.ConfigCommandNode;
import org.valkyrienskies.mod.common.command.config.ConfigCommandUtils;
import org.valkyrienskies.mod.common.command.config.ShortName;

class ConfigCommandEndNode
extends ConfigCommandNode {
    private final Consumer<String> optionSetter;
    private final Supplier<?> optionGetter;
    private final List<String> autocompletions;

    ConfigCommandEndNode(Field field, @Nullable Object object) {
        this(ConfigCommandEndNode.getName(field), str -> ConfigCommandUtils.setFieldFromString(str, field, object), () -> ConfigCommandUtils.getStringFromField(field, object), ConfigCommandUtils.getAutocompletions(field));
    }

    private static String getName(Field field) {
        return Optional.ofNullable(field.getAnnotation(ShortName.class)).map(ShortName::value).orElseGet(field::getName);
    }

    ConfigCommandEndNode(String name, Consumer<String> optionSetter, Supplier<?> getOption, List<String> autocompletions) {
        super(name);
        this.optionSetter = optionSetter;
        this.optionGetter = getOption;
        this.autocompletions = autocompletions;
    }

    public Consumer<String> getOptionSetter() {
        return this.optionSetter;
    }

    public Supplier<?> getOptionGetter() {
        return this.optionGetter;
    }

    public List<String> getAutocompletions() {
        return this.autocompletions;
    }
}

