/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.collision;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.collision.CollisionInformationHolder;
import org.valkyrienskies.mod.common.collision.ShipCollisionTask;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import org.valkyrienskies.mod.common.ships.block_relocation.SpatialDetector;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.datastructures.IBitOctree;
import org.valkyrienskies.mod.common.util.datastructures.ITerrainOctreeProvider;
import valkyrienwarfare.api.TransformType;

public class WorldPhysicsCollider {
    public static final double AABB_EXPANSION = 2.0;
    public static final double RANGE_CHECK = 1.8;
    public static final double AXIS_TOLERANCE = 0.3;
    public static final double CACHE_UPDATE_PERIOD = 0.01;
    public static final double COEFFICIENT_OF_RESTITUTION = 0.52;
    public static final double KINETIC_FRICTION_COEFFICIENT = 0.15;
    private final ThreadLocalRandom rand;
    private final Collection<ShipCollisionTask> tasks;
    private final PhysicsCalculations calculator;
    private final PhysicsObject parent;
    private final TIntList cachedPotentialHits;
    private final TIntArrayList cachedHitsToRemove;
    private double ticksSinceCacheUpdate;
    private boolean updateCollisionTasksCache;
    private BlockPos centerPotentialHit;
    private static final byte[] combinationsOfOnes = new byte[]{1, 1, 1, 1, 1, -1, 1, -1, 1, 1, -1, -1, -1, 1, 1, -1, 1, -1, -1, -1, 1, -1, -1, -1};
    private final Vector3d temp0 = new Vector3d();
    private final Vector3d temp1 = new Vector3d();
    private final Vector3d temp2 = new Vector3d();
    private final Vector3d temp3 = new Vector3d();
    private static final double SPHERE_RADIUS = 0.25;

    public WorldPhysicsCollider(PhysicsCalculations calculations) {
        this.calculator = calculations;
        this.parent = calculations.getParent();
        this.cachedPotentialHits = new TIntArrayList();
        this.cachedHitsToRemove = new TIntArrayList();
        this.rand = ThreadLocalRandom.current();
        this.tasks = new ArrayList<ShipCollisionTask>();
        this.ticksSinceCacheUpdate = 25.0;
        this.updateCollisionTasksCache = true;
        this.centerPotentialHit = null;
    }

    public void tickUpdatingTheCollisionCache() {
        this.ticksSinceCacheUpdate += this.calculator.getPhysicsTimeDeltaPerPhysTick();
        for (int i = 0; i < this.cachedHitsToRemove.size(); ++i) {
            this.cachedPotentialHits.remove(this.cachedHitsToRemove.get(i));
        }
        this.cachedHitsToRemove.resetQuick();
        if (this.ticksSinceCacheUpdate > 0.01) {
            this.updatePotentialCollisionCache();
            this.updateCollisionTasksCache = true;
        }
    }

    public void splitIntoCollisionTasks(List<ShipCollisionTask> toAdd) {
        if (this.updateCollisionTasksCache) {
            this.tasks.clear();
            int size = this.cachedPotentialHits.size();
            for (int index = 0; index < size; index += 45) {
                ShipCollisionTask task = new ShipCollisionTask(this, index);
                this.tasks.add(task);
            }
            this.updateCollisionTasksCache = false;
        }
        this.cachedPotentialHits.shuffle((Random)this.rand);
        toAdd.addAll(this.tasks);
    }

    public void processCollisionTask(ShipCollisionTask task) {
        BlockPos.MutableBlockPos inWorldPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos inLocalPos = new BlockPos.MutableBlockPos();
        Iterator<CollisionInformationHolder> collisionIterator = task.getCollisionInformationIterator();
        while (collisionIterator.hasNext()) {
            CollisionInformationHolder info = collisionIterator.next();
            inWorldPos.func_181079_c(info.inWorldX, info.inWorldY, info.inWorldZ);
            inLocalPos.func_181079_c(info.inLocalX, info.inLocalY, info.inLocalZ);
            this.handleActualCollision((BlockPos)inWorldPos, (BlockPos)inLocalPos, info.inWorldState, info.inLocalState);
        }
        task.getCollisionInformationGenerated().clear();
    }

    private boolean handleActualCollision(BlockPos inWorldPos, BlockPos inLocalPos, IBlockState inWorldState, IBlockState inLocalState) {
        ShipTransform parentTransform = this.parent.getShipTransformationManager().getCurrentPhysicsTransform();
        boolean isXUpSolid = this.isBlockInWorldSolidFast(inWorldPos.func_177958_n() + 1, inWorldPos.func_177956_o(), inWorldPos.func_177952_p());
        boolean isXDownSolid = this.isBlockInWorldSolidFast(inWorldPos.func_177958_n() - 1, inWorldPos.func_177956_o(), inWorldPos.func_177952_p());
        boolean isYUpSolid = this.isBlockInWorldSolidFast(inWorldPos.func_177958_n(), inWorldPos.func_177956_o() + 1, inWorldPos.func_177952_p());
        boolean isYDownSolid = this.isBlockInWorldSolidFast(inWorldPos.func_177958_n(), inWorldPos.func_177956_o() - 1, inWorldPos.func_177952_p());
        boolean isZUpSolid = this.isBlockInWorldSolidFast(inWorldPos.func_177958_n(), inWorldPos.func_177956_o(), inWorldPos.func_177952_p() + 1);
        boolean isZDownSolid = this.isBlockInWorldSolidFast(inWorldPos.func_177958_n(), inWorldPos.func_177956_o(), inWorldPos.func_177952_p() - 1);
        if (isXUpSolid && isXDownSolid && isYUpSolid && isYDownSolid && isZUpSolid && isZDownSolid) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            Vector3d response;
            Vector3d axis;
            byte xAxis = combinationsOfOnes[i * 3];
            byte yAxis = combinationsOfOnes[i * 3 + 1];
            byte zAxis = combinationsOfOnes[i * 3 + 2];
            Vector3d shipBlockInLocal = this.temp0.set((double)inLocalPos.func_177958_n() + 0.5 + (double)xAxis * 0.25, (double)inLocalPos.func_177956_o() + 0.5 + (double)yAxis * 0.25, (double)inLocalPos.func_177952_p() + 0.5 + (double)zAxis * 0.25);
            Vector3d shipBlockInGlobal = parentTransform.transformPositionNew(this.temp1.set(shipBlockInLocal), TransformType.SUBSPACE_TO_GLOBAL);
            double xUpOffset = 0.5 - (shipBlockInGlobal.x() - ((double)inWorldPos.func_177958_n() + 0.5)) + 0.25;
            double xDownOffset = 0.5 - ((double)inWorldPos.func_177958_n() + 0.5 - shipBlockInGlobal.x()) + 0.25;
            double yUpOffset = 0.5 - (shipBlockInGlobal.y() - ((double)inWorldPos.func_177956_o() + 0.5)) + 0.25;
            double yDownOffset = 0.5 - ((double)inWorldPos.func_177956_o() + 0.5 - shipBlockInGlobal.y()) + 0.25;
            double zUpOffset = 0.5 - (shipBlockInGlobal.z() - ((double)inWorldPos.func_177952_p() + 0.5)) + 0.25;
            double zDownOffset = 0.5 - ((double)inWorldPos.func_177952_p() + 0.5 - shipBlockInGlobal.z()) + 0.25;
            if (isXUpSolid) {
                xUpOffset = 1.0;
            }
            if (isXDownSolid) {
                xDownOffset = 1.0;
            }
            if (isYUpSolid) {
                yUpOffset = 1.0;
            }
            if (isYDownSolid) {
                yDownOffset = 1.0;
            }
            if (isZUpSolid) {
                zUpOffset = 1.0;
            }
            if (isZDownSolid) {
                zDownOffset = 1.0;
            }
            if (!(xUpOffset > 0.0) || !(xDownOffset > 0.0) || !(yUpOffset > 0.0) || !(yDownOffset > 0.0) || !(zUpOffset > 0.0) || !(zDownOffset > 0.0)) continue;
            double THRESHOLD = 0.1;
            if (Math.abs(xUpOffset) < 0.1 && Math.abs(xDownOffset) < 0.1 && Math.abs(zUpOffset) < 0.1 && Math.abs(zDownOffset) < 0.1 && (!isYUpSolid || !isYDownSolid)) {
                if (yUpOffset < yDownOffset) {
                    axis = this.temp2.set(0.0, -1.0, 0.0);
                    response = axis.mul(yUpOffset, this.temp3);
                } else {
                    axis = this.temp2.set(0.0, 1.0, 0.0);
                    response = axis.mul(yDownOffset, this.temp3);
                }
            } else if (xUpOffset < xDownOffset && xUpOffset < yUpOffset && xUpOffset < yDownOffset && xUpOffset < zUpOffset && xUpOffset < zDownOffset) {
                axis = this.temp2.set(-1.0, 0.0, 0.0);
                response = axis.mul(xUpOffset, this.temp3);
            } else if (xDownOffset < yUpOffset && xDownOffset < yDownOffset && xDownOffset < zUpOffset && xDownOffset < zDownOffset) {
                axis = this.temp2.set(1.0, 0.0, 0.0);
                response = axis.mul(xDownOffset, this.temp3);
            } else if (yUpOffset < yDownOffset && yUpOffset < zUpOffset && yUpOffset < zDownOffset) {
                axis = this.temp2.set(0.0, -1.0, 0.0);
                response = axis.mul(yUpOffset, this.temp3);
            } else if (yDownOffset < zUpOffset && yDownOffset < zDownOffset) {
                axis = this.temp2.set(0.0, 1.0, 0.0);
                response = axis.mul(yDownOffset, this.temp3);
            } else if (zUpOffset < zDownOffset) {
                axis = this.temp2.set(0.0, 0.0, -1.0);
                response = axis.mul(zUpOffset, this.temp3);
            } else {
                axis = this.temp2.set(0.0, 0.0, 1.0);
                response = axis.mul(zDownOffset, this.temp3);
            }
            this.handleCollision(shipBlockInGlobal, axis, response, 1.0);
        }
        return false;
    }

    private boolean isBlockInWorldSolidFast(int posX, int posY, int posZ) {
        if (posY < 0 || posY >= 256) {
            return false;
        }
        ChunkCache surroundingChunks = this.parent.getCachedSurroundingChunks();
        int relativeChunkX = (posX >> 4) - surroundingChunks.field_72818_a;
        int relativeChunkZ = (posZ >> 4) - surroundingChunks.field_72816_b;
        if (relativeChunkX < 0 || relativeChunkX >= surroundingChunks.field_72817_c.length || relativeChunkZ < 0 || relativeChunkZ >= surroundingChunks.field_72817_c[relativeChunkX].length) {
            return false;
        }
        Chunk chunk = surroundingChunks.field_72817_c[relativeChunkX][relativeChunkZ];
        if (chunk == null) {
            return false;
        }
        ExtendedBlockStorage blockStorage = chunk.field_76652_q[posY >> 4];
        if (blockStorage == null) {
            return false;
        }
        IBitOctree octree = ((ITerrainOctreeProvider)ITerrainOctreeProvider.class.cast(blockStorage.field_177488_d)).getSolidOctree();
        return octree.get(posX & 0xF, posY & 0xF, posZ & 0xF);
    }

    private void handleCollision(Vector3dc collisionPos, Vector3dc axis, Vector3dc offsetVector, double impulseApplied) {
        Vector3d inBody = new Vector3d(collisionPos.x() - this.parent.getShipTransform().getPosX(), collisionPos.y() - this.parent.getShipTransform().getPosY(), collisionPos.z() - this.parent.getShipTransform().getPosZ());
        Vector3d momentumAtPoint = this.calculator.getVelocityAtPoint(inBody);
        this.calculateCollisionImpulseForce(inBody, momentumAtPoint, axis, offsetVector, false, false, impulseApplied);
    }

    private void calculateCollisionImpulseForce(Vector3dc inBody, Vector3d velocityAtPointOfCollision, Vector3dc axis, Vector3dc offsetVector, boolean didBlockBreakInShip, boolean didBlockBreakInWorld, double impulseApplied) {
        Vector3d collisionImpulseForce;
        double multiplier = 2.0;
        velocityAtPointOfCollision.add(offsetVector.x() * 2.0, offsetVector.y() * 2.0, offsetVector.z() * 2.0);
        Vector3d firstCross = inBody.cross(axis, new Vector3d());
        this.calculator.getPhysInvMOITensor().transform(firstCross);
        Vector3d secondCross = firstCross.cross(inBody);
        double impulseMagnitude = -velocityAtPointOfCollision.dot(axis) / (this.calculator.getInvMass() + secondCross.dot(axis));
        double slopR = 0.5;
        double collisionSpeed = Math.abs(velocityAtPointOfCollision.dot(axis));
        if (collisionSpeed > 0.5) {
            impulseMagnitude *= 1.52;
        }
        if ((collisionImpulseForce = axis.mul(impulseMagnitude, new Vector3d())).dot(offsetVector) < 0.0 && collisionImpulseForce.dot(inBody) < 0.0) {
            double collisionVelocity = velocityAtPointOfCollision.dot(axis);
            this.addFrictionToNormalForce(velocityAtPointOfCollision, collisionImpulseForce, inBody);
            this.calculator.getLinearVelocity().add(collisionImpulseForce.mul(this.calculator.getInvMass(), new Vector3d()));
            Vector3d thirdCross = inBody.cross(collisionImpulseForce, new Vector3d());
            this.calculator.getPhysInvMOITensor().transform(thirdCross);
            this.calculator.getAngularVelocity().add(thirdCross, this.calculator.getAngularVelocity());
        }
    }

    private void addFrictionToNormalForce(Vector3dc momentumAtPoint, Vector3d impulseVector, Vector3dc inBody) {
        double thirdCoefficient;
        Vector3d contactNormal = new Vector3d(impulseVector);
        contactNormal.normalize();
        Vector3d frictionVector = new Vector3d(momentumAtPoint);
        frictionVector.normalize();
        frictionVector.mul(impulseVector.length() * 0.15);
        if (frictionVector.dot(momentumAtPoint) > 0.0) {
            frictionVector.mul(-1.0);
        }
        double frictionImpulseDot = frictionVector.dot(contactNormal);
        Vector3d toRemove = contactNormal.mul(frictionImpulseDot, new Vector3d());
        frictionVector.sub(toRemove);
        double inertiaScalarAlongAxis = this.parent.getPhysicsCalculations().getInertiaAlongRotationAxis();
        Vector3d initialVelocity = this.parent.getPhysicsCalculations().getLinearVelocity();
        Vector3d deltaVelocity = new Vector3d(frictionVector);
        deltaVelocity.mul(this.parent.getPhysicsCalculations().getInvMass() * this.parent.getPhysicsCalculations().getDragForPhysTick());
        double A = initialVelocity.lengthSquared();
        double B = 2.0 * initialVelocity.dot(deltaVelocity);
        double C = deltaVelocity.lengthSquared();
        Vector3d initialAngularVelocity = new Vector3d(this.parent.getPhysicsCalculations().getAngularVelocity());
        Vector3d deltaAngularVelocity = inBody.cross(frictionVector, new Vector3d());
        deltaAngularVelocity.mul(this.parent.getPhysicsCalculations().getDragForPhysTick() / inertiaScalarAlongAxis);
        double D = initialAngularVelocity.lengthSquared();
        double E = 2.0 * deltaAngularVelocity.dot(initialAngularVelocity);
        double F = deltaAngularVelocity.lengthSquared();
        if (initialAngularVelocity.lengthSquared() < 0.05 && initialVelocity.lengthSquared() < 0.05) {
            F = 0.0;
            E = 0.0;
            D = 0.0;
        }
        double firstCoefficient = A * this.parent.getPhysicsCalculations().getMass() + D * inertiaScalarAlongAxis;
        double secondCoefficient = B * this.parent.getPhysicsCalculations().getMass() + E * inertiaScalarAlongAxis;
        double scaleFactor = -secondCoefficient / ((thirdCoefficient = C * this.parent.getPhysicsCalculations().getMass() + F * inertiaScalarAlongAxis) * 2.0);
        if (new Double(scaleFactor).isNaN()) {
            scaleFactor = 0.0;
        } else {
            scaleFactor = Math.max(0.0, Math.min(scaleFactor, 1.0));
            frictionVector.mul(scaleFactor);
        }
        impulseVector.add(frictionVector);
    }

    private void updatePotentialCollisionCache() {
        this.ticksSinceCacheUpdate = 0.0;
        if (Math.random() > 0.5) {
            this.ticksSinceCacheUpdate -= 0.05;
        }
        int oldSize = this.cachedPotentialHits.size();
        this.cachedPotentialHits.clear();
        AxisAlignedBB shipBBOriginal = this.parent.getPhysicsTransformAABB();
        if (shipBBOriginal == null) {
            return;
        }
        AxisAlignedBB shipBB = shipBBOriginal.func_186662_g(3.0);
        AxisAlignedBB collisionBB = shipBB.func_186662_g(2.0).func_72321_a(this.calculator.getLinearVelocity().x * 0.2, this.calculator.getLinearVelocity().y * 0.2, this.calculator.getLinearVelocity().z * 0.2);
        if (collisionBB.field_72337_e < 0.0 || collisionBB.field_72338_b > 255.0) {
            return;
        }
        BlockPos min = new BlockPos(collisionBB.field_72340_a, Math.max(collisionBB.field_72338_b - 1.0, 0.0), collisionBB.field_72339_c);
        BlockPos max = new BlockPos(collisionBB.field_72336_d, Math.min(collisionBB.field_72337_e, 255.0), collisionBB.field_72334_f);
        this.centerPotentialHit = new BlockPos((double)(min.func_177958_n() + max.func_177958_n()) / 2.0, (double)(min.func_177956_o() + max.func_177956_o()) / 2.0, (double)(min.func_177952_p() + max.func_177952_p()) / 2.0);
        ChunkCache cache = this.parent.getCachedSurroundingChunks();
        if (cache == null) {
            System.err.println("VS Cached Surrounding Chunks was null! This is going to cause catastophric terrible events!!");
            return;
        }
        int chunkMinX = min.func_177958_n() >> 4;
        int chunkMaxX = (max.func_177958_n() >> 4) + 1;
        int chunkMinZ = min.func_177952_p() >> 4;
        int chunkMaxZ = (max.func_177952_p() >> 4) + 1;
        int minX = min.func_177958_n();
        int minY = min.func_177956_o();
        int minZ = min.func_177952_p();
        int maxX = max.func_177958_n();
        int maxY = max.func_177956_o();
        int maxZ = max.func_177952_p();
        if (VSConfig.MULTITHREADING_SETTINGS.multithreadCollisionCacheUpdate && this.parent.getBlockPositions().size() > 100) {
            ArrayList<ImmutableTriple> tasks = new ArrayList<ImmutableTriple>();
            for (int chunkX = chunkMinX; chunkX < chunkMaxX; ++chunkX) {
                for (int chunkZ = chunkMinZ; chunkZ < chunkMaxZ; ++chunkZ) {
                    tasks.add(new ImmutableTriple((Object)chunkX, (Object)chunkZ, (Object)new TIntArrayList()));
                }
            }
            Consumer<Triple> consumer = i -> this.updateCollisionCacheSequential(cache, (Integer)i.getLeft(), (Integer)i.getMiddle(), minX, minY, minZ, maxX, maxY, maxZ, shipBB, (TIntList)i.getRight());
            ((ForkJoinTask)ValkyrienSkiesMod.getPhysicsThreadPool().submit(() -> tasks.parallelStream().forEach(consumer))).join();
            tasks.forEach(task -> this.cachedPotentialHits.addAll((TIntCollection)task.getRight()));
        } else {
            double size = (double)(chunkMaxX - chunkMinX) * (double)(chunkMaxZ - chunkMinZ);
            if (size > 300000.0) {
                return;
            }
            for (int chunkX = chunkMinX; chunkX < chunkMaxX; ++chunkX) {
                for (int chunkZ = chunkMinZ; chunkZ < chunkMaxZ; ++chunkZ) {
                    this.updateCollisionCacheSequential(cache, chunkX, chunkZ, minX, minY, minZ, maxX, maxY, maxZ, shipBB, this.cachedPotentialHits);
                }
            }
        }
    }

    private void updateCollisionCacheSequential(ChunkCache cache, int chunkX, int chunkZ, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, AxisAlignedBB shipBB, TIntList output) {
        int arrayChunkX = chunkX - cache.field_72818_a;
        int arrayChunkZ = chunkZ - cache.field_72816_b;
        if (arrayChunkX >= 0 && arrayChunkZ >= 0 && arrayChunkX <= cache.field_72817_c.length - 1 && arrayChunkZ <= cache.field_72817_c[0].length - 1 && cache.field_72817_c[arrayChunkX][arrayChunkZ] != null) {
            Vector3d temp1 = new Vector3d();
            Vector3d temp2 = new Vector3d();
            Vector3d temp3 = new Vector3d();
            Chunk chunk = cache.field_72817_c[arrayChunkX][arrayChunkZ];
            for (int storageY = minY >> 4; storageY <= maxY >> 4; ++storageY) {
                ExtendedBlockStorage extendedblockstorage = chunk.field_76652_q[storageY];
                if (extendedblockstorage == null) continue;
                int minStorageX = chunkX << 4;
                int minStorageY = storageY << 4;
                int minStorageZ = chunkZ << 4;
                int maxStorageX = minStorageX + 16;
                int maxStorageY = minStorageY + 16;
                int maxStorageZ = minStorageZ + 16;
                ITerrainOctreeProvider provider = (ITerrainOctreeProvider)extendedblockstorage.field_177488_d;
                IBitOctree octree = provider.getSolidOctree();
                for (int x = minStorageX; x < maxStorageX; ++x) {
                    for (int y = minStorageY; y < maxStorageY; ++y) {
                        for (int z = minStorageZ; z < maxStorageZ; ++z) {
                            this.checkForCollision(x, y, z, extendedblockstorage, octree, temp1, temp2, temp3, shipBB, output);
                        }
                    }
                }
            }
        }
    }

    private void checkForCollision(int x, int y, int z, ExtendedBlockStorage storage, IBitOctree octree, Vector3d inLocal, Vector3d inBody, Vector3d speedInBody, AxisAlignedBB shipBB, TIntList output) {
        if (octree.get(x & 0xF, y & 0xF, z & 0xF)) {
            inLocal.x = (double)x + 0.5;
            inLocal.y = (double)y + 0.5;
            inLocal.z = (double)z + 0.5;
            if (inLocal.x > shipBB.field_72340_a && inLocal.x < shipBB.field_72336_d && inLocal.y > shipBB.field_72338_b && inLocal.y < shipBB.field_72337_e && inLocal.z > shipBB.field_72339_c && inLocal.z < shipBB.field_72334_f) {
                int maxZ;
                int minZ;
                int maxY;
                int minY;
                int maxX;
                int minX;
                this.parent.getShipTransformationManager().getCurrentPhysicsTransform().transformPosition(inLocal, TransformType.GLOBAL_TO_SUBSPACE);
                inLocal.sub(this.parent.getCenterCoord(), inBody);
                speedInBody.zero();
                if (speedInBody.x > 0.0) {
                    minX = MathHelper.func_76128_c((double)(inLocal.x - 1.8));
                    maxX = MathHelper.func_76128_c((double)(inLocal.x + 1.8 + speedInBody.x));
                } else {
                    minX = MathHelper.func_76128_c((double)(inLocal.x - 1.8 + speedInBody.x));
                    maxX = MathHelper.func_76128_c((double)(inLocal.x + 1.8));
                }
                if (speedInBody.y > 0.0) {
                    minY = MathHelper.func_76128_c((double)(inLocal.y - 1.8));
                    maxY = MathHelper.func_76128_c((double)(inLocal.y + 1.8 + speedInBody.y));
                } else {
                    minY = MathHelper.func_76128_c((double)(inLocal.y - 1.8 + speedInBody.y));
                    maxY = MathHelper.func_76128_c((double)(inLocal.y + 1.8));
                }
                if (speedInBody.z > 0.0) {
                    minZ = MathHelper.func_76128_c((double)(inLocal.z - 1.8));
                    maxZ = MathHelper.func_76128_c((double)(inLocal.z + 1.8 + speedInBody.z));
                } else {
                    minZ = MathHelper.func_76128_c((double)(inLocal.z - 1.8 + speedInBody.z));
                    maxZ = MathHelper.func_76128_c((double)(inLocal.z + 1.8));
                }
                minY = Math.min(255, Math.max(minY, 0));
                maxY = Math.min(255, Math.max(maxY, 0));
                Chunk chunkIn00 = this.parent.getChunkClaim().containsChunk(minX >> 4, minZ >> 4) ? this.parent.getChunkAt(minX >> 4, minZ >> 4) : null;
                Chunk chunkIn01 = this.parent.getChunkClaim().containsChunk(minX >> 4, maxZ >> 4) ? this.parent.getChunkAt(minX >> 4, maxZ >> 4) : null;
                Chunk chunkIn10 = this.parent.getChunkClaim().containsChunk(maxX >> 4, minZ >> 4) ? this.parent.getChunkAt(maxX >> 4, minZ >> 4) : null;
                Chunk chunkIn11 = this.parent.getChunkClaim().containsChunk(maxX >> 4, maxZ >> 4) ? this.parent.getChunkAt(maxX >> 4, maxZ >> 4) : null;
                block0: for (int localX = minX; localX < maxX; ++localX) {
                    for (int localZ = minZ; localZ < maxZ; ++localZ) {
                        Chunk theChunk = localX >> 4 == minX >> 4 ? (localZ >> 4 == minZ >> 4 ? chunkIn00 : chunkIn01) : (localZ >> 4 == minZ >> 4 ? chunkIn10 : chunkIn11);
                        if (theChunk == null) continue;
                        for (int localY = minY; localY < maxY; ++localY) {
                            boolean result = this.checkForCollisionFast(theChunk, localX, localY, localZ, x, y, z, output);
                            if (result) break block0;
                        }
                    }
                }
            }
        }
    }

    private boolean checkForCollisionFast(Chunk chunk, int localX, int localY, int localZ, int x, int y, int z, TIntList output) {
        ITerrainOctreeProvider provider;
        IBitOctree octreeInLocal;
        if (chunk.field_76652_q[localY >> 4] != null && (octreeInLocal = (provider = (ITerrainOctreeProvider)chunk.field_76652_q[localY >> 4].func_186049_g()).getSolidOctree()).get(localX & 0xF, localY & 0xF, localZ & 0xF)) {
            int hash = SpatialDetector.getHashWithRespectTo(x, y, z, this.centerPotentialHit);
            output.add(hash);
            return true;
        }
        return false;
    }

    public BlockPos getCenterPotentialHit() {
        return this.centerPotentialHit;
    }

    public int getCachedPotentialHit(int offset) {
        return this.cachedPotentialHits.get(offset);
    }

    public int getCachedPotentialHitSize() {
        return this.cachedPotentialHits.size();
    }

    public PhysicsObject getParent() {
        return this.parent;
    }
}

