/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.collision;

import gnu.trove.list.TIntList;
import java.util.concurrent.Callable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import org.valkyrienskies.mod.common.ships.block_relocation.SpatialDetector;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.datastructures.IBitOctree;
import org.valkyrienskies.mod.common.util.datastructures.ITerrainOctreeProvider;
import valkyrienwarfare.api.TransformType;

public class WaterForcesTask
implements Callable<Void> {
    public static final int MAX_TASKS_TO_CHECK = 500;
    private static final double SPHERE_RADIUS = 0.5;
    private static final double GRAVITY_ACCELERATION = 9.8;
    private static final double MASS_OF_CUBIC_METER_OF_WATER = 1000.0;
    private static final double DENSITY_OF_WATER = 1000.0;
    private static final double DRAG_COEFFICIENT_OF_WATER = 0.3;
    private static final double AABB_RADIUS = 0.5;
    private final PhysicsObject parent;
    private final BlockPos colliderCenter;
    private final TIntList waterHitsToCheck;
    private final int minHitIndex;
    private final int maxHitIndex;
    private final Vector3d addedForce;
    private final Vector3d addedTorque;
    private static final double VECTOR_LENGTH_SQUARED_ZERO_THRESHOLD = 0.01;

    public WaterForcesTask(PhysicsObject parent, BlockPos colliderCenter, TIntList waterHitsToCheck, int minHitIndex, int maxHitIndex) {
        this.parent = parent;
        this.colliderCenter = colliderCenter;
        this.waterHitsToCheck = waterHitsToCheck;
        this.minHitIndex = minHitIndex;
        this.maxHitIndex = maxHitIndex;
        this.addedForce = new Vector3d();
        this.addedTorque = new Vector3d();
    }

    public void addForcesToShip() {
        PhysicsCalculations physicsEngine = this.parent.getPhysicsCalculations();
        physicsEngine.addForceAndTorque(this.addedForce, this.addedTorque);
    }

    @Override
    public Void call() {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        ShipTransform physicsTransform = this.parent.getShipTransformationManager().getCurrentPhysicsTransform();
        PhysicsCalculations physicsEngine = this.parent.getPhysicsCalculations();
        Vector3d temp0 = new Vector3d();
        Vector3d temp1 = new Vector3d();
        Vector3d temp2 = new Vector3d();
        Vector3d temp3 = new Vector3d();
        Vector3d temp4 = new Vector3d();
        Vector3d temp5 = new Vector3d();
        Vector3d temp6 = new Vector3d();
        Vector3d temp7 = new Vector3d();
        Vector3d temp8 = new Vector3d();
        Vector3d temp9 = new Vector3d();
        for (int index = this.minHitIndex; index <= this.maxHitIndex; ++index) {
            int waterHitPosHash = this.waterHitsToCheck.get(index);
            SpatialDetector.setPosWithRespectTo(waterHitPosHash, this.colliderCenter, currentPos);
            Vector3d waterPosInShipSpace = physicsTransform.transformPositionNew(JOML.convertDouble((Vec3i)currentPos, temp0).add(0.5, 0.5, 0.5), TransformType.GLOBAL_TO_SUBSPACE);
            int minX = (int)Math.floor(waterPosInShipSpace.x() - 0.5);
            int minY = (int)Math.floor(waterPosInShipSpace.y() - 0.5);
            int minZ = (int)Math.floor(waterPosInShipSpace.z() - 0.5);
            int maxX = (int)Math.ceil(waterPosInShipSpace.x() + 0.5);
            int maxY = (int)Math.ceil(waterPosInShipSpace.y() + 0.5);
            int maxZ = (int)Math.ceil(waterPosInShipSpace.z() + 0.5);
            Vector3d waterPosInWorld = JOML.convertDouble((Vec3i)currentPos, temp1).add(0.5, 0.5, 0.5);
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Chunk chunk;
                    Chunk chunk2 = chunk = this.parent.getChunkClaim().containsChunk(x >> 4, z >> 4) ? this.parent.getChunkAt(x >> 4, z >> 4) : null;
                    if (chunk == null) continue;
                    for (int y = minY; y <= maxY; ++y) {
                        IBitOctree terrainOctree;
                        ExtendedBlockStorage blockStorage = chunk.field_76652_q[y >> 4];
                        if (blockStorage == null || !(terrainOctree = ((ITerrainOctreeProvider)blockStorage.field_177488_d).getSolidOctree()).get(x & 0xF, y & 0xF, z & 0xF)) continue;
                        Vector3d shipSolidBlockPosInWorld = physicsTransform.transformPositionNew(temp2.set((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), TransformType.SUBSPACE_TO_GLOBAL);
                        double volumeDisplaced = WaterForcesTask.calculateAABBOverlap(waterPosInWorld.x() - shipSolidBlockPosInWorld.x(), waterPosInWorld.y() - shipSolidBlockPosInWorld.y(), waterPosInWorld.z() - shipSolidBlockPosInWorld.z());
                        if (volumeDisplaced <= 0.0) continue;
                        Vector3d collisionPosInWorld = shipSolidBlockPosInWorld.add(waterPosInWorld, temp3).mul(0.5);
                        Vector3d buoyancyForce = temp4.set(0.0, volumeDisplaced * 9.8 * 1000.0, 0.0);
                        Vector3d collisionPosRelativeToShipCenterInWorld = temp5.set(collisionPosInWorld).sub(physicsTransform.getPosX(), physicsTransform.getPosY(), physicsTransform.getPosZ());
                        this.addForceAtPoint(collisionPosRelativeToShipCenterInWorld, buoyancyForce, temp7);
                        Vector3d velocity = physicsEngine.getVelocityAtPoint(collisionPosRelativeToShipCenterInWorld, temp9);
                        if (WaterForcesTask.isVectorLengthZero(velocity)) continue;
                        double distance = waterPosInWorld.distance(shipSolidBlockPosInWorld);
                        double area = Math.PI * (0.5 - distance * 0.5) * (0.5 - distance * 0.5);
                        double velocitySquared = velocity.lengthSquared();
                        double forceMagnitude = 500.0 * velocitySquared * 0.3 * area;
                        Vector3d dragForce = temp6.set(velocity).normalize().mul(-forceMagnitude);
                        this.addForceAtPoint(collisionPosRelativeToShipCenterInWorld, dragForce, temp8);
                    }
                }
            }
        }
        return null;
    }

    private void addForceAtPoint(Vector3dc posRelToShipCenter, Vector3dc forceToApply, Vector3d tempStorage) {
        Vector3d torqueFromForce = posRelToShipCenter.cross(forceToApply, tempStorage);
        this.addedForce.add(forceToApply);
        this.addedTorque.add(torqueFromForce);
    }

    private static double calculateAABBOverlap(double xOffset, double yOffset, double zOffset) {
        xOffset = Math.abs(xOffset);
        yOffset = Math.abs(yOffset);
        zOffset = Math.abs(zOffset);
        if (xOffset >= 1.0 || yOffset >= 1.0 || zOffset >= 1.0) {
            return 0.0;
        }
        return (1.0 - xOffset) * (1.0 - yOffset) * (1.0 - zOffset);
    }

    private static boolean isVectorLengthZero(Vector3dc vector) {
        return vector.lengthSquared() < 0.01;
    }
}

