/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.collision;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.collision.CollisionInformationHolder;
import org.valkyrienskies.mod.common.collision.WorldPhysicsCollider;
import org.valkyrienskies.mod.common.ships.block_relocation.SpatialDetector;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.util.VSIterationUtils;
import org.valkyrienskies.mod.common.util.datastructures.IBitOctree;
import org.valkyrienskies.mod.common.util.datastructures.ITerrainOctreeProvider;
import valkyrienwarfare.api.TransformType;

public class ShipCollisionTask
implements Callable<Void> {
    public static final int MAX_TASKS_TO_CHECK = 45;
    private final WorldPhysicsCollider toTask;
    private final int taskStartIndex;
    private final int tasksToCheck;
    private final BlockPos.MutableBlockPos mutablePos;
    private final BlockPos.MutableBlockPos inLocalPos;
    private final Vector3d inWorld;
    private final List<CollisionInformationHolder> collisionInformationGenerated;
    private IBlockState inWorldState;
    private final Vector3d temp0 = new Vector3d();

    public ShipCollisionTask(WorldPhysicsCollider toTask, int taskStartIndex) {
        this.taskStartIndex = taskStartIndex;
        this.toTask = toTask;
        this.mutablePos = new BlockPos.MutableBlockPos();
        this.inLocalPos = new BlockPos.MutableBlockPos();
        this.inWorld = new Vector3d();
        this.collisionInformationGenerated = new ArrayList<CollisionInformationHolder>();
        this.inWorldState = null;
        int size = toTask.getCachedPotentialHitSize();
        this.tasksToCheck = taskStartIndex + 45 > size + 1 ? size + 1 - taskStartIndex : 45;
    }

    @Override
    public Void call() {
        for (int index = this.taskStartIndex; index < this.tasksToCheck + 1; ++index) {
            int integer = this.toTask.getCachedPotentialHit(index);
            this.processNumber(integer);
        }
        Collections.shuffle(this.collisionInformationGenerated, ThreadLocalRandom.current());
        return null;
    }

    public List<CollisionInformationHolder> getCollisionInformationGenerated() {
        return this.collisionInformationGenerated;
    }

    public Iterator<CollisionInformationHolder> getCollisionInformationIterator() {
        return this.collisionInformationGenerated.iterator();
    }

    private void processNumber(int integer) {
        SpatialDetector.setPosWithRespectTo(integer, this.toTask.getCenterPotentialHit(), this.mutablePos);
        this.inWorldState = this.toTask.getParent().getCachedSurroundingChunks().func_180495_p((BlockPos)this.mutablePos);
        this.inWorld.x = (double)this.mutablePos.func_177958_n() + 0.5;
        this.inWorld.y = (double)this.mutablePos.func_177956_o() + 0.5;
        this.inWorld.z = (double)this.mutablePos.func_177952_p() + 0.5;
        this.toTask.getParent().getShipTransformationManager().getCurrentPhysicsTransform().transformPosition(this.inWorld, TransformType.GLOBAL_TO_SUBSPACE);
        int midX = MathHelper.func_76128_c((double)(this.inWorld.x + 0.5));
        int midY = MathHelper.func_76128_c((double)(this.inWorld.y + 0.5));
        int midZ = MathHelper.func_76128_c((double)(this.inWorld.z + 0.5));
        VSIterationUtils.expand3d(midX, midY, midZ, (x, y, z) -> this.checkPosition(x, y, z, integer));
    }

    public void checkPosition(int x, int y, int z, int positionHash) {
        ITerrainOctreeProvider provider;
        IBitOctree octree;
        if (!this.toTask.getParent().getChunkClaim().containsChunk(x >> 4, z >> 4)) {
            return;
        }
        Chunk chunkIn = this.toTask.getParent().getChunkAt(x >> 4, z >> 4);
        ExtendedBlockStorage storage = chunkIn.field_76652_q[(y = Math.max(0, Math.min(y, 255))) >> 4];
        if (storage != null && (octree = (provider = (ITerrainOctreeProvider)storage.field_177488_d).getSolidOctree()).get(x & 0xF, y & 0xF, z & 0xF)) {
            IBlockState inLocalState = chunkIn.func_186032_a(x, y, z);
            this.inLocalPos.func_181079_c(x, y, z);
            ShipTransform shipTransform = this.toTask.getParent().getShipTransformationManager().getCurrentPhysicsTransform();
            Vector3d shipBlockInGlobal = shipTransform.transformPositionNew(this.temp0.set((double)this.inLocalPos.func_177958_n() + 0.5, (double)this.inLocalPos.func_177956_o() + 0.5, (double)this.inLocalPos.func_177952_p() + 0.5), TransformType.SUBSPACE_TO_GLOBAL);
            double distanceSq = shipBlockInGlobal.distanceSquared((double)this.mutablePos.func_177958_n() + 0.5, (double)this.mutablePos.func_177956_o() + 0.5, (double)this.mutablePos.func_177952_p() + 0.5);
            if (distanceSq < 3.0) {
                CollisionInformationHolder holder = new CollisionInformationHolder(this.mutablePos.func_177958_n(), this.mutablePos.func_177956_o(), this.mutablePos.func_177952_p(), this.inLocalPos.func_177958_n(), this.inLocalPos.func_177956_o(), this.inLocalPos.func_177952_p(), this.inWorldState, inLocalState);
                this.collisionInformationGenerated.add(holder);
            }
        }
    }

    public WorldPhysicsCollider getToTask() {
        return this.toTask;
    }
}

