/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.collision;

import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.collision.PhysCollisionObject;
import org.valkyrienskies.mod.common.collision.Polygon;

public class PolygonCollisionPointFinder {
    public static Vector3dc[] getPointsOfCollisionForPolygons(PhysCollisionObject collisionInfo) {
        Polygon topPoly = null;
        Polygon bottomPoly = null;
        Vector3dc collisionNormal = collisionInfo.collision_normal;
        Vector3d centerDifference = collisionInfo.movable.getCenter().sub(collisionInfo.fixed.getCenter());
        if (centerDifference.dot(collisionNormal) > 0.0) {
            topPoly = collisionInfo.fixed;
            bottomPoly = collisionInfo.movable;
        } else {
            topPoly = collisionInfo.movable;
            bottomPoly = collisionInfo.fixed;
        }
        double minDot = 9.9999999E7;
        int topPointIndex = -1;
        for (int i = 0; i < topPoly.getVertices().length; ++i) {
            double dotProduct = topPoly.getVertices()[i].dot(collisionNormal);
            if (!(dotProduct < minDot)) continue;
            minDot = dotProduct;
            topPointIndex = i;
        }
        double maxDot = -9.999999999E9;
        int bottomPointIndex = -1;
        for (int i = 0; i < bottomPoly.getVertices().length; ++i) {
            double dotProduct = bottomPoly.getVertices()[i].dot(collisionNormal);
            if (!(dotProduct > maxDot)) continue;
            maxDot = dotProduct;
            bottomPointIndex = i;
        }
        Vector3dc currentTopVertex = topPoly.getVertices()[topPointIndex];
        Vector3dc currentBottomVertex = bottomPoly.getVertices()[bottomPointIndex];
        return new Vector3dc[]{currentTopVertex, currentBottomVertex, currentTopVertex, currentBottomVertex};
    }
}

