/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.collision;

import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.collision.Polygon;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityCollisionObject;

public class EntityPolygonCollider {
    private final Vector3dc[] collisionAxes;
    private final EntityCollisionObject[] collisions;
    private final Polygon entity;
    private final Polygon block;
    private final Vector3dc entityVelocity;
    private boolean separated = false;
    private int minDistanceIndex;
    private boolean originallySeparated;

    public EntityPolygonCollider(Polygon movable, Polygon stationary, Vector3dc[] axes, Vector3dc entityVel) {
        this.collisionAxes = axes;
        this.entity = movable;
        this.block = stationary;
        this.entityVelocity = entityVel;
        this.collisions = new EntityCollisionObject[this.collisionAxes.length];
        this.processData();
    }

    public void processData() {
        this.separated = false;
        for (int i = 0; i < this.collisions.length; ++i) {
            if (this.separated) continue;
            this.collisions[i] = new EntityCollisionObject(this.entity, this.block, this.collisionAxes[i], this.entityVelocity);
            if (this.collisions[i].arePolygonsSeperated()) {
                this.separated = true;
                break;
            }
            if (this.collisions[i].werePolygonsInitiallyColliding()) continue;
            this.originallySeparated = true;
        }
        if (!this.separated) {
            double minDistance = 420.0;
            for (int i = 0; i < this.collisions.length; ++i) {
                if (this.originallySeparated) {
                    if (!(Math.abs((this.collisions[i].getCollisionPenetrationDistance() - this.collisions[i].getVelDot()) / this.collisions[i].getVelDot()) < minDistance) || this.collisions[i].werePolygonsInitiallyColliding()) continue;
                    this.minDistanceIndex = i;
                    minDistance = Math.abs((this.collisions[i].getCollisionPenetrationDistance() - this.collisions[i].getVelDot()) / this.collisions[i].getVelDot());
                    continue;
                }
                if (!(Math.abs(this.collisions[i].getCollisionPenetrationDistance()) < minDistance)) continue;
                this.minDistanceIndex = i;
                minDistance = Math.abs(this.collisions[i].getCollisionPenetrationDistance());
            }
        }
    }

    public boolean arePolygonsSeparated() {
        return this.separated;
    }

    public Vector3dc[] getCollisionAxes() {
        return this.collisionAxes;
    }

    public EntityCollisionObject[] getCollisions() {
        return this.collisions;
    }

    public int getMinDistanceIndex() {
        return this.minDistanceIndex;
    }
}

