/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.capability.framework;

import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.util.EnumFacing;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ObjectMapper;
import org.valkyrienskies.mod.common.util.jackson.VSJacksonUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class VSDefaultCapability<K> {
    private static final Logger log = LogManager.getLogger(VSDefaultCapability.class);
    private final ObjectMapper mapper;
    private final Class<K> kClass;
    @Nonnull
    private K instance;
    private Supplier<K> factory;

    public VSDefaultCapability(Class<K> kClass, Supplier<K> factory) {
        this(kClass, factory, VSJacksonUtil.getDefaultMapper());
    }

    public VSDefaultCapability(Class<K> kClass, Supplier<K> factory, ObjectMapper mapper) {
        this.kClass = kClass;
        this.factory = factory;
        this.instance = factory.get();
        log.debug("CONSTRUCTED INSTANCE: " + this.instance);
        this.mapper = mapper;
    }

    @Nullable
    public NBTTagByteArray writeNBT(EnumFacing side) {
        byte[] value;
        long time = System.currentTimeMillis();
        try {
            value = this.getMapper().writeValueAsBytes(this.instance);
            log.debug("VS serialization took {} ms. Writing data of size {} KB. ({})", (Object)(System.currentTimeMillis() - time), (Object)((double)value.length / Math.pow(2.0, 10.0)), (Object)this.instance.getClass().getSimpleName());
        }
        catch (Exception ex) {
            log.fatal("Something just broke horrifically. Be wary of your data. This will crash the game in future releases", (Throwable)ex);
            value = new byte[]{};
        }
        return new NBTTagByteArray(value);
    }

    public K readNBT(NBTBase base, EnumFacing side) {
        long time = System.currentTimeMillis();
        try {
            byte[] value = ((NBTTagByteArray)base).func_150292_c();
            this.instance = this.mapper.readValue(value, this.kClass);
            log.info("VS deserialization took {} ms. Reading data of size {} KB.", (Object)(System.currentTimeMillis() - time), (Object)((double)value.length / Math.pow(2.0, 10.0)));
        }
        catch (IOException | ClassCastException ex) {
            log.fatal("Failed to read your ship data? Ships will probably be missing", (Throwable)ex);
            this.instance = this.factory.get();
        }
        if (this.instance == null) {
            log.fatal("Failed to read your ship data? Ships will probably be missing");
            this.instance = this.factory.get();
        }
        return this.instance;
    }

    public K get() {
        return this.instance;
    }

    public void set(K instance) {
        this.instance = instance;
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }
}

