/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public interface IBlockForceProvider {
    @Nullable
    default public Vector3dc getBlockForceInWorldSpace(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        Vector3dc toReturn = this.getBlockForceInShipSpace(world, pos, state, physicsObject, secondsToApply);
        if (toReturn == null) {
            return null;
        }
        if (this.shouldLocalForceBeRotated(world, pos, state, secondsToApply)) {
            ShipTransform shipTransform = physicsObject.getShipTransformationManager().getCurrentTickTransform();
            Vector3d rotated = new Vector3d(toReturn);
            shipTransform.transformDirection(rotated, TransformType.SUBSPACE_TO_GLOBAL);
            return rotated;
        }
        return toReturn;
    }

    @Nullable
    public Vector3dc getBlockForceInShipSpace(World var1, BlockPos var2, IBlockState var3, PhysicsObject var4, double var5);

    public boolean shouldLocalForceBeRotated(World var1, BlockPos var2, IBlockState var3, double var4);

    @Nullable
    default public Vector3dc getCustomBlockForcePosition(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        return null;
    }
}

