/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.block;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.block.BlockCaptainsChair;
import org.valkyrienskies.mod.common.block.BlockPilotableBasic;
import org.valkyrienskies.mod.common.block.IBlockForceProvider;
import org.valkyrienskies.mod.common.block.IBlockTorqueProvider;
import org.valkyrienskies.mod.common.entity.EntityShipMovementData;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.tileentity.TileEntityBoatChair;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

public class BlockBoatChair
extends BlockPilotableBasic
implements IBlockForceProvider,
IBlockTorqueProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockBoatChair() {
        super("boat_chair", Material.field_151575_d, 4.0f);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        Optional<PhysicsObject> physicsObject;
        if (!worldIn.field_72995_K && (physicsObject = ValkyrienUtils.getPhysoManagingBlock(worldIn, pos)).isPresent() && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityBoatChair) {
            Vector3d playerPos = new Vector3d(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transformPosition(playerPos, TransformType.SUBSPACE_TO_GLOBAL);
            playerIn.field_70165_t = playerPos.x;
            playerIn.field_70163_u = playerPos.y;
            playerIn.field_70161_v = playerPos.z;
            EntityShipMovementData entityShipMovementData = ValkyrienUtils.getEntityShipMovementDataFor((Entity)playerIn);
            if (entityShipMovementData.getTicksSinceTouchedShip() == 0 && entityShipMovementData.getLastTouchedShip() == physicsObject.get().getShipData()) {
                Vector3dc localMountPos = this.getPlayerMountOffset(state, pos);
                ValkyrienUtils.fixEntityToShip((Entity)playerIn, localMountPos, physicsObject.get());
            }
            ((TileEntityBoatChair)tileEntity).setPilotEntity(playerIn);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transformPosition(playerPos, TransformType.GLOBAL_TO_SUBSPACE);
            playerIn.field_70165_t = playerPos.x;
            playerIn.field_70163_u = playerPos.y;
            playerIn.field_70161_v = playerPos.z;
        }
        return true;
    }

    private Vector3dc getPlayerMountOffset(IBlockState state, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case NORTH: {
                return new Vector3d((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.6);
            }
            case SOUTH: {
                return new Vector3d((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.4);
            }
            case WEST: {
                return new Vector3d((double)pos.func_177958_n() + 0.6, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
            case EAST: {
                return new Vector3d((double)pos.func_177958_n() + 0.4, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
        }
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> itemInformation, ITooltipFlag advanced) {
        itemInformation.add(TextFormatting.ITALIC + "" + TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.valkyrienskies.boat_chair", (Object[])new Object[0]));
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBoatChair();
    }

    @Override
    @Nullable
    public Vector3dc getBlockForceInShipSpace(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityBoatChair) {
            return ((TileEntityBoatChair)tileEntity).getBlockForceInShipSpace(world, pos, state, physicsObject, secondsToApply);
        }
        return null;
    }

    @Override
    public boolean shouldLocalForceBeRotated(World world, BlockPos pos, IBlockState state, double secondsToApply) {
        return false;
    }

    @Override
    @Nullable
    public Vector3dc getTorqueInGlobal(PhysicsCalculations physicsCalculations, BlockPos pos) {
        World world = physicsCalculations.getParent().getWorld();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityBoatChair) {
            return ((TileEntityBoatChair)tileEntity).getTorqueInGlobal(physicsCalculations);
        }
        return null;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(placer.func_70093_af() ? placer.func_174811_aO().func_176734_d() : placer.func_174811_aO()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        return i;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public double getChairYaw(IBlockState state) {
        EnumFacing enumFace = (EnumFacing)state.func_177229_b((IProperty)BlockCaptainsChair.FACING);
        double chairYaw = -enumFace.func_185119_l() - 90.0f;
        return chairYaw;
    }

    @Override
    @Nullable
    public Vector3dc getCustomBlockForcePosition(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        return physicsObject.getPhysicsCalculations().getPhysCenterOfMass();
    }
}

