/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.mixin.MixinLoaderForge;
import org.valkyrienskies.mod.client.gui.TabValkyrienSkies;
import org.valkyrienskies.mod.common.block.BlockBoatChair;
import org.valkyrienskies.mod.common.block.BlockCaptainsChair;
import org.valkyrienskies.mod.common.block.BlockPassengerChair;
import org.valkyrienskies.mod.common.block.BlockWaterPump;
import org.valkyrienskies.mod.common.capability.VSCapabilityRegistry;
import org.valkyrienskies.mod.common.command.framework.VSCommandRegistry;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.item.ItemShipTracker;
import org.valkyrienskies.mod.common.network.MessagePlayerStoppedPiloting;
import org.valkyrienskies.mod.common.network.MessagePlayerStoppedPilotingHandler;
import org.valkyrienskies.mod.common.network.MessageStartPiloting;
import org.valkyrienskies.mod.common.network.MessageStartPilotingHandler;
import org.valkyrienskies.mod.common.network.MessageStopPiloting;
import org.valkyrienskies.mod.common.network.MessageStopPilotingHandler;
import org.valkyrienskies.mod.common.network.ShipIndexDataMessage;
import org.valkyrienskies.mod.common.network.ShipIndexDataMessageHandler;
import org.valkyrienskies.mod.common.network.ShipTransformUpdateMessage;
import org.valkyrienskies.mod.common.network.ShipTransformUpdateMessageHandler;
import org.valkyrienskies.mod.common.piloting.PilotControlsMessage;
import org.valkyrienskies.mod.common.piloting.PilotControlsMessageHandler;
import org.valkyrienskies.mod.common.ships.deprecated_api.VS_APIPhysicsEntityManager;
import org.valkyrienskies.mod.common.tileentity.TileEntityBoatChair;
import org.valkyrienskies.mod.common.tileentity.TileEntityCaptainsChair;
import org.valkyrienskies.mod.common.tileentity.TileEntityPassengerChair;
import org.valkyrienskies.mod.common.tileentity.TileEntityWaterPump;
import org.valkyrienskies.mod.fixes.darkness_lib_fix.VSDarknessLibAPILightProvider;
import org.valkyrienskies.mod.proxy.CommonProxy;
import valkyrienwarfare.api.IPhysicsEntityManager;

@Mod(modid="valkyrienskies", useMetadata=true, updateJSON="https://raw.githubusercontent.com/ValkyrienSkies/Valkyrien-Skies/master/update.json", certificateFingerprint="b308676914a5e7d99459c1d2fb298744387899a7")
public class ValkyrienSkiesMod {
    private static final Logger log = LogManager.getLogger(ValkyrienSkiesMod.class);
    public static final List<Block> BLOCKS = new ArrayList<Block>();
    public static final List<Item> ITEMS = new ArrayList<Item>();
    public static final String MOD_ID = "valkyrienskies";
    static final String MOD_FINGERPRINT = "b308676914a5e7d99459c1d2fb298744387899a7";
    @Mod.Instance(value="valkyrienskies")
    public static ValkyrienSkiesMod INSTANCE;
    @SidedProxy(clientSide="org.valkyrienskies.mod.proxy.ClientProxy", serverSide="org.valkyrienskies.mod.proxy.ServerProxy")
    public static CommonProxy proxy;
    static final int VS_ENTITY_LOAD_DISTANCE = 128;
    private static ForkJoinPool physicsThreadPool;
    public Block captainsChair;
    public Block passengerChair;
    public Block waterPump;
    public Block boatChair;
    public Item shipTracker;
    public static SimpleNetworkWrapper physWrapperNetwork;
    public static SimpleNetworkWrapper physWrapperTransformUpdateNetwork;
    public static SimpleNetworkWrapper controlNetwork;
    public static final CreativeTabs VS_CREATIVE_TAB;
    private static final List<String> MODULES;
    private static boolean isAnyModuleLoaded;
    private static boolean isSpongePresent;

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (MixinLoaderForge.isObfuscatedEnvironment) {
            FMLLog.bigWarning((String)"Valkyrien Skies JAR fingerprint corrupted, which means this copy of the mod may have come from unofficial sources. Please check out our official website: https://valkyrienskies.org", (Object[])new Object[0]);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log.debug("Initializing configuration.");
        this.runConfiguration();
        log.debug("Instantiating the physics thread executor.");
        physicsThreadPool = new ForkJoinPool(VSConfig.threadCount);
        log.debug("Initializing networks.");
        this.registerNetworks((FMLStateEvent)event);
        VSCapabilityRegistry.registerCapabilities();
        proxy.preInit(event);
        log.debug("Initializing the VS API.");
        try {
            Field instanceField = IPhysicsEntityManager.class.getDeclaredField("INSTANCE");
            instanceField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(instanceField, instanceField.getModifiers() & 0xFFFFFFEF);
            instanceField.set(null, new VS_APIPhysicsEntityManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.fatal("FAILED TO INITIALIZE VS API!");
        }
        this.registerItems();
        this.registerBlocks();
        this.registerDarknessLib();
    }

    private void registerDarknessLib() {
        try {
            Class<?> clazz = Class.forName("com.shinoow.darknesslib.api.DarknessLibAPI");
            Field instanceField = clazz.getDeclaredField("INSTANCE");
            Field lightProvidersField = clazz.getDeclaredField("LIGHT_PROVIDERS");
            instanceField.setAccessible(true);
            lightProvidersField.setAccessible(true);
            Object instance = instanceField.get(null);
            List lightProviders = (List)lightProvidersField.get(instance);
            lightProviders.add(new VSDarknessLibAPILightProvider());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        log.info("Valkyrien Skies Initialization: We are running on {} threads; 4 or more is recommended!", (Object)Runtime.getRuntime().availableProcessors());
        proxy.init(event);
        isAnyModuleLoaded = MODULES.stream().anyMatch(Loader::isModLoaded);
        isSpongePresent = Loader.isModLoaded((String)"spongeforge");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        VSCommandRegistry.registerCommands(server);
    }

    private void registerNetworks(FMLStateEvent event) {
        physWrapperNetwork = NetworkRegistry.INSTANCE.newSimpleChannel("valkyrien_skies");
        physWrapperNetwork.registerMessage(ShipIndexDataMessageHandler.class, ShipIndexDataMessage.class, 0, Side.CLIENT);
        controlNetwork = NetworkRegistry.INSTANCE.newSimpleChannel("valkyrien_piloting");
        controlNetwork.registerMessage(PilotControlsMessageHandler.class, PilotControlsMessage.class, 0, Side.SERVER);
        controlNetwork.registerMessage(MessageStartPilotingHandler.class, MessageStartPiloting.class, 1, Side.CLIENT);
        controlNetwork.registerMessage(MessageStopPilotingHandler.class, MessageStopPiloting.class, 2, Side.CLIENT);
        controlNetwork.registerMessage(MessagePlayerStoppedPilotingHandler.class, MessagePlayerStoppedPiloting.class, 3, Side.SERVER);
        physWrapperTransformUpdateNetwork = NetworkRegistry.INSTANCE.newSimpleChannel("vs_ship_transforms");
        physWrapperTransformUpdateNetwork.registerMessage(ShipTransformUpdateMessageHandler.class, ShipTransformUpdateMessage.class, 0, Side.CLIENT);
    }

    void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (!VSConfig.chairRecipes) {
            return;
        }
        ValkyrienSkiesMod.registerRecipe(event, "recipe_captains_chair", new ItemStack(this.captainsChair), "SLS", "VWV", " S ", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('W'), Item.func_150898_a((Block)Blocks.field_150364_r), Character.valueOf('V'), Items.field_151045_i);
        ValkyrienSkiesMod.registerRecipe(event, "recipe_passenger_chair", new ItemStack(this.passengerChair), "SLS", "PWP", " S ", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('W'), Item.func_150898_a((Block)Blocks.field_150364_r), Character.valueOf('P'), Item.func_150898_a((Block)Blocks.field_150344_f));
    }

    private static void registerRecipe(RegistryEvent.Register<IRecipe> event, String registryName, ItemStack out, Object ... in) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])in);
        event.getRegistry().register(new ShapedRecipes(MOD_ID, primer.width, primer.height, primer.input, out).setRegistryName(MOD_ID, registryName));
    }

    private void runConfiguration() {
        VSConfig.sync();
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityCaptainsChair.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_captains_chair"));
        GameRegistry.registerTileEntity(TileEntityPassengerChair.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_passenger_chair"));
        GameRegistry.registerTileEntity(TileEntityWaterPump.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_water_pump"));
        GameRegistry.registerTileEntity(TileEntityBoatChair.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_boat_chair"));
    }

    private void registerBlocks() {
        this.captainsChair = this.registerBlock(new BlockCaptainsChair());
        this.passengerChair = this.registerBlock(new BlockPassengerChair());
        this.waterPump = this.registerBlock(new BlockWaterPump());
        this.boatChair = this.registerBlock(new BlockBoatChair());
        this.registerTileEntities();
    }

    private Block registerBlock(Block block) {
        BLOCKS.add(block);
        ITEMS.add((Item)new ItemBlock(block).setRegistryName(block.getRegistryName()));
        return block;
    }

    private void registerItems() {
        this.shipTracker = new ItemShipTracker("vs_ship_tracker", true);
    }

    public static ForkJoinPool getPhysicsThreadPool() {
        return physicsThreadPool;
    }

    public static boolean isAnyModuleLoaded() {
        return isAnyModuleLoaded;
    }

    public static boolean isSpongePresent() {
        return isSpongePresent;
    }

    static {
        physicsThreadPool = null;
        VS_CREATIVE_TAB = new TabValkyrienSkies(MOD_ID);
        MODULES = ImmutableList.of((Object)"vs_control", (Object)"vs_world");
        isAnyModuleLoaded = false;
        isSpongePresent = false;
    }
}

