/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.entity.EntityMountable;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityDraggable;
import org.valkyrienskies.mod.common.ships.entity_interaction.IDraggable;
import org.valkyrienskies.mod.common.ships.ship_transform.CoordinateSpaceType;
import org.valkyrienskies.mod.common.ships.ship_world.IHasShipManager;
import org.valkyrienskies.mod.common.ships.ship_world.IPhysObjectWorld;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.ships.ship_world.VSWorldEventListener;
import org.valkyrienskies.mod.common.ships.ship_world.WorldClientShipManager;
import org.valkyrienskies.mod.common.ships.ship_world.WorldServerShipManager;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mod.EventBusSubscriber(modid="valkyrienskies")
public class EventsCommon {
    @Deprecated
    private static final Map<EntityPlayer, double[]> lastPositions = new HashMap<EntityPlayer, double[]>();
    private static final Logger logger = LogManager.getLogger(EventsCommon.class);
    private static final List<String> MEMED = ImmutableList.of((Object)"Drake_Eldridge", (Object)"thebest108", (Object)"DaPorkChop_");

    @SubscribeEvent
    public static void onPlayerSleepInBedEvent(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(player.func_130014_f_(), pos);
        if (physicsObject.isPresent() && player instanceof EntityPlayerMP) {
            player.func_145747_a((ITextComponent)new TextComponentString("Spawn Point Set!"));
            player.func_180473_a(pos, false);
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_HERE);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = entity.field_70170_p;
        BlockPos posAt = new BlockPos(entity);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(world, posAt);
        if (!event.getWorld().field_72995_K && physicsObject.isPresent() && !(entity instanceof EntityFallingBlock)) {
            if (entity instanceof EntityArmorStand || entity instanceof EntityPig || entity instanceof EntityBoat) {
                EntityMountable entityMountable = new EntityMountable(world, entity.func_174791_d(), CoordinateSpaceType.SUBSPACE_COORDINATES, posAt);
                world.func_72838_d((Entity)entityMountable);
                entity.func_184220_m((Entity)entityMountable);
            }
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transform(entity, TransformType.SUBSPACE_TO_GLOBAL, false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT) {
            throw new IllegalStateException("This event should never get called client side");
        }
        World world = event.world;
        IPhysObjectWorld physObjectWorld = ValkyrienUtils.getPhysObjWorld(world);
        switch (event.phase) {
            case START: {
                for (Entity entity : world.field_72996_f) {
                    IDraggable draggable = (IDraggable)entity;
                    draggable.decrementTicksAirPocket();
                }
                break;
            }
            case END: {
                physObjectWorld.tick();
                EntityDraggable.tickAddedVelocityForWorld(world);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayerMP p = (EntityPlayerMP)event.player;
            double[] pos = lastPositions.computeIfAbsent((EntityPlayer)p, k -> new double[3]);
            try {
                if ((pos[0] != p.field_70165_t || pos[2] != p.field_70161_v) && (Math.abs(p.field_70165_t) > 2.7E7 || Math.abs(p.field_70161_v) > 2.7E7)) {
                    p.func_184595_k(pos[0], pos[1], pos[2]);
                    p.func_145747_a((ITextComponent)new TextComponentString("You can't go beyond 27000000 blocks because airships are stored there!"));
                }
            }
            catch (NullPointerException e) {
                logger.warn("Nullpointer EventsCommon.java:onPlayerTickEvent");
            }
            pos[0] = p.field_70165_t;
            pos[1] = p.field_70163_u;
            pos[2] = p.field_70161_v;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        event.getWorld().func_72954_a((IWorldEventListener)new VSWorldEventListener(world));
        IHasShipManager shipManager = (IHasShipManager)world;
        if (!event.getWorld().field_72995_K) {
            shipManager.setManager(WorldServerShipManager::new);
        } else {
            shipManager.setManager(WorldClientShipManager::new);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldUnload(WorldEvent.Unload event) {
        lastPositions.clear();
        IHasShipManager shipManager = (IHasShipManager)event.getWorld();
        shipManager.getManager().onWorldUnload();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEvent(PlayerInteractEvent event) {
        BlockPos pos = event.getPos();
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(event.getWorld(), pos);
        if (physicsObject.isPresent()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (VSConfig.warnNoModules && !ValkyrienSkiesMod.isAnyModuleLoaded()) {
            event.player.func_145747_a((ITextComponent)new TextComponentString("Neither Valkyrien Skies Control nor Valkyrien Skies World are loaded. It's recommended you install them. You can disable this message by typing the command '/vsc warnNoModules false'"));
        }
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            lastPositions.put((EntityPlayer)player, new double[]{0.0, 256.0, 0.0});
            if (MEMED.contains(player.func_70005_c_())) {
                WorldServer server = (WorldServer)event.player.field_70170_p;
                if (Math.random() < 0.2) {
                    server.field_73061_a.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + "An absolute " + TextFormatting.RED + TextFormatting.ITALIC + "legend" + TextFormatting.BLUE + " has arrived! Welcome " + TextFormatting.GOLD + TextFormatting.BOLD + player.func_70005_c_()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            lastPositions.remove(event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreakFirst(BlockEvent event) {
        ValkyrienUtils.getPhysoManagingBlock(event.getWorld(), event.getPos()).ifPresent(physicsObject -> event.setResult(Event.Result.ALLOW));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onExplosionStart(ExplosionEvent.Start event) {
        if (!event.getWorld().field_72995_K) {
            Explosion explosion = event.getExplosion();
            Vector3d center = new Vector3d(explosion.field_77284_b, explosion.field_77285_c, explosion.field_77282_d);
            Optional<PhysicsObject> optionalPhysicsObject = ValkyrienUtils.getPhysoManagingBlock(event.getWorld(), new BlockPos(event.getExplosion().getPosition()));
            if (optionalPhysicsObject.isPresent()) {
                return;
            }
            float radius = explosion.field_77280_f;
            AxisAlignedBB toCheck = new AxisAlignedBB(center.x() - (double)radius, center.y() - (double)radius, center.z() - (double)radius, center.x() + (double)radius, center.y() + (double)radius, center.z() + (double)radius);
            List<PhysicsObject> shipsNear = ((IHasShipManager)event.getWorld()).getManager().getPhysObjectsInAABB(toCheck);
            for (PhysicsObject ship : shipsNear) {
                Vector3d inLocal = new Vector3d(center);
                inLocal.mulPosition(ship.getShipTransform().getGlobalToSubspace());
                Explosion expl = new Explosion(event.getWorld(), explosion.field_77283_e, inLocal.x, inLocal.y, inLocal.z, radius, explosion.field_77286_a, explosion.field_82755_b);
                double waterRange = 0.6;
                int x = (int)Math.floor(expl.field_77284_b - waterRange);
                while ((double)x <= Math.ceil(expl.field_77284_b + waterRange)) {
                    int y = (int)Math.floor(expl.field_77285_c - waterRange);
                    while ((double)y <= Math.ceil(expl.field_77285_c + waterRange)) {
                        int z = (int)Math.floor(expl.field_77282_d - waterRange);
                        while ((double)z <= Math.ceil(expl.field_77282_d + waterRange)) {
                            IBlockState state = event.getWorld().func_180495_p(new BlockPos(x, y, z));
                            if (state.func_177230_c() instanceof BlockLiquid) {
                                return;
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                expl.func_77278_a();
                event.getExplosion().field_77281_g.addAll(expl.field_77281_g);
            }
        }
    }
}

