/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.valkyrienskies.mod.client.render.GibsModelRegistry;

public class FastBlockModelRenderer {
    public static final Map<IBlockState, BufferBuilder.State> blockstateToVertexData = new HashMap<IBlockState, BufferBuilder.State>();
    public static final Map<IBlockState, Map<Integer, VertexBuffer>> blockstateBrightnessToVertexBuffer = new HashMap<IBlockState, Map<Integer, VertexBuffer>>();
    public static final BufferBuilder VERTEX_BUILDER = new BufferBuilder(500000);
    private static final BlockPos offsetPos = new BlockPos(0, 512, 0);

    public static void renderBlockModel(Tessellator tessellator, World world, IBlockState blockstateToRender, int brightness) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-offsetPos.func_177958_n()), (double)(-offsetPos.func_177956_o()), (double)(-offsetPos.func_177952_p()));
        FastBlockModelRenderer.renderBlockModelHighQualityHighRam(tessellator, world, blockstateToRender, brightness);
        GL11.glPopMatrix();
    }

    private static void renderBlockModelHighQualityHighRam(Tessellator tessellator, World world, IBlockState blockstateToRender, int brightness) {
        if (!blockstateToVertexData.containsKey(blockstateToRender)) {
            FastBlockModelRenderer.generateRenderDataFor(world, blockstateToRender);
        }
        if (!blockstateBrightnessToVertexBuffer.containsKey(blockstateToRender)) {
            blockstateBrightnessToVertexBuffer.put(blockstateToRender, new HashMap());
        }
        if (!blockstateBrightnessToVertexBuffer.get(blockstateToRender).containsKey(brightness)) {
            BufferBuilder.State bufferBuilderState = blockstateToVertexData.get(blockstateToRender);
            VERTEX_BUILDER.func_178969_c(0.0, 0.0, 0.0);
            VERTEX_BUILDER.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            VERTEX_BUILDER.func_178993_a(bufferBuilderState);
            int j = FastBlockModelRenderer.VERTEX_BUILDER.field_179011_q.func_177338_f() >> 2;
            int cont = VERTEX_BUILDER.func_178989_h();
            int offsetUV = FastBlockModelRenderer.VERTEX_BUILDER.field_179011_q.func_177344_b(1) / 4;
            int bufferNextSize = FastBlockModelRenderer.VERTEX_BUILDER.field_179011_q.func_181719_f();
            for (int contont = 0; contont < cont; contont += 4) {
                try {
                    int i = contont * bufferNextSize + offsetUV;
                    FastBlockModelRenderer.VERTEX_BUILDER.field_178999_b.put(i, brightness);
                    FastBlockModelRenderer.VERTEX_BUILDER.field_178999_b.put(i + j, brightness);
                    FastBlockModelRenderer.VERTEX_BUILDER.field_178999_b.put(i + j * 2, brightness);
                    FastBlockModelRenderer.VERTEX_BUILDER.field_178999_b.put(i + j * 3, brightness);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            VertexBuffer blockVertexBuffer = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            VERTEX_BUILDER.func_178977_d();
            VERTEX_BUILDER.func_178965_a();
            blockVertexBuffer.func_181722_a(VERTEX_BUILDER.func_178966_f());
            blockstateBrightnessToVertexBuffer.get(blockstateToRender).put(brightness, blockVertexBuffer);
        }
        FastBlockModelRenderer.renderVertexBuffer(blockstateBrightnessToVertexBuffer.get(blockstateToRender).get(brightness));
    }

    public static void renderVertexBuffer(VertexBuffer vertexBuffer) {
        boolean areOptifineShadersEnabled = GibsModelRegistry.isOptifineShadersEnabled();
        GlStateManager.func_179094_E();
        GlStateManager.func_179117_G();
        GlStateManager.func_187410_q((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32886);
        if (areOptifineShadersEnabled) {
            GL11.glEnableClientState((int)32885);
            GL20.glEnableVertexAttribArray((int)11);
            GL20.glEnableVertexAttribArray((int)12);
            GL20.glEnableVertexAttribArray((int)10);
        }
        GlStateManager.func_179094_E();
        vertexBuffer.func_177359_a();
        if (areOptifineShadersEnabled) {
            int vertexSizeI = 14;
            GL11.glVertexPointer((int)3, (int)5126, (int)56, (long)0L);
            GL11.glColorPointer((int)4, (int)5121, (int)56, (long)12L);
            GL11.glTexCoordPointer((int)2, (int)5126, (int)56, (long)16L);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GL11.glTexCoordPointer((int)2, (int)5122, (int)56, (long)24L);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            GL11.glNormalPointer((int)5120, (int)56, (long)28L);
            GL20.glVertexAttribPointer((int)11, (int)2, (int)5126, (boolean)false, (int)56, (long)32L);
            GL20.glVertexAttribPointer((int)12, (int)4, (int)5122, (boolean)false, (int)56, (long)40L);
            GL20.glVertexAttribPointer((int)10, (int)3, (int)5122, (boolean)false, (int)56, (long)48L);
        } else {
            GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
            GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
            GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }
        vertexBuffer.func_177358_a(7);
        GlStateManager.func_179121_F();
        vertexBuffer.func_177361_b();
        GlStateManager.func_179117_G();
        for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
            VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
            int i = vertexformatelement.func_177369_e();
            switch (vertexformatelement$enumusage) {
                case POSITION: {
                    GlStateManager.func_187429_p((int)32884);
                    break;
                }
                case UV: {
                    OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + i));
                    GlStateManager.func_187429_p((int)32888);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                    break;
                }
                case COLOR: {
                    GlStateManager.func_187429_p((int)32886);
                    GlStateManager.func_179117_G();
                }
            }
        }
        OpenGlHelper.func_176072_g((int)OpenGlHelper.field_176089_P, (int)0);
        if (areOptifineShadersEnabled) {
            GL11.glDisableClientState((int)32885);
            GL20.glDisableVertexAttribArray((int)11);
            GL20.glDisableVertexAttribArray((int)12);
            GL20.glDisableVertexAttribArray((int)10);
        }
        GlStateManager.func_179117_G();
        GlStateManager.func_179121_F();
    }

    private static void renderBlockModelHighQuality(Tessellator tessellator, World world, IBlockState blockstateToRender, int brightness) {
        BufferBuilder.State vertexData = blockstateToVertexData.get(blockstateToRender);
        if (vertexData == null) {
            FastBlockModelRenderer.generateRenderDataFor(world, blockstateToRender);
            vertexData = blockstateToVertexData.get(blockstateToRender);
        }
        FastBlockModelRenderer.renderVertexState(vertexData, tessellator, brightness);
    }

    private static void renderVertexState(BufferBuilder.State data, Tessellator tessellator, int brightness) {
        GL11.glPushMatrix();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        tessellator.func_178180_c().func_178993_a(data);
        int j = tessellator.func_178180_c().field_179011_q.func_177338_f() >> 2;
        int cont = tessellator.func_178180_c().func_178989_h();
        int offsetUV = tessellator.func_178180_c().field_179011_q.func_177344_b(1) / 4;
        int bufferNextSize = tessellator.func_178180_c().field_179011_q.func_181719_f();
        for (int contont = 0; contont < cont; contont += 4) {
            try {
                int i = contont * bufferNextSize + offsetUV;
                tessellator.func_178180_c().field_178999_b.put(i, brightness);
                tessellator.func_178180_c().field_178999_b.put(i + j, brightness);
                tessellator.func_178180_c().field_178999_b.put(i + j * 2, brightness);
                tessellator.func_178180_c().field_178999_b.put(i + j * 3, brightness);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    private static void generateRenderDataFor(World world, IBlockState state) {
        VERTEX_BUILDER.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel modelFromState = blockrendererdispatcher.func_184389_a(state);
        blockrendererdispatcher.func_175019_b().func_187493_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, modelFromState, Blocks.field_150350_a.func_176223_P(), offsetPos, VERTEX_BUILDER, false, 0L);
        BufferBuilder.State toReturn = VERTEX_BUILDER.func_181672_a();
        VERTEX_BUILDER.func_178977_d();
        VERTEX_BUILDER.func_178965_a();
        blockstateToVertexData.put(state, toReturn);
    }
}

