/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.client;

import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.lwjgl.opengl.GL11;
import org.valkyrienskies.mod.client.render.GibsModelRegistry;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.entity.EntityShipMovementData;
import org.valkyrienskies.mod.common.ships.QueryableShipData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityDraggable;
import org.valkyrienskies.mod.common.ships.entity_interaction.IDraggable;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.IHasShipManager;
import org.valkyrienskies.mod.common.ships.ship_world.IPhysObjectWorld;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.VSRenderUtils;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import org.valkyrienskies.mod.fixes.SoundFixWrapper;
import valkyrienwarfare.api.TransformType;

public class EventsClient {
    private static double oldXOff;
    private static double oldYOff;
    private static double oldZOff;
    private static final WeakHashMap<Entity, Vector3dc> lastPositionsMap;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        switch (event.phase) {
            case START: {
                for (PhysicsObject wrapper : ((IHasShipManager)world).getManager().getAllLoadedPhysObj()) {
                    wrapper.getShipTransformationManager().updateRenderTransform(1.0);
                }
                for (Entity entity : world.field_72996_f) {
                    IDraggable draggable = (IDraggable)entity;
                    draggable.decrementTicksAirPocket();
                }
                break;
            }
            case END: {
                if (Minecraft.func_71410_x().func_147113_T()) break;
                IHasShipManager shipManager = (IHasShipManager)world;
                shipManager.getManager().tick();
                EntityDraggable.tickAddedVelocityForWorld((World)world);
            }
        }
    }

    @SubscribeEvent
    public void onPlaySoundEvent(PlaySoundEvent event) {
        ISound sound;
        BlockPos pos;
        Optional<PhysicsObject> physicsObject;
        if (Minecraft.func_71410_x().field_71441_e != null && (physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)Minecraft.func_71410_x().field_71441_e, pos = new BlockPos((double)(sound = event.getSound()).func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i()))).isPresent()) {
            Vector3d newSoundLocation = new Vector3d(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transformPosition(newSoundLocation, TransformType.SUBSPACE_TO_GLOBAL);
            SoundFixWrapper soundFix = new SoundFixWrapper(sound, newSoundLocation);
            event.setResultSound((ISound)soundFix);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onDrawBlockHighlightEventFirst(DrawBlockHighlightEvent event) {
        RayTraceResult objectOver;
        GL11.glPushMatrix();
        BlockPos pos = Minecraft.func_71410_x().field_71476_x.func_178782_a();
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)Minecraft.func_71410_x().field_71441_e, pos);
        if (physicsObject.isPresent() && (objectOver = Minecraft.func_71410_x().field_71476_x) != null && objectOver.field_72307_f != null) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            oldXOff = buffer.field_179004_l;
            oldYOff = buffer.field_179005_m;
            oldZOff = buffer.field_179002_n;
            buffer.func_178969_c((double)(-physicsObject.get().getShipRenderer().offsetPos.func_177958_n()), (double)(-physicsObject.get().getShipRenderer().offsetPos.func_177956_o()), (double)(-physicsObject.get().getShipRenderer().offsetPos.func_177952_p()));
            physicsObject.get().getShipRenderer().applyRenderTransform(event.getPartialTicks());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onDrawBlockHighlightEventLast(DrawBlockHighlightEvent event) {
        RayTraceResult objectOver;
        BlockPos pos = Minecraft.func_71410_x().field_71476_x.func_178782_a();
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)Minecraft.func_71410_x().field_71441_e, pos);
        if (physicsObject.isPresent() && (objectOver = Minecraft.func_71410_x().field_71476_x) != null && objectOver.field_72307_f != null) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.field_179004_l = oldXOff;
            buffer.field_179005_m = oldYOff;
            buffer.field_179002_n = oldZOff;
        }
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        GibsModelRegistry.registerTextures((TextureStitchEvent)event);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        GibsModelRegistry.onModelBakeEvent(event);
    }

    @SubscribeEvent
    public void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        double partialTicks = event.renderTickTime;
        if (Minecraft.func_71410_x().func_147113_T()) {
            partialTicks = Minecraft.func_71410_x().field_193996_ah;
        }
        if (event.phase == TickEvent.Phase.START) {
            lastPositionsMap.clear();
            for (PhysicsObject wrapper : ValkyrienUtils.getPhysosLoadedInWorld((World)world)) {
                wrapper.getShipTransformationManager().updateRenderTransform(partialTicks);
            }
            for (Entity entity : world.func_72910_y()) {
                EntityShipMovementData entityShipMovementData = ValkyrienUtils.getEntityShipMovementDataFor(entity);
                if (entityShipMovementData.getLastTouchedShip() == null || entityShipMovementData.getTicksSinceTouchedShip() >= VSConfig.ticksToStickToShip) continue;
                PhysicsObject shipPhysicsObject = ValkyrienUtils.getPhysObjWorld((World)world).getPhysObjectFromUUID(entityShipMovementData.getLastTouchedShip().getUuid());
                if (shipPhysicsObject == null) {
                    ((IDraggable)IDraggable.class.cast(entity)).setEntityShipMovementData(entityShipMovementData.withLastTouchedShip(null));
                    continue;
                }
                ShipTransform prevTickTransform = shipPhysicsObject.getPrevTickShipTransform();
                ShipTransform shipRenderTransform = shipPhysicsObject.getShipTransformationManager().getRenderTransform();
                Vector3dc entityAddedVelocity = entityShipMovementData.getAddedLinearVelocity();
                double entityMovementX = entity.field_70165_t - entityAddedVelocity.x() - entity.field_70142_S;
                double entityMovementY = entity.field_70163_u - entityAddedVelocity.y() - entity.field_70137_T;
                double entityMovementZ = entity.field_70161_v - entityAddedVelocity.z() - entity.field_70136_U;
                Vector3d entityShouldBeHere = new Vector3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U);
                entityShouldBeHere.add(entityMovementX * partialTicks, entityMovementY * partialTicks, entityMovementZ * partialTicks);
                prevTickTransform.transformPosition(entityShouldBeHere, TransformType.GLOBAL_TO_SUBSPACE);
                shipRenderTransform.transformPosition(entityShouldBeHere, TransformType.SUBSPACE_TO_GLOBAL);
                lastPositionsMap.put(entity, new Vector3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U));
                entity.field_70142_S = (entityShouldBeHere.x() - entity.field_70165_t * partialTicks) / (1.0 - partialTicks);
                entity.field_70137_T = (entityShouldBeHere.y() - entity.field_70163_u * partialTicks) / (1.0 - partialTicks);
                entity.field_70136_U = (entityShouldBeHere.z() - entity.field_70161_v * partialTicks) / (1.0 - partialTicks);
            }
        } else {
            for (Entity entity : world.func_72910_y()) {
                if (!lastPositionsMap.containsKey(entity)) continue;
                Vector3dc entityLastPosition = lastPositionsMap.get(entity);
                entity.field_70142_S = entityLastPosition.x();
                entity.field_70137_T = entityLastPosition.y();
                entity.field_70136_U = entityLastPosition.z();
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (mc.func_175598_ae().func_178634_b() && !mc.func_189648_am() && world != null) {
            float partialTicks = event.getPartialTicks();
            Vector3d offset = VSRenderUtils.getEntityPartialPosition(mc.func_175606_aa(), partialTicks).negate();
            for (PhysicsObject physo : ValkyrienUtils.getPhysosLoadedInWorld((World)world)) {
                physo.getShipRenderer().renderDebugInfo(offset);
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoadEvent(ChunkEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        Chunk chunk = event.getChunk();
        QueryableShipData queryableShipData = QueryableShipData.get(event.getWorld());
        Optional<ShipData> shipClaimingOptional = queryableShipData.getShipFromChunk(chunk.field_76635_g, chunk.field_76647_h);
        if (shipClaimingOptional.isPresent()) {
            ShipData shipData = shipClaimingOptional.get();
            IPhysObjectWorld physObjectWorld = ValkyrienUtils.getPhysObjWorld(event.getWorld());
            PhysicsObject physicsObject = physObjectWorld.getPhysObjectFromUUID(shipData.getUuid());
            if (physicsObject != null) {
                physicsObject.updateChunk(chunk);
            }
        }
    }

    static {
        lastPositionsMap = new WeakHashMap();
    }
}

