/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.entity.player;

import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.piloting.ControllerInputType;
import org.valkyrienskies.mod.common.piloting.IShipPilot;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

@Deprecated
@Mixin(value={EntityPlayer.class})
public abstract class MixinEntityPlayer
extends EntityLivingBase
implements IShipPilot {
    @Shadow
    public BlockPos field_71081_bT;
    private PhysicsObject pilotedShip;
    private BlockPos blockBeingControlled;
    private ControllerInputType controlInputType;

    public MixinEntityPlayer() {
        super(null);
    }

    @Inject(method={"getBedSpawnLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preGetBedSpawnLocation(World worldIn, BlockPos bedLocation, boolean forceSpawn, CallbackInfoReturnable<BlockPos> callbackInfo) {
        Optional<ShipData> shipData = ValkyrienUtils.getQueryableData(worldIn).getShipFromBlock(bedLocation);
        if (shipData.isPresent()) {
            ShipTransform positionData = shipData.get().getShipTransform();
            if (positionData != null) {
                Vector3d bedLocationD = JOML.castDouble(JOML.convert((Vec3i)bedLocation)).add(0.5, 0.5, 0.5);
                positionData.getSubspaceToGlobal().transformPosition(bedLocationD);
                bedLocationD.y += 1.0;
                bedLocation = JOML.toMinecraft(JOML.castInt(bedLocationD));
                callbackInfo.setReturnValue(bedLocation);
            } else {
                System.err.println("A ship just had chunks claimed persistent, but not any position data persistent");
            }
        }
    }

    @Override
    public PhysicsObject getPilotedShip() {
        return this.pilotedShip;
    }

    @Override
    public void setPilotedShip(PhysicsObject wrapper) {
        this.pilotedShip = wrapper;
    }

    @Override
    public boolean isPilotingShip() {
        return this.pilotedShip != null;
    }

    @Override
    public BlockPos getPosBeingControlled() {
        return this.blockBeingControlled;
    }

    @Override
    public void setPosBeingControlled(BlockPos pos) {
        this.blockBeingControlled = pos;
    }

    @Override
    public ControllerInputType getControllerInputEnum() {
        return this.controlInputType;
    }

    @Override
    public void setControllerInputEnum(ControllerInputType type) {
        this.controlInputType = type;
    }

    @Override
    public boolean isPilotingATile() {
        return this.blockBeingControlled != null;
    }

    @Override
    public boolean isPiloting() {
        return this.isPilotingShip() || this.isPilotingATile();
    }

    @Override
    public void stopPilotingEverything() {
        this.setPilotedShip(null);
        this.setPosBeingControlled(null);
        this.setControllerInputEnum(null);
    }
}

