/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.entity;

import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.math.Vec3d;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

@Mixin(value={EntityMinecart.class})
public class MixinEntityMinecart {
    private final EntityMinecart self = (EntityMinecart)EntityMinecart.class.cast(this);
    private ShipTransform transform = null;
    private boolean isInGlobal = true;

    @Inject(method={"onUpdate"}, at={@At(value="HEAD")})
    public void preOnUpdate(CallbackInfo ci) {
        if (!VSConfig.minecartsOnShips) {
            return;
        }
        if (this.self.field_70170_p.field_72995_K) {
            return;
        }
        this.moveToSubspace();
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityMinecart;doBlockCollisions()V")})
    public void preBlockCollisions(CallbackInfo ci) {
        if (!VSConfig.minecartsOnShips) {
            return;
        }
        if (this.self.field_70170_p.field_72995_K) {
            return;
        }
        this.moveToGlobal();
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityMinecart;moveDerailedMinecart()V")})
    public void preMoveDerailed(CallbackInfo ci) {
        if (!VSConfig.minecartsOnShips) {
            return;
        }
        if (this.self.field_70170_p.field_72995_K) {
            return;
        }
        this.moveToGlobal();
    }

    private void moveToSubspace() {
        Vec3d position = this.self.func_174791_d();
        for (PhysicsObject ship : ValkyrienUtils.getPhysosLoadedInWorld(this.self.field_70170_p)) {
            if (!ship.getShipBB().func_72318_a(position)) continue;
            this.transform = ship.getShipTransform();
            this.transformThis(this.transform.getGlobalToSubspace());
            this.isInGlobal = false;
            return;
        }
    }

    private void moveToGlobal() {
        if (!this.isInGlobal) {
            this.transformThis(this.transform.getSubspaceToGlobal());
            this.isInGlobal = true;
        }
    }

    private void transformThis(Matrix4dc transform) {
        Vector3d pos = transform.transformPosition(JOML.convert(this.self.func_174791_d()));
        Vector3d lastPos = transform.transformPosition(new Vector3d(this.self.field_70142_S, this.self.field_70137_T, this.self.field_70136_U));
        this.self.func_70107_b(pos.x, pos.y, pos.z);
        this.self.field_70142_S = lastPos.x;
        this.self.field_70137_T = lastPos.y;
        this.self.field_70136_U = lastPos.z;
    }
}

