/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.entity.EntityShipMovementData;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityCollisionInjector;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityMoveInjectionMethods;
import org.valkyrienskies.mod.common.ships.entity_interaction.IDraggable;

@Mixin(value={Entity.class}, priority=1)
public abstract class MixinEntityIntrinsic {
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public double field_70161_v;
    @Shadow
    public World field_70170_p;
    @Shadow
    public boolean field_70132_H;
    private final Entity thisClassAsAnEntity = (Entity)Entity.class.cast(this);
    private final IDraggable thisClassAsDraggable = (IDraggable)IDraggable.class.cast(this);
    private EntityCollisionInjector.IntermediateMovementVariableStorage alteredMovement = null;
    private boolean didMinecraftInvokeMove = true;

    @Shadow
    public abstract void func_70091_d(MoverType var1, double var2, double var4, double var6);

    @Inject(method={"move"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEntityPreMove(MoverType type, double dx, double dy, double dz, CallbackInfo callbackInfo) {
        if (this.didMinecraftInvokeMove) {
            this.alteredMovement = EntityMoveInjectionMethods.handleMove(type, dx, dy, dz, this.thisClassAsAnEntity);
            if (this.alteredMovement != null) {
                this.didMinecraftInvokeMove = false;
                this.func_70091_d(type, this.alteredMovement.dxyz.x(), this.alteredMovement.dxyz.y(), this.alteredMovement.dxyz.z());
                this.didMinecraftInvokeMove = true;
                callbackInfo.cancel();
            }
        }
    }

    @Inject(method={"move"}, at={@At(value="RETURN")})
    private void onEntityPostMove(CallbackInfo callbackInfo) {
        EntityShipMovementData oldEntityShipMovementData = this.thisClassAsDraggable.getEntityShipMovementData();
        if (this.alteredMovement != null) {
            EntityShipMovementData newEntityShipMovementData = oldEntityShipMovementData.withLastTouchedShip(this.alteredMovement.shipTouched).withTicksSinceTouchedShip(0).withTicksPartOfGround(0);
            this.thisClassAsDraggable.setEntityShipMovementData(newEntityShipMovementData);
            EntityCollisionInjector.alterEntityMovementPost(this.thisClassAsAnEntity, this.alteredMovement);
        } else if (this.field_70132_H) {
            int newTicksPartOfGround = oldEntityShipMovementData.getTicksPartOfGround() + 1;
            EntityShipMovementData newEntityShipMovementData = new EntityShipMovementData(null, 0, newTicksPartOfGround, new Vector3d(), 0.0);
            this.thisClassAsDraggable.setEntityShipMovementData(newEntityShipMovementData);
        } else {
            int newTicksPartOfGround = oldEntityShipMovementData.getLastTouchedShip() != null ? 0 : oldEntityShipMovementData.getTicksPartOfGround() + 1;
            EntityShipMovementData newEntityShipMovementData = oldEntityShipMovementData.withTicksSinceTouchedShip(oldEntityShipMovementData.getTicksSinceTouchedShip() + 1).withTicksPartOfGround(newTicksPartOfGround);
            this.thisClassAsDraggable.setEntityShipMovementData(newEntityShipMovementData);
        }
    }
}

