/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.dexx;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.github.andrewoma.dexx.collection.Map;
import com.github.andrewoma.dexx.collection.Maps;
import com.github.andrewoma.dexx.collection.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MapSerializer
extends Serializer<Map<Object, ? extends Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = true;
    private static final boolean IMMUTABLE = true;

    public MapSerializer() {
        super(true, true);
    }

    @Override
    public void write(Kryo kryo, Output output, Map<Object, ? extends Object> immutableMap) {
        kryo.writeObject(output, immutableMap.asMap());
    }

    @Override
    public Map<Object, Object> read(Kryo kryo, Input input, Class<? extends Map<Object, ? extends Object>> type) {
        HashMap map = kryo.readObject(input, HashMap.class);
        ArrayList<Pair> listOfPairs = new ArrayList<Pair>();
        for (Map.Entry entry : map.entrySet()) {
            Pair pair = new Pair(entry.getKey(), entry.getValue());
            listOfPairs.add(pair);
        }
        return Maps.copyOf(listOfPairs);
    }

    public static void registerSerializers(Kryo kryo) {
        MapSerializer serializer = new MapSerializer();
        kryo.register(Map.class, serializer);
        kryo.register(Maps.of().getClass(), serializer);
        Object o1 = new Object();
        Object o2 = new Object();
        Object o3 = new Object();
        Object o4 = new Object();
        Object o5 = new Object();
        kryo.register(Maps.of((Object)o1, (Object)o1).getClass(), serializer);
        kryo.register(Maps.of((Object)o1, (Object)o1, (Object)o2, (Object)o2).getClass(), serializer);
        kryo.register(Maps.of((Object)o1, (Object)o1, (Object)o2, (Object)o2, (Object)o3, (Object)o3).getClass(), serializer);
        kryo.register(Maps.of((Object)o1, (Object)o1, (Object)o2, (Object)o2, (Object)o3, (Object)o3, (Object)o4, (Object)o4).getClass(), serializer);
        kryo.register(Maps.of((Object)o1, (Object)o1, (Object)o2, (Object)o2, (Object)o3, (Object)o3, (Object)o4, (Object)o4, (Object)o5, (Object)o5).getClass(), serializer);
    }
}

