/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.persistence.onheap;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.support.ConcurrentOnHeapObjectStore;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.option.QueryOptions;

public class OnHeapPersistence<O, A extends Comparable<A>>
implements Persistence<O, A> {
    final SimpleAttribute<O, A> primaryKeyAttribute;
    final int initialCapacity;
    final float loadFactor;
    final int concurrencyLevel;

    public OnHeapPersistence() {
        this(null, 16, 0.75f, 16);
    }

    public OnHeapPersistence(SimpleAttribute<O, A> primaryKeyAttribute) {
        this(primaryKeyAttribute, 16, 0.75f, 16);
    }

    public OnHeapPersistence(SimpleAttribute<O, A> primaryKeyAttribute, int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.primaryKeyAttribute = primaryKeyAttribute;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.concurrencyLevel = concurrencyLevel;
    }

    @Override
    public boolean supportsIndex(Index<O> index) {
        return index instanceof OnHeapTypeIndex;
    }

    @Override
    public ObjectStore<O> createObjectStore() {
        return new ConcurrentOnHeapObjectStore(this.initialCapacity, this.loadFactor, this.concurrencyLevel);
    }

    @Override
    public void openRequestScopeResources(QueryOptions queryOptions) {
    }

    @Override
    public void closeRequestScopeResources(QueryOptions queryOptions) {
    }

    @Override
    public SimpleAttribute<O, A> getPrimaryKeyAttribute() {
        return this.primaryKeyAttribute;
    }

    public static <O, A extends Comparable<A>> OnHeapPersistence<O, A> onPrimaryKey(SimpleAttribute<O, A> primaryKeyAttribute) {
        return new OnHeapPersistence<O, A>(primaryKeyAttribute);
    }

    public static <O> OnHeapPersistence<O, ? extends Comparable> withoutPrimaryKey() {
        return OnHeapPersistence.withoutPrimaryKey_Internal();
    }

    static <O, A extends Comparable<A>> OnHeapPersistence<O, A> withoutPrimaryKey_Internal() {
        return new OnHeapPersistence<O, A>();
    }
}

