/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.Vector3f;

public abstract class ModelGenerator
extends ResourceGenerator {
    private final Map<ResourceLocation, ModelBuilder> models = new HashMap<ResourceLocation, ModelBuilder>();

    public ModelGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (ModelBuilder modelBuilder : this.models.values()) {
            JsonObject json = this.convertToJson(modelBuilder);
            ResourceLocation identifier = modelBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.ASSET, json, identifier.func_110624_b(), "models", identifier.func_110623_a());
        }
    }

    protected JsonObject convertToJson(ModelBuilder modelBuilder) {
        JsonObject json = new JsonObject();
        ResourceLocation parentModel = modelBuilder.parent;
        if (parentModel != null) {
            String name = parentModel.func_110623_a();
            String extension = ".json";
            if (name.lastIndexOf(46) > name.lastIndexOf(47) && name.lastIndexOf(46) + 1 < name.length()) {
                int index = name.lastIndexOf(46);
                extension = name.substring(index + 1);
                name = name.substring(0, index);
            }
            if (!this.models.containsKey(parentModel) && !this.cache.doesResourceExist(ResourceType.ASSET, parentModel.func_110624_b(), "models", name, extension)) {
                throw new RuntimeException("Could not find parent model '" + parentModel + "' for model '" + modelBuilder.identifier + "'!");
            }
            json.addProperty("parent", parentModel.toString());
        }
        if (modelBuilder.renderType != null) {
            json.addProperty("render_type", modelBuilder.renderType.toString());
        }
        if (!modelBuilder.ambientOcclusion) {
            json.addProperty("ambientocclusion", Boolean.valueOf(false));
        }
        if (!modelBuilder.transforms.isEmpty()) {
            JsonObject displayJson = new JsonObject();
            for (Map.Entry transform : modelBuilder.transforms.entrySet()) {
                JsonObject transformJson = new JsonObject();
                transformJson.add("rotation", (JsonElement)ModelGenerator.createJsonArray(((TransformBuilder)((TransformBuilder)transform.getValue())).rotation.x, ((TransformBuilder)((TransformBuilder)transform.getValue())).rotation.y, ((TransformBuilder)((TransformBuilder)transform.getValue())).rotation.z));
                transformJson.add("translation", (JsonElement)ModelGenerator.createJsonArray(((TransformBuilder)((TransformBuilder)transform.getValue())).translation.x, ((TransformBuilder)((TransformBuilder)transform.getValue())).translation.y, ((TransformBuilder)((TransformBuilder)transform.getValue())).translation.z));
                transformJson.add("scale", (JsonElement)ModelGenerator.createJsonArray(((TransformBuilder)((TransformBuilder)transform.getValue())).scale.x, ((TransformBuilder)((TransformBuilder)transform.getValue())).scale.y, ((TransformBuilder)((TransformBuilder)transform.getValue())).scale.z));
                String transformName = "unknown";
                if (transform.getKey() == ItemCameraTransforms.TransformType.NONE) {
                    transformName = "none";
                } else if (transform.getKey() == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                    transformName = "thirdperson_lefthand";
                } else if (transform.getKey() == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                    transformName = "thirdperson_righthand";
                } else if (transform.getKey() == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                    transformName = "firstperson_lefthand";
                } else if (transform.getKey() == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                    transformName = "firstperson_righthand";
                } else if (transform.getKey() == ItemCameraTransforms.TransformType.HEAD) {
                    transformName = "head";
                } else if (transform.getKey() == ItemCameraTransforms.TransformType.GUI) {
                    transformName = "gui";
                } else if (transform.getKey() == ItemCameraTransforms.TransformType.GROUND) {
                    transformName = "ground";
                } else if (transform.getKey() == ItemCameraTransforms.TransformType.FIXED) {
                    transformName = "fixed";
                }
                displayJson.add(transformName, (JsonElement)transformJson);
            }
            json.add("display", (JsonElement)displayJson);
        }
        if (!modelBuilder.textures.isEmpty()) {
            JsonObject texturesJson = new JsonObject();
            for (Map.Entry entry : modelBuilder.textures.entrySet()) {
                ResourceLocation texture;
                if (((String)entry.getValue()).charAt(0) != '#' && !this.cache.doesResourceExist(ResourceType.ASSET, (texture = new ResourceLocation((String)entry.getValue())).func_110624_b(), "textures", texture.func_110623_a(), ".png")) {
                    throw new IllegalArgumentException("Could not find texture '" + texture + "' for model '" + modelBuilder.identifier + "'!");
                }
                texturesJson.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            json.add("textures", (JsonElement)texturesJson);
        }
        if (modelBuilder.lighting != null) {
            json.addProperty("gui_light", modelBuilder.lighting != false ? "side" : "front");
        }
        if (!modelBuilder.elements.isEmpty()) {
            JsonArray elementsJson = new JsonArray();
            for (ElementBuilder element : modelBuilder.elements) {
                JsonObject facesJson;
                JsonObject elementJson = new JsonObject();
                elementJson.add("from", (JsonElement)ModelGenerator.createJsonArray(((ElementBuilder)element).from.x, ((ElementBuilder)element).from.y, ((ElementBuilder)element).from.z));
                elementJson.add("to", (JsonElement)ModelGenerator.createJsonArray(((ElementBuilder)element).to.x, ((ElementBuilder)element).to.y, ((ElementBuilder)element).to.z));
                if (element.rotation != null) {
                    JsonObject rotationJson = new JsonObject();
                    rotationJson.add("origin", (JsonElement)ModelGenerator.createJsonArray(((RotationBuilder)((ElementBuilder)element).rotation).origin.x, ((RotationBuilder)((ElementBuilder)element).rotation).origin.y, ((RotationBuilder)((ElementBuilder)element).rotation).origin.z));
                    rotationJson.addProperty("axis", element.rotation.axis.func_176719_a().toLowerCase(Locale.ROOT));
                    rotationJson.addProperty("angle", (Number)Float.valueOf(element.rotation.angle));
                    rotationJson.addProperty("rescale", Boolean.valueOf(element.rotation.rescale));
                    elementJson.add("rotation", (JsonElement)rotationJson);
                }
                if (!element.shading) {
                    elementJson.addProperty("shade", Boolean.valueOf(false));
                }
                if (!element.faces.isEmpty()) {
                    facesJson = new JsonObject();
                    for (Map.Entry entry : element.faces.entrySet()) {
                        JsonObject faceJson = new JsonObject();
                        if (((FaceBuilder)entry.getValue()).texture == null) {
                            throw new RuntimeException("Model '" + modelBuilder.identifier + "' has face without a texture!");
                        }
                        faceJson.addProperty("texture", ((FaceBuilder)entry.getValue()).texture);
                        if (((FaceBuilder)entry.getValue()).uv != null) {
                            faceJson.add("uv", (JsonElement)ModelGenerator.createJsonArray(((FaceBuilder)entry.getValue()).uv));
                        }
                        if (((FaceBuilder)entry.getValue()).cullface != null) {
                            faceJson.addProperty("cullface", ((FaceBuilder)entry.getValue()).cullface.func_176742_j().toLowerCase(Locale.ROOT));
                        }
                        if (((FaceBuilder)entry.getValue()).emissivity != 0) {
                            faceJson.addProperty("emissivity", (Number)((FaceBuilder)entry.getValue()).emissivity);
                        }
                        if (((FaceBuilder)entry.getValue()).rotation != 0) {
                            faceJson.addProperty("rotation", (Number)((FaceBuilder)entry.getValue()).rotation);
                        }
                        if (((FaceBuilder)entry.getValue()).tintIndex != -1) {
                            faceJson.addProperty("tintindex", (Number)((FaceBuilder)entry.getValue()).tintIndex);
                        }
                        facesJson.add(((EnumFacing)entry.getKey()).func_176742_j().toLowerCase(Locale.ROOT), (JsonElement)faceJson);
                    }
                } else {
                    throw new RuntimeException("Element in model '" + modelBuilder.identifier + "' has no faces!");
                }
                elementJson.add("faces", (JsonElement)facesJson);
                elementsJson.add((JsonElement)elementJson);
            }
            json.add("elements", (JsonElement)elementsJson);
        }
        return json;
    }

    private static JsonArray createJsonArray(float ... elements) {
        JsonArray array = new JsonArray();
        float[] fArray = elements;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float element = Float.valueOf(fArray[i]);
            array.add((Number)element);
        }
        return array;
    }

    protected ModelBuilder model(ResourceLocation location) {
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, location.func_110624_b(), "models", location.func_110623_a(), ".json");
        return this.models.computeIfAbsent(location, i -> new ModelBuilder(this.modid, (ResourceLocation)i));
    }

    protected ModelBuilder model(String namespace, String path) {
        return this.model(new ResourceLocation(namespace, path));
    }

    protected ModelBuilder model(String location) {
        return this.model(this.modid, location);
    }

    protected ModelBuilder cube(ResourceLocation location, ResourceLocation up, ResourceLocation down, ResourceLocation north, ResourceLocation east, ResourceLocation south, ResourceLocation west) {
        return this.model(location).parent("minecraft", "block/cube").texture("up", up).texture("down", down).texture("north", north).texture("east", east).texture("south", south).texture("west", west);
    }

    protected ModelBuilder cube(String namespace, String path, ResourceLocation up, ResourceLocation down, ResourceLocation north, ResourceLocation east, ResourceLocation south, ResourceLocation west) {
        return this.model(namespace, path).parent("minecraft", "block/cube").texture("up", up).texture("down", down).texture("north", north).texture("east", east).texture("south", south).texture("west", west);
    }

    protected ModelBuilder cube(String location, ResourceLocation up, ResourceLocation down, ResourceLocation north, ResourceLocation east, ResourceLocation south, ResourceLocation west) {
        return this.model(location).parent("minecraft", "block/cube").texture("up", up).texture("down", down).texture("north", north).texture("east", east).texture("south", south).texture("west", west);
    }

    protected ModelBuilder cubeAll(ResourceLocation location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "block/cube_all").texture("all", texture);
    }

    protected ModelBuilder cubeAll(String namespace, String path, ResourceLocation texture) {
        return this.model(namespace, path).parent("minecraft", "block/cube_all").texture("all", texture);
    }

    protected ModelBuilder cubeAll(String location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "block/cube_all").texture("all", texture);
    }

    protected ModelBuilder slabBottom(ResourceLocation location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/slab").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabBottom(String namespace, String path, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(namespace, path).parent("minecraft", "block/slab").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabBottom(String location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/slab").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabTop(ResourceLocation location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/slab_top").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabTop(String namespace, String path, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(namespace, path).parent("minecraft", "block/slab_top").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabTop(String location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/slab_top").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder stairs(ResourceLocation location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/stairs").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder stairs(String namespace, String path, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(namespace, path).parent("minecraft", "block/stairs").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder stairs(String location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/stairs").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder itemGenerated(ResourceLocation location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemGenerated(String namespace, String path, ResourceLocation texture) {
        return this.model(namespace, path).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemGenerated(String location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemGenerated(Item item, ResourceLocation texture) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(item);
        return this.model(identifier.func_110624_b(), "item/" + identifier.func_110623_a()).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(ResourceLocation location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "item/handheld").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(String namespace, String path, ResourceLocation texture) {
        return this.model(namespace, path).parent("minecraft", "item/handheld").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(String location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "item/handheld").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(Item item, ResourceLocation texture) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(item);
        return this.model(identifier.func_110624_b(), "item/" + identifier.func_110623_a()).parent("minecraft", "item/handheld").texture("layer0", texture);
    }

    @Override
    public String getName() {
        return this.modName + " Model Generator";
    }

    protected static class FaceBuilder {
        private final EnumFacing side;
        private float[] uv;
        private String texture;
        private EnumFacing cullface;
        private int rotation = 0;
        private int tintIndex = -1;
        private int emissivity = 0;

        protected FaceBuilder(EnumFacing side) {
            this.side = side;
        }

        public FaceBuilder uv(float minX, float minY, float maxX, float maxY) {
            this.uv = new float[]{minX, minY, maxX, maxY};
            return this;
        }

        public FaceBuilder texture(String reference) {
            if (!(reference.charAt(0) == '#' ? reference.substring(1) : reference).matches("[a-zA-Z_-]*")) {
                throw new IllegalArgumentException("Texture reference '" + reference + "' must only contain characters [a-zA-Z_-]!");
            }
            this.texture = reference.charAt(0) == '#' ? reference : "#" + reference;
            return this;
        }

        public FaceBuilder cullface(EnumFacing side) {
            this.cullface = side;
            return this;
        }

        public FaceBuilder cullface() {
            this.cullface(this.side);
            return this;
        }

        public FaceBuilder rotation(int rotation) {
            if (rotation % 90 != 0) {
                throw new IllegalArgumentException("Rotation must be a multiple of 90, not '" + rotation + "'!");
            }
            this.rotation = rotation;
            return this;
        }

        public FaceBuilder tintIndex(int index) {
            this.tintIndex = index;
            return this;
        }

        public FaceBuilder emissivity(int emissivity) {
            if (emissivity < 0 || emissivity > 15) {
                throw new IllegalArgumentException("Emissivity must be between 0 and 15, not '" + emissivity + "'!");
            }
            this.emissivity = emissivity;
            return this;
        }
    }

    protected static class RotationBuilder {
        private Vector3f origin;
        private EnumFacing.Axis axis;
        private float angle;
        private boolean rescale;

        protected RotationBuilder() {
        }

        public RotationBuilder origin(Vector3f origin) {
            this.origin = origin;
            return this;
        }

        public RotationBuilder origin(float x, float y, float z) {
            return this.origin(new Vector3f(x, y, z));
        }

        public RotationBuilder axis(EnumFacing.Axis axis) {
            this.axis = axis;
            return this;
        }

        public RotationBuilder angle(float angle) {
            if (angle != 0.0f && Math.abs(angle) != 22.5f && Math.abs(angle) != 45.0f) {
                throw new IllegalArgumentException("Angle must be one of -45, -22.5, 0, 22.5, or 45, not '" + angle + "'!");
            }
            this.angle = angle;
            return this;
        }

        public RotationBuilder rescale(boolean rescale) {
            this.rescale = rescale;
            return this;
        }

        public RotationBuilder rescale() {
            return this.rescale(true);
        }
    }

    protected static class ElementBuilder {
        private final Map<EnumFacing, FaceBuilder> faces = new HashMap<EnumFacing, FaceBuilder>();
        private Vector3f from = new Vector3f();
        private Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        private RotationBuilder rotation;
        private boolean shading = true;

        protected ElementBuilder() {
        }

        public ElementBuilder from(Vector3f from) {
            this.from = from;
            return this;
        }

        public ElementBuilder from(float x, float y, float z) {
            return this.from(new Vector3f(x, y, z));
        }

        public ElementBuilder to(Vector3f to) {
            this.to = to;
            return this;
        }

        public ElementBuilder to(float x, float y, float z) {
            return this.to(new Vector3f(x, y, z));
        }

        public ElementBuilder shape(Vector3f from, Vector3f to) {
            this.from(from);
            this.to(to);
            return this;
        }

        public ElementBuilder shape(float minX, float minY, int minZ, float maxX, float maxY, float maxZ) {
            return this.shape(new Vector3f(minX, minY, (float)minZ), new Vector3f(maxX, maxY, maxZ));
        }

        public ElementBuilder shading(boolean doShading) {
            this.shading = doShading;
            return this;
        }

        public ElementBuilder noShading() {
            return this.shading(false);
        }

        public ElementBuilder face(EnumFacing side, Consumer<FaceBuilder> faceBuilderConsumer) {
            faceBuilderConsumer.accept(this.faces.computeIfAbsent(side, FaceBuilder::new));
            return this;
        }

        public ElementBuilder allFaces(BiFunction<EnumFacing, FaceBuilder, Boolean> faceBuilderFunction) {
            for (EnumFacing side : EnumFacing.values()) {
                if (faceBuilderFunction.apply(side, this.faces.computeIfAbsent(side, FaceBuilder::new)).booleanValue()) continue;
                this.faces.remove(side);
            }
            return this;
        }

        public ElementBuilder allFaces(BiConsumer<EnumFacing, FaceBuilder> faceBuilderConsumer) {
            return this.allFaces((EnumFacing direction, FaceBuilder faceBuilder) -> {
                faceBuilderConsumer.accept((EnumFacing)direction, (FaceBuilder)faceBuilder);
                return true;
            });
        }

        public ElementBuilder allFaces(Consumer<FaceBuilder> faceBuilderConsumer) {
            return this.allFaces((EnumFacing direction, FaceBuilder faceBuilder) -> {
                faceBuilderConsumer.accept((FaceBuilder)faceBuilder);
                return true;
            });
        }

        public ElementBuilder rotation(Consumer<RotationBuilder> rotationBuilderConsumer) {
            if (this.rotation == null) {
                this.rotation = new RotationBuilder();
            }
            rotationBuilderConsumer.accept(this.rotation);
            return this;
        }
    }

    protected static class TransformBuilder {
        private Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        private Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
        private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

        protected TransformBuilder() {
        }

        public TransformBuilder rotation(float x, float y, float z) {
            this.rotation = new Vector3f(x, y, z);
            return this;
        }

        public TransformBuilder translation(float x, float y, float z) {
            this.translation = new Vector3f(x, y, z);
            return this;
        }

        public TransformBuilder scale(float x, float y, float z) {
            this.scale = new Vector3f(x, y, z);
            return this;
        }

        public TransformBuilder scale(float scale) {
            return this.scale(scale, scale, scale);
        }
    }

    protected static class ModelBuilder {
        protected final String modid;
        protected final ResourceLocation identifier;
        private final Map<String, String> textures = new LinkedHashMap<String, String>();
        private final Map<ItemCameraTransforms.TransformType, TransformBuilder> transforms = new LinkedHashMap<ItemCameraTransforms.TransformType, TransformBuilder>();
        private final List<ElementBuilder> elements = new ArrayList<ElementBuilder>();
        private ResourceLocation parent;
        private ResourceLocation renderType;
        private boolean ambientOcclusion = true;
        private Boolean lighting = null;

        protected ModelBuilder(String modid, ResourceLocation identifier) {
            this.modid = modid;
            this.identifier = identifier;
        }

        public ModelBuilder parent(ResourceLocation model) {
            if (this.identifier.equals((Object)model)) {
                throw new IllegalArgumentException("Cannot add self as parent model '" + model + "'!");
            }
            this.parent = model;
            return this;
        }

        public ModelBuilder parent(String namespace, String path) {
            return this.parent(new ResourceLocation(namespace, path));
        }

        public ModelBuilder parent(String model) {
            return this.parent(this.modid, model);
        }

        public ModelBuilder ambientOcclusion(boolean useAmbientOcclusion) {
            this.ambientOcclusion = useAmbientOcclusion;
            return this;
        }

        public ModelBuilder noAmbientOcclusion() {
            return this.ambientOcclusion(false);
        }

        public ModelBuilder frontLit() {
            this.lighting = false;
            return this;
        }

        public ModelBuilder sideLit() {
            this.lighting = true;
            return this;
        }

        public ModelBuilder texture(String key, ResourceLocation texture) {
            this.textures.put(key, texture.toString());
            return this;
        }

        public ModelBuilder texture(String key, String texture) {
            if (texture.charAt(0) != '#' && !RegistryUtil.isValidIdentifier(texture)) {
                throw new IllegalArgumentException("Texture entry must either start with '#' or be a valid resource location, not '" + texture + "'!");
            }
            if (texture.charAt(0) != '#') {
                return this.texture(key, texture.contains(":") ? new ResourceLocation(texture) : new ResourceLocation(this.modid, texture));
            }
            this.textures.put(key, texture);
            return this;
        }

        public ModelBuilder texture(String key, String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.texture(key, new ResourceLocation(namespace, identifier));
            return this;
        }

        public ModelBuilder particleTexture(ResourceLocation texture) {
            return this.texture("particle", texture);
        }

        public ModelBuilder particleTexture(String texture) {
            return this.texture("particle", texture);
        }

        public ModelBuilder particleTexture(String namespace, String identifier) {
            return this.texture("particle", namespace, identifier);
        }

        public ModelBuilder transform(ItemCameraTransforms.TransformType transformType, Consumer<TransformBuilder> transformBuilderConsumer) {
            transformBuilderConsumer.accept(this.transforms.computeIfAbsent(transformType, o -> new TransformBuilder()));
            return this;
        }

        public ModelBuilder element(Consumer<ElementBuilder> elementBuilderConsumer) {
            ElementBuilder builder = new ElementBuilder();
            elementBuilderConsumer.accept(builder);
            this.elements.add(builder);
            return this;
        }
    }
}

