/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.hypherionmc.simplerpclib.configuration.objects.Dimension;
import me.hypherionmc.simplerpclib.configuration.objects.RPCButton;
import me.hypherionmc.simplerpclib.configuration.objects.ServerEntry;
import me.hypherionmc.simplerpclib.configuration.objects.World;
import me.hypherionmc.simplerpclib.util.IUtilHandler;
import org.apache.commons.lang3.text.WordUtils;

public class APIUtils {
    public static String CUR_DIR = System.getProperty("user.dir");

    public static String capitalize(String inputString) {
        return inputString.substring(0, 1).toUpperCase() + inputString.substring(1);
    }

    public static String worldNameToReadable(String name) {
        if (name.split(":").length > 1) {
            name = name.split(":")[1];
        }
        name = name.replace("_", " ");
        return WordUtils.capitalizeFully((String)name);
    }

    public static Optional<Dimension> findDimension(List<Dimension> list, String dimensionName) {
        if (dimensionName.toLowerCase().contains("minecraft:")) {
            dimensionName = dimensionName.replace("minecraft:", "");
        }
        String finalDimensionName = dimensionName = dimensionName.toLowerCase();
        return list.stream().filter(c -> c.name.equalsIgnoreCase(finalDimensionName)).findFirst();
    }

    public static Optional<World> findWorld(List<World> list, String dimensionName) {
        if (dimensionName.toLowerCase().contains("minecraft:")) {
            dimensionName = dimensionName.replace("minecraft:", "");
        }
        String finalDimensionName = dimensionName = dimensionName.toLowerCase();
        return list.stream().filter(c -> c.worldname.equalsIgnoreCase(finalDimensionName)).findFirst();
    }

    public static List<RPCButton> parseButtons(List<RPCButton> buttons, IUtilHandler utilHandler) {
        ArrayList<RPCButton> buttons1 = new ArrayList<RPCButton>();
        buttons.forEach(bt -> {
            bt.label = utilHandler.parseVars(bt.label);
            bt.url = utilHandler.parseVars(bt.url);
            buttons1.add((RPCButton)bt);
        });
        return buttons1;
    }

    public static Optional<ServerEntry> findServer(List<ServerEntry> list, String ipAddress) {
        return list.stream().filter(c -> c.ip.equalsIgnoreCase(ipAddress)).findFirst();
    }

    public static String stringNN(String obj) {
        return obj == null ? "Unknown" : obj;
    }
}

