/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.world.caps.chunk;

import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.Reference;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.client.UpdateChunkMusicData;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.MXTuneException;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.world.caps.chunk.IModChunkPlaylist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.relauncher.Side;

public class ModChunkPlaylistHelper {
    @CapabilityInject(value=IModChunkPlaylist.class)
    public static final Capability<IModChunkPlaylist> MOD_CHUNK_DATA = (Capability)Miscellus.nonNullInjected();

    private ModChunkPlaylistHelper() {
    }

    public static void setPlaylistGuid(Chunk chunk, GUID guid) {
        try {
            ModChunkPlaylistHelper.getImpl(chunk).setPlaylistGuid(guid);
        }
        catch (MXTuneException e) {
            ModLogger.error(e);
        }
        chunk.func_76630_e();
    }

    public static GUID getPlaylistGuid(Chunk chunk) {
        try {
            return ModChunkPlaylistHelper.getImpl(chunk).getPlaylistGuid();
        }
        catch (MXTuneException e) {
            ModLogger.error(e);
            return Reference.EMPTY_GUID;
        }
    }

    private static IModChunkPlaylist getImpl(Chunk chunk) throws MXTuneException {
        if (!chunk.hasCapability(MOD_CHUNK_DATA, null)) {
            throw new MXTuneException("IModChunkData capability is null");
        }
        IModChunkPlaylist chunkData = (IModChunkPlaylist)chunk.getCapability(MOD_CHUNK_DATA, null);
        return chunkData;
    }

    public static void sync(EntityPlayer entityPlayer, Chunk chunk) {
        if (MXTune.proxy.getEffectiveSide() == Side.SERVER) {
            PacketDispatcher.sendToDimension(new UpdateChunkMusicData(chunk.field_76635_g, chunk.field_76647_h, ModChunkPlaylistHelper.getPlaylistGuid(chunk)), entityPlayer.func_130014_f_().field_73011_w.getDimension());
        }
    }
}

