/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.aeronica.mods.mxtune.util.MXTuneException;
import net.aeronica.mods.mxtune.util.MXTuneRuntimeException;
import net.aeronica.mods.mxtune.util.SoundFontProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundFontProxyManager {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String RESOURCE = "/assets/mxtune/synth/soundfont_proxy.json";
    public static ImmutableMap<Integer, SoundFontProxy> soundFontProxyMapByIndex;
    public static ImmutableMap<String, SoundFontProxy> soundFontProxyMapById;
    public static final String INSTRUMENT_DEFAULT_ID = "piano";
    private static final SoundFontProxy SOUND_FONT_PROXY_DEFAULT;
    public SoundFontProxyManager INSTANCE = new SoundFontProxyManager();

    public static SoundFontProxy getSoundFontProxyDefault() {
        return SOUND_FONT_PROXY_DEFAULT;
    }

    public static SoundFontProxy getProxy(int index) {
        return (SoundFontProxy)soundFontProxyMapByIndex.getOrDefault((Object)index, (Object)SOUND_FONT_PROXY_DEFAULT);
    }

    public static SoundFontProxy getProxy(String id) {
        return (SoundFontProxy)soundFontProxyMapById.getOrDefault((Object)id.toLowerCase(Locale.ROOT).trim(), (Object)SOUND_FONT_PROXY_DEFAULT);
    }

    public static int getPackedPreset(int index) {
        return SoundFontProxyManager.getProxy((int)index).packed_preset;
    }

    public static String getName(int index) {
        return SoundFontProxyManager.getProxy((int)index).id;
    }

    public static boolean hasTransform(int index) {
        return !SoundFontProxyManager.getProxy((int)index).transform.isEmpty();
    }

    public static String getTransform(int index) {
        return SoundFontProxyManager.getProxy((int)index).transform;
    }

    public static int getPackedPreset(String id) {
        return SoundFontProxyManager.getProxy((String)id).packed_preset;
    }

    public static String getName(String id) {
        return SoundFontProxyManager.getProxy((String)id).id;
    }

    public static String getLangKeyName(int index) {
        return String.format("item.mxtune:multi_inst.%s.name", SoundFontProxyManager.getProxy((int)index).id);
    }

    public static String getLangKeyName(String id) {
        return String.format("item.mxtune:multi_inst.%s.name", SoundFontProxyManager.getProxy((String)id).id);
    }

    public static boolean hasTransform(String id) {
        return !SoundFontProxyManager.getProxy((String)id).transform.isEmpty();
    }

    public static String getTransform(String id) {
        return SoundFontProxyManager.getProxy((String)id).transform;
    }

    public static int getIndexById(String id) {
        return SoundFontProxyManager.getProxy((String)id).index;
    }

    public static boolean hasPackedPreset(int packedPreset) {
        boolean result = false;
        for (SoundFontProxy sp : soundFontProxyMapByIndex.values()) {
            result = sp.packed_preset == packedPreset;
            if (!result) continue;
            break;
        }
        return result;
    }

    public static int getIndexForFirstMatchingPackedPreset(int packedPreset) {
        for (SoundFontProxy sp : soundFontProxyMapByIndex.values()) {
            if (sp.packed_preset != packedPreset) continue;
            return sp.index;
        }
        return 53;
    }

    static {
        SOUND_FONT_PROXY_DEFAULT = new SoundFontProxy();
        SoundFontProxyManager.SOUND_FONT_PROXY_DEFAULT.index = 50;
        SoundFontProxyManager.SOUND_FONT_PROXY_DEFAULT.packed_preset = 0;
        SoundFontProxyManager.SOUND_FONT_PROXY_DEFAULT.id = INSTRUMENT_DEFAULT_ID;
        SoundFontProxyManager.SOUND_FONT_PROXY_DEFAULT.general_midi = true;
        SoundFontProxyManager.SOUND_FONT_PROXY_DEFAULT.maple_story_2 = true;
        ImmutableMap.Builder builderByIndex = ImmutableMap.builder();
        ImmutableMap.Builder builderById = ImmutableMap.builder();
        try {
            LOGGER.debug("Loading {}", (Object)RESOURCE);
            InputStreamReader reader = new InputStreamReader(SoundFontProxyManager.class.getResourceAsStream(RESOURCE), StandardCharsets.UTF_8);
            JsonParser parser = new JsonParser();
            JsonArray elements = parser.parse((Reader)reader).getAsJsonArray();
            reader.close();
            Gson gson = new Gson();
            for (JsonElement element : elements) {
                SoundFontProxy soundFontProxy = (SoundFontProxy)gson.fromJson(element, new TypeToken<SoundFontProxy>(){}.getType());
                builderByIndex.put((Object)soundFontProxy.index, (Object)soundFontProxy);
                builderById.put((Object)soundFontProxy.id, (Object)soundFontProxy);
            }
            soundFontProxyMapByIndex = builderByIndex.build();
            soundFontProxyMapById = builderById.build();
            if (soundFontProxyMapByIndex.isEmpty()) {
                throw new MXTuneException("Failure to load soundfont_proxy json!");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new MXTuneRuntimeException(e);
        }
        LOGGER.debug("Loaded {} records from {}", (Object)soundFontProxyMapByIndex.size(), (Object)RESOURCE);
    }
}

