/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.util;

import java.util.List;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.entity.EntitySittableBlock;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PlacedInstrumentUtil {
    private PlacedInstrumentUtil() {
    }

    private static BlockPos blockUnderFoot(EntityPlayer playerIn) {
        int x = (int)Math.floor(playerIn.field_70165_t);
        int y = (int)Math.floor(playerIn.field_70163_u - playerIn.func_70033_W() - 0.6);
        int z = (int)Math.floor(playerIn.field_70161_v);
        return new BlockPos(x, y, z);
    }

    public static boolean standOnBlock(World worldIn, BlockPos posIn, EntityPlayer playerIn) {
        if (PlacedInstrumentUtil.canPlaceEntity(worldIn, posIn)) {
            BlockPos underFoot = PlacedInstrumentUtil.blockUnderFoot(playerIn);
            if (worldIn.func_180495_p(underFoot).func_177230_c() instanceof BlockLiquid || worldIn.func_175623_d(underFoot)) {
                return false;
            }
            double blockHeight = worldIn.func_180495_p((BlockPos)underFoot).func_185900_c((IBlockAccess)((IBlockAccess)Miscellus.nonNullInjected()), (BlockPos)underFoot).field_72337_e;
            EntitySittableBlock sittableBlock = new EntitySittableBlock(worldIn, underFoot, blockHeight + 0.375, false);
            worldIn.func_72838_d((Entity)sittableBlock);
            playerIn.func_184205_a((Entity)sittableBlock, true);
        }
        return true;
    }

    public static boolean sitOnBlock(World worldIn, BlockPos posIn, EntityPlayer playerIn, double yOffset) {
        if (PlacedInstrumentUtil.canPlaceEntity(worldIn, posIn)) {
            EntitySittableBlock sittableBlock = new EntitySittableBlock(worldIn, posIn, yOffset, true);
            worldIn.func_72838_d((Entity)sittableBlock);
            playerIn.func_184205_a((Entity)sittableBlock, true);
        }
        return true;
    }

    public static boolean sitOnBlock(World worldIn, BlockPos posIn, EntityPlayer playerIn, double xOffset, double yOffset, double zOffset) {
        if (PlacedInstrumentUtil.canPlaceEntity(worldIn, posIn)) {
            EntitySittableBlock sittableBlock = new EntitySittableBlock(worldIn, posIn, xOffset, yOffset, zOffset);
            worldIn.func_72838_d((Entity)sittableBlock);
            playerIn.func_184205_a((Entity)sittableBlock, true);
        }
        return true;
    }

    public static boolean sitOnBlock(World worldIn, BlockPos posIn, EntityPlayer playerIn, double xOffset, double yOffset, double zOffset, float yaw) {
        if (PlacedInstrumentUtil.canPlaceEntity(worldIn, posIn)) {
            EntitySittableBlock sittableBlock = new EntitySittableBlock(worldIn, posIn, xOffset, yOffset, zOffset, yaw);
            worldIn.func_72838_d((Entity)sittableBlock);
            playerIn.func_184205_a((Entity)sittableBlock, true);
        }
        return true;
    }

    public static boolean sitOnBlockWithRotationOffset(World worldIn, BlockPos posIn, EntityPlayer playerIn, double yOffset, int metadata, double offset) {
        if (PlacedInstrumentUtil.canPlaceEntity(worldIn, posIn)) {
            EntitySittableBlock sittableBlock = new EntitySittableBlock(worldIn, posIn, yOffset, metadata, offset);
            worldIn.func_72838_d((Entity)sittableBlock);
            playerIn.func_184220_m((Entity)sittableBlock);
        }
        return true;
    }

    private static boolean canPlaceEntity(World par1World, BlockPos posIn) {
        int x = posIn.func_177958_n();
        int y = posIn.func_177956_o();
        int z = posIn.func_177952_p();
        List listEMB = par1World.func_72872_a(EntitySittableBlock.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0).func_72314_b(1.0, 1.0, 1.0));
        for (EntitySittableBlock mount : listEMB) {
            if (!mount.getMountedPosition().equals((Object)posIn)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayerSitting(World worldIn, EntityPlayer playerIn, BlockPos posIn) {
        int z;
        int y;
        int x = posIn.func_177958_n();
        List listEMB = worldIn.func_72872_a(EntitySittableBlock.class, new AxisAlignedBB((double)x, (double)(y = posIn.func_177956_o()), (double)(z = posIn.func_177952_p()), (double)x + 1.0, (double)y + 1.0, (double)z + 1.0).func_72314_b(1.0, 1.0, 1.0));
        if (listEMB.isEmpty()) {
            return false;
        }
        for (EntitySittableBlock mount : listEMB) {
            if (!mount.getMountedPosition().equals((Object)posIn)) continue;
            return mount.func_184196_w((Entity)playerIn);
        }
        return false;
    }

    public static boolean isSomeoneSitting(World world, BlockPos pos) {
        return PlacedInstrumentUtil.isSomeoneSitting(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private static boolean isSomeoneSitting(World world, double x, double y, double z) {
        List listEMB = world.func_72872_a(EntitySittableBlock.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_72314_b(0.5, 0.5, 0.5));
        return !listEMB.isEmpty();
    }

    public static boolean isRiding(@Nullable EntityPlayer playerIn) {
        return playerIn != null && !playerIn.field_70128_L && playerIn.func_184187_bx() instanceof EntitySittableBlock;
    }

    public static BlockPos getRiddenBlock(EntityPlayer playerIn) {
        return PlacedInstrumentUtil.isRiding(playerIn) ? ((EntitySittableBlock)playerIn.func_184187_bx()).getBlockPos() : BlockPos.field_177992_a;
    }
}

