/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.status;

import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.bidirectional.ClientStateDataMessage;
import net.aeronica.mods.mxtune.status.CSDChatStatus;
import net.aeronica.mods.mxtune.status.ClientStateData;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreenOptionsSounds;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientCSDMonitor {
    private static ClientStateData csd = null;
    private static Minecraft mc = Minecraft.func_71410_x();
    private static GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
    private static boolean inGui = false;

    ClientCSDMonitor() {
    }

    public static void collectAndSend() {
        csd = ClientCSDMonitor.snapShot();
        ClientCSDMonitor.sendToServer();
        ModLogger.debug("ClientStateMonitor#initialize: " + csd, new Object[0]);
    }

    private static ClientStateData snapShot() {
        return new ClientStateData(!MIDISystemUtil.midiUnavailable(), gameSettings.func_186711_a(SoundCategory.MASTER) > 0.0f, gameSettings.func_186711_a(SoundCategory.RECORDS) > 0.0f);
    }

    private static void sendToServer() {
        ClientStateDataMessage message = new ClientStateDataMessage(csd);
        PacketDispatcher.sendToServer(message);
    }

    public static void detectAndSend() {
        if (ClientCSDMonitor.mc.field_71462_r instanceof GuiScreenOptionsSounds && !inGui) {
            ModLogger.debug("Opened GuiScreenOptionsSounds", new Object[0]);
            inGui = true;
        } else if (!(ClientCSDMonitor.mc.field_71462_r instanceof GuiScreenOptionsSounds) && inGui) {
            ModLogger.debug("Closed GuiScreenOptionsSounds", new Object[0]);
            inGui = false;
            ClientStateData ss = ClientCSDMonitor.snapShot();
            if (csd != null && !csd.isEqual(ss)) {
                csd = ss;
                ClientCSDMonitor.sendToServer();
                ModLogger.debug("ClientStateData ***Changed*** Sending to server", new Object[0]);
            }
        }
    }

    public static boolean canMXTunesPlay() {
        return csd != null && csd.isGood();
    }

    public static void sendErrorViaChat(EntityPlayer playerIn) {
        if (csd == null) {
            csd = ClientCSDMonitor.snapShot();
        }
        new CSDChatStatus(playerIn, csd);
    }
}

