/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.sound;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.managers.ClientPlayManager;
import net.aeronica.mods.mxtune.managers.GroupHelper;
import net.aeronica.mods.mxtune.sound.AudioData;
import net.aeronica.mods.mxtune.sound.CodecPCM;
import net.aeronica.mods.mxtune.sound.IAudioStatusCallback;
import net.aeronica.mods.mxtune.sound.MML2PCM;
import net.aeronica.mods.mxtune.sound.ModSoundEvents;
import net.aeronica.mods.mxtune.sound.MovingMusic;
import net.aeronica.mods.mxtune.sound.MusicClient;
import net.aeronica.mods.mxtune.sound.MusicPositioned;
import net.aeronica.mods.mxtune.sound.SoundRange;
import net.aeronica.mods.mxtune.status.ClientCSDMonitor;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public enum ClientAudio implements ISelectiveResourceReloadListener
{
    INSTANCE;

    public static final Object THREAD_SYNC;
    private static final Minecraft mc;
    private static SoundHandler handler;
    private static SoundSystem sndSystem;
    private static MusicTicker musicTicker;
    private static final int THREAD_POOL_SIZE = 2;
    private static final AudioFormat audioFormat3D;
    private static final AudioFormat audioFormatStereo;
    private static final Queue<Integer> playIDQueuePCM;
    private static final Queue<Integer> playIDQueueStreamEvent;
    private static final Map<Integer, AudioData> playIDAudioData;
    private static ExecutorService executorService;
    private static ThreadFactory threadFactory;
    private static int counter;
    private static final Queue<Integer> delayedAudioDataRemovalQueue;
    private static boolean vanillaMusicPaused;
    private static final int MAX_STREAM_CHANNELS = 16;
    private static final int DESIRED_STREAM_CHANNELS = 8;

    public static synchronized Set<Integer> getActivePlayIDs() {
        return Collections.unmodifiableSet(new HashSet<Integer>(playIDAudioData.keySet()));
    }

    private static void startThreadFactory() {
        if (threadFactory == null) {
            threadFactory = new ThreadFactoryBuilder().setNameFormat("mxTune ClientAudio-%d").setDaemon(true).setPriority(5).build();
            executorService = Executors.newFixedThreadPool(2, threadFactory);
        }
    }

    private static synchronized void addPlayIDQueue(int playID) {
        if (playIDQueuePCM.add(playID)) {
            playIDQueueStreamEvent.add(playID);
        }
    }

    @Nullable
    static Integer pollPlayIDQueuePCM() {
        return playIDQueuePCM.poll();
    }

    @Nullable
    private static Integer pollPlayIDQueueStreamEvent() {
        return playIDQueueStreamEvent.poll();
    }

    @Nullable
    private static Integer peekPlayIDQueueStreamEvent() {
        return playIDQueueStreamEvent.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AudioData getAudioData(Integer playID) {
        Object object = THREAD_SYNC;
        synchronized (object) {
            return playIDAudioData.get(playID);
        }
    }

    private static synchronized void setUuid(Integer playID, String uuid) {
        AudioData audioData = playIDAudioData.get(playID);
        if (audioData != null) {
            audioData.setUuid(uuid);
        }
    }

    static boolean hasPlayID(Integer playID) {
        return !playIDAudioData.isEmpty() && playID != -1 && playIDAudioData.containsKey(playID);
    }

    public static void play(int playID, String musicText) {
        ClientAudio.play(playID, null, musicText, GroupHelper.isClientPlaying(playID), SoundRange.NORMAL, null);
    }

    public static void play(Integer playID, @Nullable BlockPos pos, String musicText, SoundRange soundRange) {
        ClientAudio.play(playID, pos, musicText, false, soundRange, null);
    }

    public static void playLocal(int playId, String musicText, IAudioStatusCallback callback) {
        ClientAudio.play(playId, Minecraft.func_71410_x().field_71439_g.func_180425_c(), musicText, true, SoundRange.INFINITY, callback);
    }

    private static void setAudioFormat(AudioData audioData) {
        if (audioData.isClientPlayer() || audioData.getSoundRange() == SoundRange.INFINITY) {
            audioData.setAudioFormat(audioFormatStereo);
        } else {
            audioData.setAudioFormat(audioFormat3D);
        }
    }

    private static void play(int playID, @Nullable BlockPos pos, String musicText, boolean isClient, SoundRange soundRange, @Nullable IAudioStatusCallback callback) {
        ClientAudio.startThreadFactory();
        if (ClientCSDMonitor.canMXTunesPlay() && playID != -1) {
            ClientPlayManager.removeLowerPriorityPlayIds(playID);
            ClientAudio.addPlayIDQueue(playID);
            AudioData audioData = new AudioData(playID, pos, isClient, soundRange, callback);
            ClientAudio.setAudioFormat(audioData);
            AudioData result = playIDAudioData.putIfAbsent(playID, audioData);
            if (result != null) {
                ModLogger.warn("ClientAudio#play: playID: %s has already been submitted", playID);
                return;
            }
            if (isClient) {
                mc.func_147118_V().func_147682_a((ISound)new MusicClient(audioData));
            } else if (pos == null) {
                mc.func_147118_V().func_147682_a((ISound)new MovingMusic(audioData));
            } else {
                mc.func_147118_V().func_147682_a((ISound)new MusicPositioned(audioData));
            }
            executorService.execute(new CreatePCMAudioStreamFromMML(audioData, musicText));
            ClientAudio.stopVanillaMusic();
        } else {
            ModLogger.warn("ClientAudio#play(Integer playID, BlockPos pos, String musicText): playID is null!", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(int playID) {
        Object object = SoundSystemConfig.THREAD_SYNC;
        synchronized (object) {
            AudioData audioData = playIDAudioData.get(playID);
            if (sndSystem != null && audioData != null && !audioData.getUuid().isEmpty()) {
                audioData.setStatus(Status.DONE);
                sndSystem.fadeOut(audioData.getUuid(), null, 100L);
            }
        }
    }

    private static void stopVanillaMusicTicker() {
        if (ClientAudio.musicTicker.field_147678_c != null) {
            handler.func_147683_b(ClientAudio.musicTicker.field_147678_c);
            ClientAudio.musicTicker.field_147678_c = null;
            ClientAudio.musicTicker.field_147676_d = 0;
        }
    }

    private static void stopVanillaMusic() {
        ModLogger.debug("ClientAudio stopVanillaMusic - PAUSED on %d active sessions.", playIDAudioData.size());
        ClientAudio.setVanillaMusicPaused(true);
        ClientAudio.stopVanillaMusicTicker();
        ClientAudio.setVanillaMusicTimer(Integer.MAX_VALUE);
    }

    private static void resumeVanillaMusic() {
        ModLogger.debug("ClientAudio resumeVanillaMusic - RESUMED", new Object[0]);
        ClientAudio.setVanillaMusicTimer(100);
    }

    private static void setVanillaMusicTimer(int value) {
        if (musicTicker != null) {
            ClientAudio.musicTicker.field_147676_d = value;
        }
    }

    private static void setVanillaMusicPaused(boolean flag) {
        vanillaMusicPaused = flag;
    }

    private static boolean isVanillaMusicPaused() {
        return vanillaMusicPaused;
    }

    private static void updateClientAudio() {
        if (sndSystem != null) {
            if (ClientAudio.isVanillaMusicPaused() && playIDAudioData.isEmpty()) {
                ClientAudio.resumeVanillaMusic();
                ClientAudio.setVanillaMusicPaused(false);
            } else if (!playIDAudioData.isEmpty()) {
                ClientAudio.setVanillaMusicTimer(Integer.MAX_VALUE);
            }
            ClientAudio.removeQueuedAudioData();
            for (Map.Entry<Integer, AudioData> entry : playIDAudioData.entrySet()) {
                AudioData audioData = entry.getValue();
                Status status = audioData.getStatus();
                if (!ClientAudio.playIdExpired(audioData.getPlayId()) && status != Status.ERROR && status != Status.DONE) continue;
                ClientAudio.queueAudioDataRemoval(entry.getKey());
                ModLogger.debug("updateClientAudio: AudioData for playID queued for removal", new Object[0]);
            }
        }
    }

    private static boolean playIdExpired(int playId) {
        return !GroupHelper.getAllPlayIDs().contains(playId);
    }

    private static void removeQueuedAudioData() {
        while (!delayedAudioDataRemovalQueue.isEmpty()) {
            if (delayedAudioDataRemovalQueue.peek() == null) continue;
            playIDAudioData.remove(Objects.requireNonNull(delayedAudioDataRemovalQueue.poll()));
        }
    }

    public static void queueAudioDataRemoval(int playId) {
        ClientAudio.stop(playId);
        delayedAudioDataRemovalQueue.add(playId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateVolumeFades() {
        Map<Integer, AudioData> map = playIDAudioData;
        synchronized (map) {
            playIDAudioData.values().forEach(ClientAudio::updateVolumeFade);
        }
    }

    private static void updateVolumeFade(AudioData audioData) {
        if (audioData.getStatus() != Status.DONE && audioData.getStatus() != Status.ERROR && audioData.isFading()) {
            audioData.updateVolumeFade();
            if ((double)audioData.getFadeMultiplier() <= 0.05) {
                ClientAudio.queueAudioDataRemoval(audioData.getPlayId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fadeOut(int playID, int seconds) {
        Map<Integer, AudioData> map = playIDAudioData;
        synchronized (map) {
            AudioData audioData = playIDAudioData.get(playID);
            if (sndSystem != null && audioData != null && audioData.getUuid() != null && seconds > 0) {
                sndSystem.fadeOut(audioData.getUuid(), null, Math.max(Math.abs((long)seconds * 900L), 100L));
                audioData.startFadeOut(seconds);
            } else {
                ClientAudio.queueAudioDataRemoval(playID);
            }
        }
    }

    private static void init() {
        if (sndSystem == null || ClientAudio.sndSystem.randomNumberGenerator == null) {
            handler = Minecraft.func_71410_x().func_147118_V();
            SoundManager sndManager = ClientAudio.handler.field_147694_f;
            sndSystem = sndManager.field_148620_e;
            musicTicker = Minecraft.func_71410_x().func_181535_r();
            ClientAudio.setVanillaMusicPaused(false);
            playIDAudioData.clear();
            ClientPlayManager.reset();
        }
    }

    private static void cleanup() {
        ClientAudio.setVanillaMusicPaused(false);
        playIDAudioData.keySet().forEach(ClientAudio::queueAudioDataRemoval);
        playIDQueuePCM.clear();
        playIDQueueStreamEvent.clear();
    }

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.SOUNDS)) {
            ModLogger.info("Restarting mxTune", new Object[0]);
            ClientAudio.configureSound();
            ClientAudio.init();
        }
    }

    @SubscribeEvent
    public static void event(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerSP) {
            ClientAudio.cleanup();
            ClientPlayManager.reset();
            ModLogger.debug("ClientAudio EntityJoinWorldEvent: %s", event.getEntity().func_70005_c_());
        }
    }

    @SubscribeEvent
    public static void event(PlayerEvent.PlayerRespawnEvent event) {
        ClientAudio.cleanup();
        ClientPlayManager.reset();
        ModLogger.debug("ClientAudio PlayerRespawnEvent: %s", event.player.func_70005_c_());
    }

    @SubscribeEvent
    public static void event(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            if (!mc.func_147113_T()) {
                ClientAudio.updateVolumeFades();
            }
            if (counter++ % 5 == 0) {
                ClientAudio.updateClientAudio();
            }
        }
    }

    @SubscribeEvent
    public static void event(SoundSetupEvent event) throws SoundSystemException {
        SoundSystemConfig.setCodec((String)"nul", CodecPCM.class);
        ModLogger.debug("Sound Setup Event: associate the \"nul\" extension with CodecPCM.", new Object[0]);
        ModLogger.debug("Sound Streaming Buffer Size: %d", SoundSystemConfig.getStreamingBufferSize());
        ClientAudio.configureSound();
    }

    @SubscribeEvent
    public static void event(PlaySoundEvent e) {
        ClientAudio.init();
        ResourceLocation soundLocation = e.getSound().func_147650_b();
        if (ModConfig.isCreativeMusicDisabled() && soundLocation.equals((Object)SoundEvents.field_187792_dx.func_187503_a()) || ModConfig.isCreditsMusicDisabled() && soundLocation.equals((Object)SoundEvents.field_187794_dy.func_187503_a()) || ModConfig.isDragonMusicDisabled() && soundLocation.equals((Object)SoundEvents.field_187796_dz.func_187503_a()) || ModConfig.isEndMusicDisabled() && soundLocation.equals((Object)SoundEvents.field_187667_dA.func_187503_a()) || ModConfig.isGameMusicDisabled() && soundLocation.equals((Object)SoundEvents.field_187669_dB.func_187503_a()) || ModConfig.isMenuMusicDisabled() && soundLocation.equals((Object)SoundEvents.field_187671_dC.func_187503_a()) || ModConfig.isNetherMusicDisabled() && soundLocation.equals((Object)SoundEvents.field_187673_dD.func_187503_a())) {
            e.setResultSound(null);
        }
    }

    @SubscribeEvent
    public static void event(PlayStreamingSourceEvent e) {
        if (e.getSound().func_147650_b().equals((Object)ModSoundEvents.PCM_PROXY.func_187503_a()) && ClientAudio.peekPlayIDQueueStreamEvent() != null) {
            Integer playID = ClientAudio.pollPlayIDQueueStreamEvent();
            ClientAudio.setUuid(playID, e.getUuid());
            ModLogger.debug("ClientAudio PlayStreamingSourceEvent: uuid: %s, ISound: %s", e.getUuid(), e.getSound());
        }
    }

    private static void alErrorCheck() {
        int error = AL10.alGetError();
        if (error != 0) {
            ModLogger.warn("OpenAL error: %d", error);
        }
    }

    private static void configureSound() {
        int streamChannelCount;
        int totalChannels = -1;
        try {
            boolean create;
            boolean bl = create = !AL.isCreated();
            if (create) {
                AL.create();
                ClientAudio.alErrorCheck();
            }
            IntBuffer ib = BufferUtils.createIntBuffer((int)1);
            ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4112, (IntBuffer)ib);
            ClientAudio.alErrorCheck();
            totalChannels = ib.get(0);
            if (create) {
                AL.destroy();
            }
        }
        catch (Throwable e) {
            ModLogger.error(e);
        }
        int normalChannelCount = SoundSystemConfig.getNumberNormalChannels();
        if (ModConfig.getAutoConfigureChannels() && totalChannels > 64 && streamChannelCount < 8) {
            totalChannels = (totalChannels + 1) * 3 / 4;
            streamChannelCount = Math.min(Math.min(totalChannels / 5, 16), 8);
            normalChannelCount = totalChannels - streamChannelCount;
        } else if (totalChannels != -1 && normalChannelCount + streamChannelCount >= 32) {
            for (streamChannelCount = SoundSystemConfig.getNumberStreamingChannels(); streamChannelCount < 6 && normalChannelCount > 24; --normalChannelCount, ++streamChannelCount) {
            }
        }
        ModLogger.info("Sound channels: %d normal, %d streaming (total avail: %s)", normalChannelCount, streamChannelCount, totalChannels == -1 ? "UNKNOWN" : Integer.toString(totalChannels));
        SoundSystemConfig.setNumberNormalChannels((int)normalChannelCount);
        SoundSystemConfig.setNumberStreamingChannels((int)streamChannelCount);
    }

    static {
        THREAD_SYNC = new Object();
        mc = Minecraft.func_71410_x();
        audioFormat3D = new AudioFormat(48000.0f, 16, 1, true, false);
        audioFormatStereo = new AudioFormat(48000.0f, 16, 2, true, false);
        playIDQueuePCM = new ConcurrentLinkedQueue<Integer>();
        playIDQueueStreamEvent = new ConcurrentLinkedQueue<Integer>();
        playIDAudioData = new ConcurrentHashMap<Integer, AudioData>();
        executorService = null;
        threadFactory = null;
        counter = 0;
        delayedAudioDataRemovalQueue = new ConcurrentLinkedDeque<Integer>();
        vanillaMusicPaused = false;
    }

    private static class CreatePCMAudioStreamFromMML
    implements Runnable {
        private final AudioData audioData;
        private final String musicText;

        CreatePCMAudioStreamFromMML(AudioData audioData, String musicText) {
            this.audioData = audioData;
            this.musicText = musicText;
        }

        @Override
        public void run() {
            MML2PCM mml2PCM = new MML2PCM(this.audioData, this.musicText);
            mml2PCM.process();
        }
    }

    public static enum Status {
        WAITING,
        READY,
        ERROR,
        DONE;

    }
}

