/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.options;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.options.ClassifiedPlayer;
import net.aeronica.mods.mxtune.options.IPlayerMusicOptions;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.options.PlayerMusicDefImpl;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerMusicOptionsCapability {
    @CapabilityInject(value=IPlayerMusicOptions.class)
    private static final Capability<IPlayerMusicOptions> MUSIC_OPTIONS = (Capability)Miscellus.nonNullInjected();

    private PlayerMusicOptionsCapability() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IPlayerMusicOptions.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public static class Storage
    implements Capability.IStorage<IPlayerMusicOptions> {
        static final String KEY_DISABLE_HUD = "disableHud";
        static final String KEY_POSITION_HUD = "positionHud";
        static final String KEY_SIZE_HUD = "sizeHud";
        static final String KEY_MUTE_OPTION = "muteOption";
        static final String KEY_S_PARAM_1 = "sParam1";
        static final String KEY_S_PARAM_2 = "sParam2";
        static final String KEY_S_PARAM_3 = "sParam3";
        static final String KEY_LIST_BLACK = "listBlack";
        static final String KEY_LIST_WHITE = "listWhite";
        static final String KEY_UUID_LEAST = "UUIDLeast";
        static final String KEY_UUID_MOST = "UUIDMost";
        static final String KEY_PLAYER_NAME = "playerName";
        static final String KEY_SOUND_RANGE_INFINITY_ALLOWED = "soundRangeInfinityAllowed";
        static final String KEY_MXTUNE_SERVER_UPDATE_ALLOWED = "mxTuneServerUpdateAllowed";
        static final String KEY_SELECTED_PLAY_LIST_GUID = "selectedPlayListGuid";

        public NBTBase writeNBT(Capability<IPlayerMusicOptions> capability, IPlayerMusicOptions instance, EnumFacing side) {
            NBTTagCompound properties = new NBTTagCompound();
            properties.func_74757_a(KEY_DISABLE_HUD, instance.isHudDisabled());
            properties.func_74768_a(KEY_POSITION_HUD, instance.getPositionHud());
            properties.func_74776_a(KEY_SIZE_HUD, instance.getSizeHud());
            properties.func_74768_a(KEY_MUTE_OPTION, instance.getMuteOption());
            properties.func_74778_a(KEY_S_PARAM_1, instance.getSParam1());
            properties.func_74778_a(KEY_S_PARAM_2, instance.getSParam2());
            properties.func_74778_a(KEY_S_PARAM_3, instance.getSParam3());
            properties.func_74757_a(KEY_SOUND_RANGE_INFINITY_ALLOWED, instance.isSoundRangeInfinityRangeAllowed());
            properties.func_74757_a(KEY_MXTUNE_SERVER_UPDATE_ALLOWED, instance.isMxTuneServerUpdateAllowed());
            NBTHelper.setGuidToTag(instance.getSelectedPlayListGuid(), properties, KEY_SELECTED_PLAY_LIST_GUID);
            NBTTagList listBlack = new NBTTagList();
            properties.func_74782_a(KEY_LIST_BLACK, (NBTBase)listBlack);
            for (int i = 0; i < instance.getBlackList().size(); ++i) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74772_a(KEY_UUID_LEAST, instance.getBlackList().get(i).getUuid().getLeastSignificantBits());
                entry.func_74772_a(KEY_UUID_MOST, instance.getBlackList().get(i).getUuid().getMostSignificantBits());
                entry.func_74778_a(KEY_PLAYER_NAME, instance.getBlackList().get(i).getPlayerName());
                listBlack.func_74742_a((NBTBase)entry);
            }
            NBTTagList listWhite = new NBTTagList();
            properties.func_74782_a(KEY_LIST_WHITE, (NBTBase)listWhite);
            for (int i = 0; i < instance.getWhiteList().size(); ++i) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74772_a(KEY_UUID_LEAST, instance.getWhiteList().get(i).getUuid().getLeastSignificantBits());
                entry.func_74772_a(KEY_UUID_MOST, instance.getWhiteList().get(i).getUuid().getMostSignificantBits());
                entry.func_74778_a(KEY_PLAYER_NAME, instance.getWhiteList().get(i).getPlayerName());
                listWhite.func_74742_a((NBTBase)entry);
            }
            return properties;
        }

        public void readNBT(Capability<IPlayerMusicOptions> capability, IPlayerMusicOptions instance, EnumFacing side, NBTBase nbt) {
            ClassifiedPlayer plist;
            NBTTagCompound entry;
            int i;
            int count;
            NBTTagCompound properties = (NBTTagCompound)nbt;
            instance.setHudOptions(properties.func_74767_n(KEY_DISABLE_HUD), properties.func_74762_e(KEY_POSITION_HUD), properties.func_74760_g(KEY_SIZE_HUD));
            instance.setMuteOption(properties.func_74762_e(KEY_MUTE_OPTION));
            instance.setSParams(properties.func_74779_i(KEY_S_PARAM_1), properties.func_74779_i(KEY_S_PARAM_2), properties.func_74779_i(KEY_S_PARAM_3));
            instance.setSoundRangeInfinityAllowed(properties.func_74767_n(KEY_SOUND_RANGE_INFINITY_ALLOWED));
            instance.setMxTuneServerUpdateAllowed(properties.func_74767_n(KEY_MXTUNE_SERVER_UPDATE_ALLOWED));
            instance.setSelectedPlayListGuid(NBTHelper.getGuidFromTag(properties, KEY_SELECTED_PLAY_LIST_GUID));
            if (properties.func_150297_b(KEY_LIST_BLACK, 9)) {
                NBTTagList listBlack = properties.func_150295_c(KEY_LIST_BLACK, 10);
                count = listBlack.func_74745_c();
                ArrayList<ClassifiedPlayer> blackList = new ArrayList<ClassifiedPlayer>();
                for (i = 0; i < count; ++i) {
                    entry = listBlack.func_150305_b(i);
                    plist = new ClassifiedPlayer();
                    plist.setPlayerName(entry.func_74779_i(KEY_PLAYER_NAME));
                    plist.setUuid(new UUID(entry.func_74763_f(KEY_UUID_MOST), entry.func_74763_f(KEY_UUID_LEAST)));
                    plist.setOnline(false);
                    blackList.add(plist);
                }
                instance.setBlackList(blackList);
            }
            if (properties.func_150297_b(KEY_LIST_WHITE, 9)) {
                NBTTagList listWhite = properties.func_150295_c(KEY_LIST_WHITE, 10);
                count = listWhite.func_74745_c();
                ArrayList<ClassifiedPlayer> whiteList = new ArrayList<ClassifiedPlayer>();
                for (i = 0; i < count; ++i) {
                    entry = listWhite.func_150305_b(i);
                    plist = new ClassifiedPlayer();
                    plist.setPlayerName(entry.func_74779_i(KEY_PLAYER_NAME));
                    plist.setUuid(new UUID(entry.func_74763_f(KEY_UUID_MOST), entry.func_74763_f(KEY_UUID_LEAST)));
                    plist.setOnline(false);
                    whiteList.add(plist);
                }
                instance.setWhiteList(whiteList);
            }
        }
    }

    private static class Factory
    implements Callable<IPlayerMusicOptions> {
        private Factory() {
        }

        @Override
        public IPlayerMusicOptions call() {
            return new PlayerMusicDefImpl();
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                event.addCapability(new ResourceLocation("mxtune", "IPlayerMusicOptions"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                    final IPlayerMusicOptions optionsInst = (IPlayerMusicOptions)PlayerMusicOptionsCapability.access$100().getDefaultInstance();

                    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == MUSIC_OPTIONS;
                    }

                    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                        return (T)(capability == MUSIC_OPTIONS ? this.optionsInst : null);
                    }

                    @Nullable
                    public NBTTagCompound serializeNBT() {
                        return (NBTTagCompound)MUSIC_OPTIONS.getStorage().writeNBT(MUSIC_OPTIONS, (Object)this.optionsInst, null);
                    }

                    public void deserializeNBT(NBTTagCompound nbt) {
                        MUSIC_OPTIONS.getStorage().readNBT(MUSIC_OPTIONS, (Object)this.optionsInst, null, (NBTBase)nbt);
                    }
                });
            }
        }

        @SubscribeEvent
        public void onPlayerClone(PlayerEvent.Clone event) {
            if (event.isWasDeath()) {
                IPlayerMusicOptions dead = (IPlayerMusicOptions)event.getOriginal().getCapability(MUSIC_OPTIONS, null);
                IPlayerMusicOptions live = (IPlayerMusicOptions)event.getEntityPlayer().getCapability(MUSIC_OPTIONS, null);
                if (live != null && dead != null) {
                    live.setSParams(dead.getSParam1(), dead.getSParam2(), dead.getSParam3());
                    live.setHudOptions(dead.isHudDisabled(), dead.getPositionHud(), dead.getSizeHud());
                    live.setMuteOption(dead.getMuteOption());
                    live.setBlackList(dead.getBlackList());
                    live.setWhiteList(dead.getWhiteList());
                    live.setSoundRangeInfinityAllowed(dead.isSoundRangeInfinityRangeAllowed());
                    live.setMxTuneServerUpdateAllowed(dead.isSoundRangeInfinityRangeAllowed());
                    live.setSelectedPlayListGuid(dead.getSelectedPlayListGuid());
                }
            }
        }

        @SubscribeEvent
        public void onEntityJoinWorld(EntityJoinWorldEvent event) {
            IPlayerMusicOptions inst;
            if (event.getEntity() instanceof EntityPlayerMP && (inst = (IPlayerMusicOptions)event.getEntity().getCapability(MUSIC_OPTIONS, null)) != null) {
                MusicOptionsUtil.syncAll((EntityPlayer)event.getEntity());
            }
        }

        @SubscribeEvent
        public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
            IPlayerMusicOptions inst = (IPlayerMusicOptions)event.player.getCapability(MUSIC_OPTIONS, null);
            if (inst != null) {
                MusicOptionsUtil.syncAll(event.player);
            }
        }
    }
}

