/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.server;

import io.netty.buffer.ByteBuf;
import net.aeronica.mods.mxtune.init.ModItems;
import net.aeronica.mods.mxtune.items.ItemMusicPaper;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.NetworkStringHelper;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class MusicTextMessage
extends AbstractMessage.AbstractServerMessage<MusicTextMessage> {
    private String musicTitle;
    private String musicText;
    private NetworkStringHelper stringHelper = new NetworkStringHelper();

    public MusicTextMessage() {
    }

    public MusicTextMessage(String musicTitle, String musicText) {
        this.musicTitle = musicTitle;
        this.musicText = musicText;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.musicTitle = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.musicText = this.stringHelper.readLongString(buffer);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.musicTitle);
        this.stringHelper.writeLongString(buffer, this.musicText);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isServer()) {
            this.processServer(player);
        }
    }

    private void processServer(EntityPlayer player) {
        String mml = this.musicText.trim();
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemMusicPaper) {
            ItemStack sheetMusic = new ItemStack((Item)ModItems.ITEM_SHEET_MUSIC);
            if (SheetMusicUtil.writeSheetMusic(sheetMusic, this.musicTitle, mml)) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                if (!player.field_71071_by.func_70441_a(sheetMusic.func_77946_l())) {
                    player.func_146097_a(sheetMusic, false, false);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("mxtune.status.mml_server_side_validation_failure", new Object[0]), false);
                Miscellus.audiblePingPlayer(player, SoundEvents.field_187692_g);
            }
            player.field_71069_bz.func_75142_b();
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("mxtune.status.mml_server_side_music_paper_supply_empty", new Object[0]), false);
            Miscellus.audiblePingPlayer(player, SoundEvents.field_187692_g);
        }
    }
}

