/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.server;

import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.client.ResetClientPlayEngine;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.world.caps.chunk.ModChunkPlaylistHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;

public class ChunkToolMessage
extends AbstractMessage.AbstractServerMessage<ChunkToolMessage> {
    private Operation op;

    public ChunkToolMessage() {
    }

    public ChunkToolMessage(Operation op) {
        this.op = op;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.op = (Operation)buffer.func_179257_a(Operation.class);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.op);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        World world;
        Chunk chunk;
        if (MusicOptionsUtil.isMxTuneServerUpdateAllowed(player) && (chunk = (world = player.field_70170_p).func_175726_f(player.func_180425_c())).func_177410_o()) {
            switch (this.op) {
                case START: {
                    MusicOptionsUtil.setChunkStart(player, chunk);
                    MusicOptionsUtil.setChunkToolOperation(player, Operation.END);
                    break;
                }
                case END: {
                    MusicOptionsUtil.setChunkEnd(player, chunk);
                    MusicOptionsUtil.setChunkToolOperation(player, Operation.APPLY);
                    break;
                }
                case APPLY: {
                    this.apply(player);
                    MusicOptionsUtil.setChunkToolOperation(player, Operation.START);
                    break;
                }
                case RESET: {
                    MusicOptionsUtil.setChunkToolOperation(player, Operation.START);
                    MusicOptionsUtil.setChunkStart(player, null);
                    MusicOptionsUtil.setChunkEnd(player, null);
                }
            }
        }
    }

    private void apply(EntityPlayer player) {
        int errorCount = 0;
        World world = player.field_70170_p;
        Chunk chunkStart = MusicOptionsUtil.getChunkStart(player);
        Chunk chunkEnd = MusicOptionsUtil.getChunkEnd(player);
        if (chunkStart != null && chunkEnd != null && world != null && world.equals(chunkStart.func_177412_p()) && world.equals(chunkEnd.func_177412_p())) {
            GUID guidPlaylist = MusicOptionsUtil.getSelectedPlayListGuid(player);
            int totalChunks = (Math.abs(chunkStart.field_76635_g - chunkEnd.field_76635_g) + 1) * (Math.abs(chunkStart.field_76647_h - chunkEnd.field_76647_h) + 1);
            ModLogger.debug("ChunkToolMessage: Total Chunks: %d", totalChunks);
            int minX = Math.min(chunkStart.field_76635_g, chunkEnd.field_76635_g);
            int maxX = Math.max(chunkStart.field_76635_g, chunkEnd.field_76635_g);
            int minZ = Math.min(chunkStart.field_76647_h, chunkEnd.field_76647_h);
            int maxZ = Math.max(chunkStart.field_76647_h, chunkEnd.field_76647_h);
            ModLogger.debug("ChunkToolMessage: x: %d to %d", minX, maxX);
            ModLogger.debug("ChunkToolMessage: z: %d to %d", minZ, maxZ);
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (world.func_190526_b(x, z)) {
                        Chunk chunk = world.func_72964_e(x, z);
                        ModChunkPlaylistHelper.setPlaylistGuid(chunk, guidPlaylist);
                        ModChunkPlaylistHelper.sync(player, chunk);
                        continue;
                    }
                    ++errorCount;
                    ModLogger.debug("  ChunkToolMessage: Not Loaded @ x: %+03d, z: %+03d", x, z);
                }
            }
            ModLogger.debug("  ChunkToolMessage: Error count: %d", errorCount);
            PacketDispatcher.sendToAll(new ResetClientPlayEngine());
        }
    }

    public static enum Operation {
        START,
        END,
        RESET,
        APPLY;

    }
}

