/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.client;

import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.world.caps.world.ModWorldPlaylistHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class UpdateWorldMusicData
extends AbstractMessage.AbstractClientMessage<UpdateWorldMusicData> {
    private GUID guid;
    private long ddddSigBits;
    private long ccccSigBits;
    private long bbbbSigBits;
    private long aaaaSigBits;

    public UpdateWorldMusicData() {
    }

    public UpdateWorldMusicData(GUID guid) {
        this.guid = guid;
        this.ddddSigBits = guid.getDdddSignificantBits();
        this.ccccSigBits = guid.getCcccSignificantBits();
        this.bbbbSigBits = guid.getBbbbSignificantBits();
        this.aaaaSigBits = guid.getAaaaSignificantBits();
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.ddddSigBits = buffer.readLong();
        this.ccccSigBits = buffer.readLong();
        this.bbbbSigBits = buffer.readLong();
        this.aaaaSigBits = buffer.readLong();
        this.guid = new GUID(this.ddddSigBits, this.ccccSigBits, this.bbbbSigBits, this.aaaaSigBits);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.writeLong(this.ddddSigBits);
        buffer.writeLong(this.ccccSigBits);
        buffer.writeLong(this.bbbbSigBits);
        buffer.writeLong(this.aaaaSigBits);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        World world = MXTune.proxy.getClientWorld();
        if (world != null && world.hasCapability(ModWorldPlaylistHelper.MOD_WORLD_DATA, null)) {
            ModWorldPlaylistHelper.setPlaylistGuid(world, this.guid);
        }
    }
}

