/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.client;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.server.ChunkToolMessage;
import net.aeronica.mods.mxtune.options.ClassifiedPlayer;
import net.aeronica.mods.mxtune.options.IPlayerMusicOptions;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class SyncPlayerMusicOptionsMessage
extends AbstractMessage.AbstractClientMessage<SyncPlayerMusicOptionsMessage> {
    @CapabilityInject(value=IPlayerMusicOptions.class)
    private static final Capability<IPlayerMusicOptions> MUSIC_OPTIONS = (Capability)Miscellus.nonNullInjected();
    private int propertyID;
    private NBTTagCompound data;
    private boolean disableHud;
    private int positionHud;
    private float sizeHud;
    private int muteOption;
    private String sParam1;
    private String sParam2;
    private String sParam3;
    private List<ClassifiedPlayer> blackList;
    private List<ClassifiedPlayer> whiteList;
    private boolean allowMusicOp;
    private GUID selectedAreaGuid;
    private boolean ctrlKeyDown;
    private ChunkToolMessage.Operation operation;
    private byte[] byteBuffer = null;

    public SyncPlayerMusicOptionsMessage() {
    }

    public SyncPlayerMusicOptionsMessage(IPlayerMusicOptions inst, int propertyID) {
        this.propertyID = propertyID;
        switch (propertyID) {
            case 0: {
                this.data = new NBTTagCompound();
                this.data = (NBTTagCompound)MUSIC_OPTIONS.writeNBT((Object)inst, null);
                break;
            }
            case 1: {
                this.disableHud = inst.isHudDisabled();
                this.positionHud = inst.getPositionHud();
                this.sizeHud = inst.getSizeHud();
                break;
            }
            case 2: {
                this.muteOption = inst.getMuteOption();
                break;
            }
            case 3: {
                this.sParam1 = inst.getSParam1();
                this.sParam2 = inst.getSParam2();
                this.sParam3 = inst.getSParam3();
                break;
            }
            case 4: {
                this.whiteList = inst.getWhiteList();
                break;
            }
            case 5: {
                this.blackList = inst.getBlackList();
                break;
            }
            case 6: {
                this.allowMusicOp = inst.isMxTuneServerUpdateAllowed();
                break;
            }
            case 7: {
                this.selectedAreaGuid = inst.getSelectedPlayListGuid();
                break;
            }
            case 8: {
                this.ctrlKeyDown = inst.isCtrlKeyDown();
                break;
            }
            case 9: {
                this.operation = inst.getChunkToolOperation();
                break;
            }
        }
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.propertyID = buffer.readInt();
        switch (this.propertyID) {
            case 0: {
                this.data = buffer.func_150793_b();
                break;
            }
            case 1: {
                this.disableHud = buffer.readBoolean();
                this.positionHud = buffer.readInt();
                this.sizeHud = buffer.readFloat();
                break;
            }
            case 2: {
                this.muteOption = buffer.readInt();
                break;
            }
            case 3: {
                this.sParam1 = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                this.sParam2 = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                this.sParam3 = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                break;
            }
            case 4: {
                this.whiteList = this.readPlayerList(buffer);
                break;
            }
            case 5: {
                this.blackList = this.readPlayerList(buffer);
                break;
            }
            case 6: {
                this.allowMusicOp = buffer.readBoolean();
                break;
            }
            case 7: {
                long ddddSigBits = buffer.readLong();
                long ccccSigBits = buffer.readLong();
                long bbbbSigBits = buffer.readLong();
                long aaaaSigBits = buffer.readLong();
                this.selectedAreaGuid = new GUID(ddddSigBits, ccccSigBits, bbbbSigBits, aaaaSigBits);
                break;
            }
            case 8: {
                this.ctrlKeyDown = buffer.readBoolean();
                break;
            }
            case 9: {
                this.operation = (ChunkToolMessage.Operation)buffer.func_179257_a(ChunkToolMessage.Operation.class);
                break;
            }
        }
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.writeInt(this.propertyID);
        switch (this.propertyID) {
            case 0: {
                buffer.func_150786_a(this.data);
                break;
            }
            case 1: {
                buffer.writeBoolean(this.disableHud);
                buffer.writeInt(this.positionHud);
                buffer.writeFloat(this.sizeHud);
                break;
            }
            case 2: {
                buffer.writeInt(this.muteOption);
                break;
            }
            case 3: {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.sParam1);
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.sParam2);
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.sParam3);
                break;
            }
            case 4: {
                this.writePlayerList(buffer, this.whiteList);
                break;
            }
            case 5: {
                this.writePlayerList(buffer, this.blackList);
                break;
            }
            case 6: {
                buffer.writeBoolean(this.allowMusicOp);
                break;
            }
            case 7: {
                buffer.writeLong(this.selectedAreaGuid.getDdddSignificantBits());
                buffer.writeLong(this.selectedAreaGuid.getCcccSignificantBits());
                buffer.writeLong(this.selectedAreaGuid.getBbbbSignificantBits());
                buffer.writeLong(this.selectedAreaGuid.getAaaaSignificantBits());
                break;
            }
            case 8: {
                buffer.writeBoolean(this.ctrlKeyDown);
                break;
            }
            case 9: {
                buffer.func_179249_a((Enum)this.operation);
                break;
            }
        }
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        IPlayerMusicOptions instance;
        if (player.hasCapability(MUSIC_OPTIONS, null) && (instance = (IPlayerMusicOptions)player.getCapability(MUSIC_OPTIONS, null)) != null) {
            switch (this.propertyID) {
                case 0: {
                    MUSIC_OPTIONS.readNBT((Object)instance, null, (NBTBase)this.data);
                    break;
                }
                case 1: {
                    instance.setHudOptions(this.disableHud, this.positionHud, this.sizeHud);
                    break;
                }
                case 2: {
                    instance.setMuteOption(this.muteOption);
                    break;
                }
                case 3: {
                    instance.setSParams(this.sParam1, this.sParam2, this.sParam3);
                    break;
                }
                case 4: {
                    instance.setWhiteList(this.whiteList);
                    break;
                }
                case 5: {
                    instance.setBlackList(this.blackList);
                    break;
                }
                case 6: {
                    instance.setMxTuneServerUpdateAllowed(this.allowMusicOp);
                    break;
                }
                case 7: {
                    instance.setSelectedPlayListGuid(this.selectedAreaGuid);
                    break;
                }
                case 8: {
                    instance.setCtrlKey(this.ctrlKeyDown);
                    break;
                }
                case 9: {
                    instance.setChunkToolOperation(this.operation);
                    break;
                }
            }
        }
    }

    private List<ClassifiedPlayer> readPlayerList(PacketBuffer buffer) {
        List playerList = Collections.emptyList();
        try {
            this.byteBuffer = buffer.func_179251_a();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.byteBuffer);
            ObjectInputStream in = new ObjectInputStream(bis);
            playerList = (List)in.readObject();
            in.close();
        }
        catch (IOException | ClassNotFoundException e) {
            ModLogger.error(e);
        }
        return playerList;
    }

    private void writePlayerList(PacketBuffer buffer, List<ClassifiedPlayer> playerListIn) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject((Serializable)((Object)playerListIn));
            out.close();
            this.byteBuffer = bos.toByteArray();
            buffer.func_179250_a(this.byteBuffer);
        }
        catch (IOException e) {
            ModLogger.error(e);
        }
    }
}

