/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.client;

import net.aeronica.mods.mxtune.managers.GroupHelper;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.NetworkStringHelper;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.sound.ClientAudio;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class PlaySoloMessage
extends AbstractMessage.AbstractClientMessage<PlaySoloMessage> {
    private int playID;
    private String musicText;
    private NetworkStringHelper stringHelper = new NetworkStringHelper();

    public PlaySoloMessage() {
    }

    public PlaySoloMessage(int playID, String musicText) {
        this.playID = playID;
        this.musicText = musicText;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.playID = buffer.readInt();
        this.musicText = this.stringHelper.readLongString(buffer);
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.writeInt(this.playID);
        this.stringHelper.writeLongString(buffer, this.musicText);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (!MIDISystemUtil.midiUnavailableWarn(player)) {
            Integer otherEntityID = GroupHelper.getSoloMemberByPlayID(this.playID) == null ? player.func_145782_y() : GroupHelper.getSoloMemberByPlayID(this.playID).intValue();
            if (MusicOptionsUtil.playerNotMuted(player, (EntityPlayer)player.func_130014_f_().func_73045_a(otherEntityID.intValue()))) {
                ModLogger.debug("musicText: " + this.musicText.substring(0, this.musicText.length() >= 25 ? 25 : this.musicText.length()), new Object[0]);
                ModLogger.debug("playID:    " + this.playID, new Object[0]);
                GroupHelper.addServerManagedActivePlayID(this.playID);
                ClientAudio.play(this.playID, this.musicText);
            }
        }
    }
}

