/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.bidirectional;

import java.io.IOException;
import java.io.Serializable;
import net.aeronica.mods.mxtune.Reference;
import net.aeronica.mods.mxtune.managers.ServerFileManager;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.aeronica.mods.mxtune.managers.records.RecordType;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.NetworkSerializedHelper;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.client.SendResultMessage;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.ResultMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;

public class SetServerSerializedDataMessage
extends AbstractMessage.AbstractServerMessage<SetServerSerializedDataMessage> {
    private RecordType recordType = RecordType.PLAY_LIST;
    private Serializable baseData;
    private long ddddSigBits;
    private long ccccSigBits;
    private long bbbbSigBits;
    private long aaaaSigBits;
    private GUID dataTypeUuid = Reference.EMPTY_GUID;

    public SetServerSerializedDataMessage() {
    }

    public SetServerSerializedDataMessage(GUID guidType, RecordType recordType, Serializable baseData) {
        this.recordType = recordType;
        this.baseData = baseData;
        this.ddddSigBits = guidType.getDdddSignificantBits();
        this.ccccSigBits = guidType.getCcccSignificantBits();
        this.bbbbSigBits = guidType.getBbbbSignificantBits();
        this.aaaaSigBits = guidType.getAaaaSignificantBits();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.recordType = (RecordType)buffer.func_179257_a(RecordType.class);
        this.baseData = NetworkSerializedHelper.readSerializedObject(buffer);
        this.ddddSigBits = buffer.readLong();
        this.ccccSigBits = buffer.readLong();
        this.bbbbSigBits = buffer.readLong();
        this.aaaaSigBits = buffer.readLong();
        this.dataTypeUuid = new GUID(this.ddddSigBits, this.ccccSigBits, this.bbbbSigBits, this.aaaaSigBits);
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.func_179249_a((Enum)this.recordType);
        NetworkSerializedHelper.writeSerializedObject(buffer, this.baseData);
        buffer.writeLong(this.ddddSigBits);
        buffer.writeLong(this.ccccSigBits);
        buffer.writeLong(this.bbbbSigBits);
        buffer.writeLong(this.aaaaSigBits);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        ResultMessage resultMessage = ResultMessage.NO_ERROR;
        if (MusicOptionsUtil.isMxTuneServerUpdateAllowed(player)) {
            switch (this.recordType) {
                case PLAY_LIST: {
                    PlayList playList = (PlayList)this.baseData;
                    resultMessage = ServerFileManager.setPlayList(this.dataTypeUuid, playList);
                    ModLogger.debug("PLAY_LIST Serialized Test: pass %s", this.dataTypeUuid.equals(playList.getGUID()));
                    break;
                }
                case MXT: {
                    MXTuneFile mxTuneFile = (MXTuneFile)this.baseData;
                    resultMessage = ServerFileManager.setMXTFile(this.dataTypeUuid, mxTuneFile);
                    ModLogger.debug("MXT Serialized Test: pass %s", this.dataTypeUuid.equals(mxTuneFile.getGUID()));
                    break;
                }
                default: {
                    resultMessage = new ResultMessage(true, (ITextComponent)new TextComponentTranslation("mxtune.error.unexpected_type", new Object[]{this.recordType.name()}));
                    break;
                }
            }
        } else {
            PacketDispatcher.sendTo(new SendResultMessage((ITextComponent)new TextComponentTranslation("mxtune.warning.set_server_data_not_allowed", new Object[0]), true), (EntityPlayerMP)player);
        }
        if (resultMessage.hasError().booleanValue()) {
            PacketDispatcher.sendTo(new SendResultMessage(resultMessage.getMessage(), resultMessage.hasError()), (EntityPlayerMP)player);
        }
    }
}

