/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.bidirectional;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.aeronica.mods.mxtune.managers.ServerFileManager;
import net.aeronica.mods.mxtune.managers.records.BaseData;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.aeronica.mods.mxtune.managers.records.RecordType;
import net.aeronica.mods.mxtune.managers.records.SongProxy;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.util.CallBack;
import net.aeronica.mods.mxtune.util.CallBackManager;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.Notify;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;

public class GetBaseDataListsMessage<E extends BaseData>
extends AbstractMessage<GetBaseDataListsMessage<E>> {
    private RecordType recordType;
    private byte[] byteBuffer = null;
    private long callbackUuidMSB = 0L;
    private long callbackUuidLSB = 0L;
    private ITextComponent message = new TextComponentTranslation("mxtune.no_error", new Object[]{""});
    private UUID callbackUuid;
    private List<E> listBaseData;
    private boolean readError = false;

    public GetBaseDataListsMessage() {
    }

    public GetBaseDataListsMessage(UUID callback, RecordType recordType) {
        this.recordType = recordType;
        this.callbackUuidMSB = callback.getMostSignificantBits();
        this.callbackUuidLSB = callback.getLeastSignificantBits();
    }

    public GetBaseDataListsMessage(List<E> listBaseData, UUID callbackUuid, RecordType recordType, ITextComponent message) {
        this.recordType = recordType;
        this.listBaseData = listBaseData;
        this.message = message;
        this.callbackUuidMSB = callbackUuid.getMostSignificantBits();
        this.callbackUuidLSB = callbackUuid.getLeastSignificantBits();
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.recordType = (RecordType)buffer.func_179257_a(RecordType.class);
        this.callbackUuidMSB = buffer.readLong();
        this.callbackUuidLSB = buffer.readLong();
        this.message = ITextComponent.Serializer.func_150699_a((String)buffer.func_150789_c(Short.MAX_VALUE));
        this.callbackUuid = new UUID(this.callbackUuidMSB, this.callbackUuidLSB);
        try {
            this.byteBuffer = buffer.func_179251_a();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.byteBuffer);
            ObjectInputStream in = new ObjectInputStream(bis);
            this.listBaseData = (ArrayList)in.readObject();
            in.close();
        }
        catch (IOException | ClassNotFoundException e) {
            this.readError = true;
            ModLogger.error(e);
        }
    }

    @Override
    protected void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.recordType);
        buffer.writeLong(this.callbackUuidMSB);
        buffer.writeLong(this.callbackUuidLSB);
        buffer.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)this.message));
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject((Serializable)((Object)this.listBaseData));
            out.close();
            this.byteBuffer = bos.toByteArray();
            buffer.func_179250_a(this.byteBuffer);
        }
        catch (IOException e) {
            ModLogger.error(e);
        }
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            this.handleClientSide();
        } else {
            this.handleServerSide((EntityPlayerMP)player);
        }
    }

    private void handleClientSide() {
        CallBack callBack = CallBackManager.getCaller(this.callbackUuid);
        if (callBack == null) {
            return;
        }
        Notify notify = CallBackManager.getNotified(this.callbackUuid);
        if (!this.readError) {
            callBack.onResponse(this.listBaseData, this.recordType);
            if (notify != null) {
                notify.onNotify(this.recordType);
            }
        } else {
            callBack.onFailure(this.message.func_150258_a("/n").func_150257_a((ITextComponent)new TextComponentTranslation("mxtune.error.network_data_error", new Object[]{"CLIENT Read Error."})));
        }
    }

    private void handleServerSide(EntityPlayerMP playerMP) {
        switch (this.recordType) {
            case MXT: {
                break;
            }
            case PLAY_LIST: {
                PacketDispatcher.sendTo(new GetBaseDataListsMessage<PlayList>(ServerFileManager.getPlayLists(), this.callbackUuid, this.recordType, (ITextComponent)new TextComponentTranslation("mxtune.no_error", new Object[]{"SERVER"})), playerMP);
                break;
            }
            case SONG: {
                break;
            }
            case SONG_PROXY: {
                PacketDispatcher.sendTo(new GetBaseDataListsMessage<SongProxy>(ServerFileManager.getSongProxies(), this.callbackUuid, this.recordType, (ITextComponent)new TextComponentTranslation("mxtune.no_error", new Object[]{"SERVER"})), playerMP);
                break;
            }
        }
    }
}

