/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network.bidirectional;

import java.util.UUID;
import net.aeronica.mods.mxtune.managers.ClientFileManager;
import net.aeronica.mods.mxtune.managers.records.RecordType;
import net.aeronica.mods.mxtune.network.AbstractMessage;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.bidirectional.GetBaseDataListsMessage;
import net.aeronica.mods.mxtune.status.ClientCSDMonitor;
import net.aeronica.mods.mxtune.status.ClientStateData;
import net.aeronica.mods.mxtune.status.ServerCSDManager;
import net.aeronica.mods.mxtune.util.CallBackManager;
import net.aeronica.mods.mxtune.util.MIDISystemUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class ClientStateDataMessage
extends AbstractMessage<ClientStateDataMessage> {
    private ClientStateData csd = new ClientStateData();
    private long serverIdUuidMSB = 0L;
    private long serverIdUuidLSB = 0L;

    public ClientStateDataMessage() {
    }

    public ClientStateDataMessage(UUID serverID) {
        this.serverIdUuidMSB = serverID.getMostSignificantBits();
        this.serverIdUuidLSB = serverID.getLeastSignificantBits();
    }

    public ClientStateDataMessage(ClientStateData csd) {
        this.csd = csd;
    }

    @Override
    protected void read(PacketBuffer buffer) {
        this.csd = ClientStateDataMessage.readCSD(buffer);
        this.serverIdUuidMSB = buffer.readLong();
        this.serverIdUuidLSB = buffer.readLong();
    }

    @Override
    protected void write(PacketBuffer buffer) {
        ClientStateDataMessage.writeCSD(buffer, this.csd);
        buffer.writeLong(this.serverIdUuidMSB);
        buffer.writeLong(this.serverIdUuidLSB);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            this.handleClientSide(player);
        } else {
            this.handleServerSide(player);
        }
    }

    private void handleClientSide(EntityPlayer playerIn) {
        ClientCSDMonitor.collectAndSend();
        MIDISystemUtil.onPlayerLoggedInModStatus(playerIn);
        ClientFileManager.setCachedServerID(this.serverIdUuidMSB, this.serverIdUuidLSB);
        PacketDispatcher.sendToServer(new GetBaseDataListsMessage(CallBackManager.register(ClientFileManager.INSTANCE), RecordType.PLAY_LIST));
    }

    private void handleServerSide(EntityPlayer playerIn) {
        ServerCSDManager.updateState(playerIn, this.csd);
    }

    public static ClientStateData readCSD(PacketBuffer buffer) {
        return new ClientStateData(buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
    }

    public static void writeCSD(PacketBuffer buffer, ClientStateData csd) {
        buffer.writeBoolean(csd.isMidiAvailable());
        buffer.writeBoolean(csd.isMasterVolumeOn());
        buffer.writeBoolean(csd.isMxtuneVolumeOn());
    }
}

