/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.aeronica.mods.mxtune.network.MultiPacketSerializedObjectManager;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.server.ByteArrayPartMessage;
import net.aeronica.mods.mxtune.util.Miscellus;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.network.PacketBuffer;

public class NetworkSerializedHelper {
    private static final int MAX_BUFFER = 24576;

    private NetworkSerializedHelper() {
    }

    public static Serializable readSerializedObject(PacketBuffer buffer) throws IOException {
        Serializable obj;
        int timeout = 1200;
        UUID uuid = new UUID(buffer.readLong(), buffer.readLong());
        int expectedHashCode = buffer.readInt();
        int expectedLength = buffer.readInt();
        int expectedPackets = buffer.readInt();
        do {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ModLogger.warn("NetworkSerializedHelper#readSerializedObject Network Timeout.", e.getLocalizedMessage());
            }
        } while (MultiPacketSerializedObjectManager.numberOfPackets(uuid) != expectedPackets && timeout-- > 0);
        if (MultiPacketSerializedObjectManager.numberOfPackets(uuid) != expectedPackets && timeout <= 0) {
            ModLogger.error("NetworkSerializedHelper#readSerializedObject Network Timeout.", new Object[0]);
            return null;
        }
        TreeMap<Integer, MultiPacketSerializedObjectManager.SerializedObjectPacket> sortedPackets = new TreeMap<Integer, MultiPacketSerializedObjectManager.SerializedObjectPacket>();
        for (MultiPacketSerializedObjectManager.SerializedObjectPacket serializedObjectPacket : MultiPacketSerializedObjectManager.getPackets(uuid)) {
            sortedPackets.put(serializedObjectPacket.packetId, serializedObjectPacket);
        }
        byte[] byteBuffer = new byte[]{};
        for (Map.Entry entry : sortedPackets.entrySet()) {
            MultiPacketSerializedObjectManager.SerializedObjectPacket packet = (MultiPacketSerializedObjectManager.SerializedObjectPacket)entry.getValue();
            byteBuffer = Miscellus.appendByteArrays(byteBuffer, packet.bytes, packet.bytes.length);
        }
        if (byteBuffer.length != expectedLength) {
            ModLogger.error("NetworkSerializedHelper#readSerializedObject Data Length Mismatch.", new Object[0]);
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            obj = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ModLogger.error(classNotFoundException);
            ModLogger.debug("ClassNotFoundException: obj is null", new Object[0]);
            return null;
        }
        if (obj != null && expectedHashCode == obj.hashCode()) {
            return obj;
        }
        ModLogger.error("NetworkSerializedHelper#readSerializedObject received data error: null object or hashcode does not match: %d", expectedHashCode);
        return null;
    }

    public static void writeSerializedObject(PacketBuffer buffer, Serializable obj) throws IOException {
        int end;
        int index = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(obj);
        out.flush();
        byte[] byteBuffer = bos.toByteArray();
        UUID uuid = UUID.randomUUID();
        buffer.writeLong(uuid.getMostSignificantBits());
        buffer.writeLong(uuid.getLeastSignificantBits());
        buffer.writeInt(obj.hashCode());
        int totalLength = byteBuffer.length;
        buffer.writeInt(totalLength);
        int numPackets = totalLength > 0 ? totalLength / 24576 + 1 : 0;
        buffer.writeInt(numPackets);
        do {
            int start = 24576 * index;
            end = Math.min(24576 * (index + 1), totalLength);
            byte[] writeBuffer = new byte[end - start];
            System.arraycopy(byteBuffer, start, writeBuffer, 0, end - start);
            PacketDispatcher.sendToServer(new ByteArrayPartMessage(uuid, index, writeBuffer));
            ++index;
        } while (end < totalLength);
    }
}

