/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.mxt;

import java.nio.file.Path;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.managers.records.Song;
import net.aeronica.mods.mxtune.managers.records.SongProxy;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.mxt.MXTunePart;
import net.aeronica.mods.mxtune.mxt.MXTuneStaff;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;
import net.minecraft.nbt.NBTTagCompound;

public class MXTuneFileHelper {
    private MXTuneFileHelper() {
    }

    @Nullable
    public static MXTuneFile getMXTuneFile(@Nullable Path path) {
        NBTTagCompound compound;
        MXTuneFile mxTuneFile = null;
        if (path != null && (compound = FileHelper.getCompoundFromFile(path)) != null) {
            mxTuneFile = MXTuneFile.build(compound);
        }
        ModLogger.debug("MXTuneFileHelper#getMXTuneFile version: %s", mxTuneFile == null ? "** file read failure **" : mxTuneFile.getMxtVersion());
        return mxTuneFile;
    }

    public static String getMML(MXTuneFile mxTuneFile) {
        StringBuilder builder = new StringBuilder();
        for (MXTunePart part : mxTuneFile.getParts()) {
            if (mxTuneFile.getMxtVersion().equalsIgnoreCase("1.0.0")) {
                builder.append("MML@I=").append(SoundFontProxyManager.getIndexForFirstMatchingPackedPreset(part.getPackedPatch()));
            } else if (mxTuneFile.getMxtVersion().equalsIgnoreCase("2.0.0")) {
                builder.append("MML@I=").append(SoundFontProxyManager.getIndexById(part.getInstrumentName()));
            } else {
                builder.append("MML@");
            }
            Iterator<MXTuneStaff> iterator = part.getStaves().iterator();
            while (iterator.hasNext()) {
                builder.append(iterator.next().getMml());
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append(";");
        }
        return builder.toString();
    }

    public static Song getSong(MXTuneFile tune) {
        return new Song(tune.getTitle(), MXTuneFileHelper.getMML(tune));
    }

    public static SongProxy getSongProxy(MXTuneFile tune) {
        return MXTuneFileHelper.getSongProxy(MXTuneFileHelper.getSong(tune));
    }

    public static SongProxy getSongProxy(Song song) {
        NBTTagCompound compound = new NBTTagCompound();
        song.writeToNBT(compound);
        return new SongProxy(compound);
    }
}

