/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedItemModelMultiTex
implements IBakedModel {
    protected final ImmutableList<BakedQuad> quads;
    protected final TextureAtlasSprite particle;
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    protected final ItemOverrideList overrides;
    protected final IBakedModel guiModel;
    protected Map<String, IBakedModel> multiTexModel;

    public BakedItemModelMultiTex(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemOverrideList overrides, boolean untransformed) {
        this.quads = quads;
        this.particle = particle;
        this.transforms = transforms;
        this.overrides = overrides;
        this.guiModel = untransformed && BakedItemModelMultiTex.hasGuiIdentity(transforms) ? new BakedGuiItemModel<BakedItemModelMultiTex>(this) : null;
        this.multiTexModel = new THashMap();
    }

    public void addMultiTexModel(String id, IBakedModel model) {
        this.multiTexModel.put(id, model);
    }

    public IBakedModel getModelByIdentifier(String identifier) {
        IBakedModel bakedModel = this.multiTexModel.get(identifier);
        if (bakedModel == null) {
            return this;
        }
        return bakedModel;
    }

    private static boolean hasGuiIdentity(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        TRSRTransformation guiTransform = (TRSRTransformation)transforms.get((Object)ItemCameraTransforms.TransformType.GUI);
        return guiTransform == null || guiTransform.isIdentity();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideMultiTexList.INSTANCE;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            return this.quads;
        }
        return ImmutableList.of();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        if (type == ItemCameraTransforms.TransformType.GUI && this.guiModel != null) {
            return this.guiModel.handlePerspective(type);
        }
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
    }

    private static class ItemOverrideMultiTexList
    extends ItemOverrideList {
        static ItemOverrideMultiTexList INSTANCE = new ItemOverrideMultiTexList((List<ItemOverride>)ImmutableList.of());

        public ItemOverrideMultiTexList(List<ItemOverride> overridesIn) {
            super(overridesIn);
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            int id = stack.func_77952_i();
            return ((BakedItemModelMultiTex)originalModel).getModelByIdentifier("layer" + id);
        }
    }

    public static class BakedGuiItemModel<T extends BakedItemModelMultiTex>
    extends BakedModelWrapper<T> {
        private final ImmutableList<BakedQuad> quads;

        public BakedGuiItemModel(T originalModel) {
            super(originalModel);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (BakedQuad quad : ((BakedItemModelMultiTex)originalModel).quads) {
                if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                builder.add((Object)quad);
            }
            this.quads = builder.build();
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            if (type == ItemCameraTransforms.TransformType.GUI) {
                return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, ((BakedItemModelMultiTex)this.originalModel).transforms, (ItemCameraTransforms.TransformType)type);
            }
            return ((BakedItemModelMultiTex)this.originalModel).handlePerspective(type);
        }
    }
}

