/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers.records;

import java.util.ArrayList;
import java.util.List;
import net.aeronica.mods.mxtune.managers.records.BaseData;
import net.aeronica.mods.mxtune.managers.records.SongProxy;
import net.aeronica.mods.mxtune.util.GUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PlayList
extends BaseData {
    private static final String TAG_NAME = "name";
    private static final String TAG_TITLE = "title";
    private static final String TAG_PLAY_LIST_DAY = "play_list_day";
    private static final String TAG_PLAY_LIST_NIGHT = "play_list_night";
    private static final String TAG_SONG_PREFIX = "song";
    private static final String TAG_SONG_COUNT = "song_count";
    private String name;
    private String title;
    private List<SongProxy> playListDay;
    private List<SongProxy> playListNight;

    public PlayList() {
        this.name = "";
        this.title = "";
        this.playListDay = new ArrayList<SongProxy>();
        this.playListNight = new ArrayList<SongProxy>();
    }

    public PlayList(String name) {
        this.name = name.trim();
        this.title = "";
        this.playListDay = new ArrayList<SongProxy>();
        this.playListNight = new ArrayList<SongProxy>();
        this.guid = GUID.stringToSHA2Hash(this.name);
    }

    public PlayList(String name, List<SongProxy> playListDay, List<SongProxy> playListNight) {
        this.name = name.trim();
        this.title = "";
        this.playListDay = new ArrayList<SongProxy>();
        this.playListDay.addAll(playListDay);
        this.playListNight = new ArrayList<SongProxy>();
        this.playListNight.addAll(playListNight);
        this.guid = GUID.stringToSHA2Hash(this.name);
    }

    public static PlayList build(NBTTagCompound compound) {
        PlayList playList = new PlayList();
        playList.readFromNBT(compound);
        return playList;
    }

    public static PlayList emptyPlaylist() {
        PlayList playList = new PlayList();
        playList.name = "[ empty playlist ]";
        playList.guid = new GUID(-1L, -1L, -1L, -1L);
        return playList;
    }

    public static PlayList undefinedPlaylist() {
        PlayList playList = new PlayList();
        playList.name = " [ undefined playlist ] ";
        playList.guid = new GUID(0L, 0L, 0L, 0L);
        return playList;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.name = compound.func_74779_i(TAG_NAME);
        this.title = compound.func_74779_i(TAG_TITLE);
        NBTTagCompound compoundPlayListDay = compound.func_74775_l(TAG_PLAY_LIST_DAY);
        int songCount = compoundPlayListDay.func_74762_e(TAG_SONG_COUNT);
        this.playListDay = new ArrayList<SongProxy>();
        for (int i = 0; i < songCount; ++i) {
            NBTTagCompound compoundSong = compoundPlayListDay.func_74775_l(TAG_SONG_PREFIX + i);
            SongProxy songProxy = new SongProxy(compoundSong);
            this.playListDay.add(songProxy);
        }
        NBTTagCompound compoundPlayListNight = compound.func_74775_l(TAG_PLAY_LIST_NIGHT);
        songCount = compoundPlayListNight.func_74762_e(TAG_SONG_COUNT);
        this.playListNight = new ArrayList<SongProxy>();
        for (int i = 0; i < songCount; ++i) {
            NBTTagCompound compoundSong = compoundPlayListNight.func_74775_l(TAG_SONG_PREFIX + i);
            SongProxy songProxy = new SongProxy(compoundSong);
            this.playListNight.add(songProxy);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a(TAG_NAME, this.name);
        compound.func_74778_a(TAG_TITLE, this.title);
        NBTTagCompound compoundPlayListDay = new NBTTagCompound();
        int i = 0;
        for (SongProxy songProxy : this.playListDay) {
            if (songProxy == null) continue;
            NBTTagCompound compoundSong = new NBTTagCompound();
            songProxy.writeToNBT(compoundSong);
            compoundPlayListDay.func_74782_a(TAG_SONG_PREFIX + i, (NBTBase)compoundSong);
            ++i;
        }
        compound.func_74782_a(TAG_PLAY_LIST_DAY, (NBTBase)compoundPlayListDay);
        compoundPlayListDay.func_74768_a(TAG_SONG_COUNT, i);
        NBTTagCompound compoundPlayListNight = new NBTTagCompound();
        i = 0;
        for (SongProxy songProxy : this.playListNight) {
            if (songProxy == null) continue;
            NBTTagCompound compoundSong = new NBTTagCompound();
            songProxy.writeToNBT(compoundSong);
            compoundPlayListNight.func_74782_a(TAG_SONG_PREFIX + i, (NBTBase)compoundSong);
            ++i;
        }
        compound.func_74782_a(TAG_PLAY_LIST_NIGHT, (NBTBase)compoundPlayListNight);
        compoundPlayListNight.func_74768_a(TAG_SONG_COUNT, i);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
        this.guid = GUID.stringToSHA2Hash(this.name);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title.trim();
    }

    public List<SongProxy> getPlayListDay() {
        return this.playListDay;
    }

    public void setPlayListDay(List<SongProxy> playListDay) {
        this.playListDay = playListDay;
    }

    public List<SongProxy> getPlayListNight() {
        return this.playListNight;
    }

    public void setPlayListNight(List<SongProxy> playListNight) {
        this.playListNight = playListNight;
    }

    @Override
    public <T extends BaseData> T factory() {
        return (T)new PlayList();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

