/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.blocks.IMusicPlayer;
import net.aeronica.mods.mxtune.blocks.IPlacedInstrument;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.inventory.IInstrument;
import net.aeronica.mods.mxtune.managers.DurationTimer;
import net.aeronica.mods.mxtune.managers.Group;
import net.aeronica.mods.mxtune.managers.GroupHelper;
import net.aeronica.mods.mxtune.managers.GroupManager;
import net.aeronica.mods.mxtune.managers.PlayIdSupplier;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.client.PlayBlockMusicMessage;
import net.aeronica.mods.mxtune.network.client.PlayJamMessage;
import net.aeronica.mods.mxtune.network.client.PlaySoloMessage;
import net.aeronica.mods.mxtune.network.client.StopPlayIDMessage;
import net.aeronica.mods.mxtune.network.client.SyncStatusMessage;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.MapListHelper;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PlayManager {
    private static final Map<Integer, String> membersMML = new HashMap<Integer, String>();
    private static final HashMap<Integer, Integer> membersQueuedStatus = new HashMap();
    private static final HashMap<Integer, Integer> membersPlayID = new HashMap();
    private static final Set<Integer> activePlayIDs = Sets.newHashSet();

    private PlayManager() {
    }

    private static int getNextPlayID() {
        return PlayIdSupplier.PlayType.PLAYERS.getAsInt();
    }

    private static void setPlaying(Integer playerID) {
        membersQueuedStatus.put(playerID, 6);
    }

    private static void setQueued(Integer playerID) {
        membersQueuedStatus.put(playerID, 5);
    }

    public static int playMusic(EntityPlayer playerIn) {
        return PlayManager.playMusic(playerIn, null, false);
    }

    public static int playMusic(EntityPlayer playerIn, BlockPos pos) {
        return PlayManager.playMusic(playerIn, pos, true);
    }

    public static int playMusic(World worldIn, BlockPos pos) {
        String mml;
        IMusicPlayer musicPlayer;
        int playID = -1;
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof IMusicPlayer && (musicPlayer = (IMusicPlayer)worldIn.func_175625_s(pos)) != null && (mml = musicPlayer.getMML()).contains("MML")) {
            playID = PlayManager.getNextPlayID();
            activePlayIDs.add(playID);
            PlayManager.syncStatus();
            DurationTimer.scheduleStop(playID, musicPlayer.getDuration());
            ModLogger.debug("Block/TE MML Sub25: " + mml.substring(0, Math.min(25, mml.length())), new Object[0]);
            PlayBlockMusicMessage playBlockMusicMessage = new PlayBlockMusicMessage(playID, pos, mml, musicPlayer.getSoundRange());
            PacketDispatcher.sendToAllAround(playBlockMusicMessage, worldIn.field_73011_w.getDimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ModConfig.getListenerRange());
        }
        return playID;
    }

    public static int playMusic(EntityPlayer playerIn, BlockPos pos, boolean isPlaced) {
        if (MusicOptionsUtil.isMuteAll(playerIn)) {
            return -1;
        }
        ItemStack sheetMusic = SheetMusicUtil.getSheetMusic(pos, playerIn, isPlaced);
        if (!sheetMusic.func_190926_b()) {
            NBTTagCompound contents = null;
            if (sheetMusic.func_77978_p() != null) {
                contents = (NBTTagCompound)sheetMusic.func_77978_p().func_74781_a("SheetMusic");
            }
            if (contents != null && !contents.func_82582_d()) {
                Integer playerID = playerIn.func_145782_y();
                String title = sheetMusic.func_82833_r();
                String mml = contents.func_74779_i("MML");
                int duration = contents.func_74762_e("Duration");
                mml = mml.replace("MML@", "MML@I" + PlayManager.getPresetIndex(pos, playerIn, isPlaced));
                ModLogger.debug("MML Title: " + title, new Object[0]);
                ModLogger.debug("MML Sub25: " + mml.substring(0, Math.min(25, mml.length())), new Object[0]);
                if (GroupManager.getMembersGroup(playerID).isEmpty()) {
                    ModLogger.debug("playMusic playSolo", new Object[0]);
                    return PlayManager.playSolo(playerIn, mml, duration, playerID);
                }
                ModLogger.debug("playMusic queueJam", new Object[0]);
                return PlayManager.queueJam(playerIn, mml, duration, playerID);
            }
        }
        return -1;
    }

    private static int playSolo(EntityPlayer playerIn, String mml, int duration, Integer playerID) {
        int playID = PlayManager.getNextPlayID();
        PlayManager.queue(playID, playerID, mml);
        DurationTimer.scheduleStop(playID, duration);
        String musicText = PlayManager.getGroupMML(playID);
        activePlayIDs.add(playID);
        PlayManager.syncStatus();
        PlaySoloMessage packetPlaySolo = new PlaySoloMessage(playID, musicText);
        PacketDispatcher.sendToAllAround(packetPlaySolo, playerIn.field_71093_bK, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, ModConfig.getListenerRange());
        return playID;
    }

    private static int queueJam(EntityPlayer playerIn, String mml, int duration, Integer membersID) {
        int groupsPlayID = PlayManager.getGroupsPlayID(membersID);
        PlayManager.queue(groupsPlayID, membersID, mml);
        PlayManager.syncStatus();
        GroupManager.setMembersPartDuration(membersID, duration);
        if (GroupManager.isLeader(membersID)) {
            DurationTimer.scheduleStop(groupsPlayID, GroupManager.getGroupDuration(membersID));
            String musicText = PlayManager.getGroupMML(groupsPlayID);
            BlockPos pos = playerIn.func_180425_c();
            activePlayIDs.add(groupsPlayID);
            PlayManager.syncStatus();
            PlayManager.resetGroupsPlayID(membersID);
            PlayJamMessage playJamMessage = new PlayJamMessage(membersID, groupsPlayID, musicText);
            PacketDispatcher.sendToAllAround(playJamMessage, playerIn.field_71093_bK, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ModConfig.getListenerRange());
        }
        return groupsPlayID;
    }

    private static void resetGroupsPlayID(Integer membersID) {
        Group membersGroup = GroupManager.getMembersGroup(membersID);
        if (!membersGroup.isEmpty()) {
            membersGroup.setPlayID(-1);
        }
    }

    private static int getGroupsPlayID(Integer membersID) {
        Group membersGroup = GroupManager.getMembersGroup(membersID);
        int playID = -1;
        if (!membersGroup.isEmpty()) {
            if (membersGroup.getPlayID() == -1) {
                playID = PlayManager.getNextPlayID();
                membersGroup.setPlayID(playID);
            } else {
                playID = membersGroup.getPlayID();
            }
        }
        return playID;
    }

    private static int getPlayersPlayID(Integer entityID) {
        return entityID != null ? membersPlayID.getOrDefault(entityID, -1) : -1;
    }

    private static boolean isPlayerPlaying(Integer entityID) {
        return entityID != null && membersPlayID.containsKey(entityID);
    }

    public static <T extends EntityLivingBase> boolean playerNotPlaying(T entityLivingIn) {
        return !PlayManager.isPlayerPlaying(entityLivingIn.func_145782_y());
    }

    public static boolean isActivePlayID(@Nullable Integer playID) {
        return playID != null && activePlayIDs.contains(playID);
    }

    public static boolean hasPlayID(int playID) {
        return playID != -1 && membersPlayID.containsValue(playID);
    }

    private static Set<Integer> getMembersByPlayID(int playID) {
        HashSet members = Sets.newHashSet();
        if (playID != -1) {
            for (Integer someMember : membersPlayID.keySet()) {
                if (!membersPlayID.getOrDefault(someMember, -1).equals(playID)) continue;
                members.add(someMember);
            }
        }
        return members;
    }

    public static <T extends EntityLivingBase> void stopPlayingPlayer(T entityLivingIn) {
        PlayManager.stopPlayingPlayer(entityLivingIn.func_145782_y());
    }

    private static void stopPlayingPlayer(Integer entityID) {
        if (PlayManager.isPlayerPlaying(entityID)) {
            PlayManager.stopPlayID(PlayManager.getPlayersPlayID(entityID));
        }
    }

    public static void stopPlayID(int playID) {
        Set<Integer> memberSet = PlayManager.getMembersByPlayID(playID);
        for (Integer member : memberSet) {
            if (membersPlayID.containsKey(member)) {
                membersPlayID.remove(member, playID);
            }
            membersQueuedStatus.remove(member);
        }
        PlayManager.removeActivePlayID(playID);
        PacketDispatcher.sendToAll(new StopPlayIDMessage(playID));
    }

    private static void removeActivePlayID(int playID) {
        if (playID != -1 && !activePlayIDs.isEmpty()) {
            activePlayIDs.remove(playID);
        }
        PlayManager.syncStatus();
    }

    private static int getPresetIndex(BlockPos pos, EntityPlayer playerIn, boolean isPlaced) {
        int presetIndex = 0;
        if (isPlaced) {
            if (playerIn.func_130014_f_().func_180495_p(pos).func_177230_c() instanceof IPlacedInstrument) {
                IPlacedInstrument placedInst = (IPlacedInstrument)playerIn.func_130014_f_().func_180495_p(pos).func_177230_c();
                presetIndex = placedInst.getPatch();
            }
        } else {
            IInstrument inst = (IInstrument)playerIn.func_184614_ca().func_77973_b();
            presetIndex = inst.getPatch(playerIn.func_184614_ca());
        }
        return presetIndex;
    }

    private static void syncStatus() {
        GroupHelper.setClientPlayStatuses(MapListHelper.serializeIntIntMap(membersQueuedStatus));
        GroupHelper.setPlayIDMembers(MapListHelper.serializeIntIntMap(membersPlayID));
        GroupHelper.setActiveServerManagedPlayIDs(MapListHelper.serializeIntegerSet(activePlayIDs));
        PacketDispatcher.sendToAll(new SyncStatusMessage(MapListHelper.serializeIntIntMap(membersQueuedStatus), MapListHelper.serializeIntIntMap(membersPlayID), MapListHelper.serializeIntegerSet(activePlayIDs)));
    }

    private static void queue(int playID, Integer memberID, String mml) {
        try {
            membersMML.put(memberID, mml);
            membersPlayID.put(memberID, playID);
            PlayManager.setQueued(memberID);
        }
        catch (Exception e) {
            ModLogger.error(e);
        }
    }

    private static String getGroupMML(int playId) {
        StringBuilder mmlText = new StringBuilder();
        try {
            Set<Integer> keys = membersPlayID.keySet();
            for (Integer member : keys) {
                if (!membersPlayID.get(member).equals(playId)) continue;
                mmlText.append(membersMML.get(member));
                membersMML.remove(member);
                PlayManager.setPlaying(member);
            }
        }
        catch (Exception e) {
            ModLogger.error(e);
        }
        return mmlText.toString();
    }

    public static void testStopDistance(double stopDistance) {
        if (!GroupManager.hasActiveGroups()) {
            return;
        }
        for (int playID : activePlayIDs) {
            if (PlayManager.getMembersByPlayID(playID).isEmpty()) continue;
            for (Integer memberA : PlayManager.getMembersByPlayID(playID)) {
                for (Integer memberB : PlayManager.getMembersByPlayID(playID)) {
                    double distance;
                    if (memberA.equals(memberB) || !((distance = PlayManager.getMemberVector(memberA).func_72438_d(PlayManager.getMemberVector(memberB))) > stopDistance)) continue;
                    PlayManager.stopPlayID(playID);
                }
            }
        }
    }

    private static Vec3d getMemberVector(Integer entityID) {
        EntityPlayer player = MXTune.proxy.getPlayerByEntityID(entityID);
        Vec3d v3d = player != null ? new Vec3d(player.field_70165_t, player.field_70167_r, player.field_70161_v) : new Vec3d(0.0, 0.0, 0.0);
        return v3d;
    }

    static void purgeMember(Integer memberID) {
        int playID = PlayManager.getPlayersPlayID(memberID);
        if (memberID != null) {
            if (membersPlayID.containsKey(memberID)) {
                activePlayIDs.remove(membersPlayID.get(memberID));
            }
            membersMML.remove(memberID);
            membersPlayID.remove(memberID);
            if (membersQueuedStatus.containsKey(memberID)) {
                membersQueuedStatus.remove(memberID);
                PlayManager.stopPlayID(playID);
            }
        }
    }
}

