/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import java.util.Comparator;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;

public class PlayIdSupplier {
    @Nullable
    public static Integer compare(int playId1, int playId2) {
        return PlayType.EVENT.compare(playId1, playId2);
    }

    public static int compare(PlayType playType1, PlayType playType2) {
        return PlayType.EVENT.compare(playType1, playType2);
    }

    public static PlayType getTypeForPlayId(int playId) {
        return PlayType.EVENT.getTypeForPlayId(playId);
    }

    private static class PlayIdSource
    implements IntSupplier {
        int start;
        int end;
        int range;
        int counter;

        PlayIdSource(int startIn, int endIn) {
            this.start = Math.min(startIn, endIn);
            this.end = Math.max(startIn, endIn) + 1;
            this.range = Math.abs(this.end - this.start);
        }

        @Override
        public int getAsInt() {
            return this.counter++ % this.range + this.start;
        }
    }

    public static enum PlayType implements IntSupplier,
    Comparator<PlayType>
    {
        EVENT(400000, 499999){

            @Override
            protected PlayIdSource next(PlayIdSource playIdSource) {
                return playIdSource;
            }
        }
        ,
        PERSONAL(300000, 399999){

            @Override
            protected PlayIdSource next(PlayIdSource playIdSource) {
                return playIdSource;
            }
        }
        ,
        PLAYERS(200000, 299999){

            @Override
            protected PlayIdSource next(PlayIdSource playIdSource) {
                return playIdSource;
            }
        }
        ,
        BACKGROUND(100000, 199999){

            @Override
            protected PlayIdSource next(PlayIdSource playIdSource) {
                return playIdSource;
            }
        };

        int start;
        int end;
        PlayIdSource playIdSource;
        PlayType playType;
        public static final int INVALID = -1;

        private PlayType(int start, int end) {
            this.start = start;
            this.end = end;
            this.playIdSource = new PlayIdSource(start, end);
            this.playType = this;
        }

        @Nullable
        private PlayType getTypeForPlayId(int playId) {
            for (PlayType type : PlayType.values()) {
                if (playId < type.start || playId > type.end) continue;
                return type;
            }
            return null;
        }

        protected abstract PlayIdSource next(PlayIdSource var1);

        @Override
        public int getAsInt() {
            return this.playIdSource.getAsInt();
        }

        @Nullable
        Integer compare(int playId1, int playId2) {
            PlayType p1 = this.getTypeForPlayId(playId1);
            PlayType p2 = this.getTypeForPlayId(playId2);
            return p1 != null && p2 != null ? Integer.valueOf(this.compare(p1, p2)) : null;
        }

        @Override
        public int compare(PlayType o1, PlayType o2) {
            return o2.compareTo(o1);
        }
    }
}

