/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.MXTune;
import net.aeronica.mods.mxtune.config.ModConfig;
import net.aeronica.mods.mxtune.managers.Group;
import net.aeronica.mods.mxtune.managers.GroupHelper;
import net.aeronica.mods.mxtune.managers.Member;
import net.aeronica.mods.mxtune.managers.PlayManager;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.client.JoinGroupMessage;
import net.aeronica.mods.mxtune.network.client.SyncGroupMessage;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.status.ServerCSDManager;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.world.caps.world.ModWorldPlaylistHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;

public class GroupManager {
    public static final GroupManager INSTANCE = new GroupManager();
    private static Integer groupID = 0;
    private static final Set<Group> groups = new HashSet<Group>(1, 0.3f);

    private GroupManager() {
    }

    private static Integer getNextGroupID() {
        Integer n = groupID;
        Integer n2 = groupID = Integer.valueOf(groupID + 1);
        if (groupID == Integer.MAX_VALUE) {
            groupID = 0;
        }
        return groupID;
    }

    static boolean hasActiveGroups() {
        return !groups.isEmpty();
    }

    public static void addGroup(int creatorID) {
        GroupManager.debug("Add Group -----");
        if (GroupManager.isNotGroupMember(creatorID)) {
            Group theGroup = new Group(GroupManager.getNextGroupID(), creatorID);
            Member theMember = new Member(creatorID);
            theGroup.addMember(theMember);
            groups.add(theGroup);
            GroupManager.debug("  addGroup groupID: " + theGroup.getGroupID() + ", [" + theMember.getMemberID() + "]");
            GroupManager.sync();
        } else {
            GroupManager.debug("Can't create a group if you are a member of a group.");
        }
    }

    public static void addMember(int groupID, int memberID) {
        if (groups.isEmpty()) {
            GroupManager.debug("No group exists!");
            return;
        }
        Group group = GroupManager.getGroup(groupID);
        EntityPlayer playerInitiator = GroupManager.getEntityPlayer(memberID);
        if (!group.isEmpty() && GroupManager.isNotGroupMember(memberID) && playerInitiator != null) {
            EntityPlayer playerTarget = GroupManager.getEntityPlayer(group.getLeaderEntityID());
            if (group.getMembers().size() < 8 && playerTarget != null) {
                Member member = new Member(memberID);
                group.addMember(member);
                GroupManager.debug("addMember: groupID: " + groupID + ", memberID " + member.getMemberID());
                GroupManager.sync();
                playerInitiator.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.groupManager.you_joined_players_group", new Object[]{playerTarget.func_145748_c_()}));
                playerTarget.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.groupManager.player_joined_the_group", new Object[]{playerInitiator.func_145748_c_()}));
            } else if (playerTarget != null) {
                GroupManager.debug("Can't join. Too many members.");
                playerInitiator.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.groupManager.cannot_join_too_many", new Object[]{playerTarget.func_145748_c_()}));
                playerTarget.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.groupManager.player_cannot_join_too_many", new Object[]{playerInitiator.func_145748_c_()}));
            }
        } else if (playerInitiator != null) {
            GroupManager.debug("Can't join a group if you are a member of a group.");
            playerInitiator.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.groupManager.cannot_join_if_group_member", new Object[0]));
        }
    }

    public static void removeMember(int memberID) {
        GroupManager.debug("removeMember " + memberID);
        PlayManager.purgeMember(memberID);
        if (GroupManager.isNotGroupMember(memberID)) {
            GroupManager.debug(memberID + " is not a member of a group.");
            return;
        }
        for (Group theGroup : groups) {
            for (Member theMember : theGroup.getMembers()) {
                if (!GroupManager.tryRemoveMember(theGroup, theMember, memberID) && !GroupManager.tryRemoveGroupIfLast(theGroup, theMember, memberID) && !GroupManager.tryRemoveLeaderPromoteNext(theGroup, theMember, memberID)) continue;
                return;
            }
        }
    }

    private static boolean tryRemoveMember(Group theGroup, Member theMember, int memberID) {
        boolean result = false;
        if (theMember.getMemberID() == memberID && theGroup.getLeaderEntityID() != memberID) {
            theGroup.getMembers().remove(theMember);
            GroupManager.debug("  memberID: " + theMember.getMemberID() + " from groupID: " + theGroup.getGroupID());
            GroupManager.sync();
            result = true;
        }
        return result;
    }

    private static boolean tryRemoveGroupIfLast(Group theGroup, Member theMember, int memberID) {
        boolean result = false;
        if (theMember.getMemberID() == memberID && theGroup.getMembers().size() == 1) {
            GroupManager.debug("  memberIDe: " + theMember.getMemberID() + " is the last member so remove groupID: " + theGroup.getGroupID());
            theGroup.getMembers().clear();
            groups.remove(theGroup);
            GroupManager.sync();
            result = true;
        }
        return result;
    }

    private static boolean tryRemoveLeaderPromoteNext(Group theGroup, Member theMember, int memberID) {
        boolean result = false;
        if (theMember.getMemberID() == memberID && theGroup.getLeaderEntityID() == memberID) {
            theGroup.getMembers().remove(theMember);
            Iterator<Member> remainingMembers = theGroup.getMembers().iterator();
            if (remainingMembers.hasNext()) {
                theMember = remainingMembers.next();
                theGroup.setLeaderEntityID(theMember.getMemberID());
                GroupManager.debug(theMember.getMemberID() + " is promoted to leader of groupID: " + theGroup.getGroupID());
                GroupManager.sync();
                result = true;
            }
        }
        return result;
    }

    static boolean isLeader(int entityID) {
        Group group = GroupManager.getMembersGroup(entityID);
        return !group.isEmpty() && group.getLeaderEntityID() == entityID;
    }

    public static void setLeader(int memberID) {
        GroupManager.debug("setLeader: " + memberID);
        Group group = GroupManager.getMembersGroup(memberID);
        EntityPlayer player = GroupManager.getEntityPlayer(memberID);
        if (!group.isEmpty() && player != null) {
            group.setLeaderEntityID(memberID);
            GroupManager.debug("  GroupID: " + group.getGroupID() + ", leaderName: " + player.func_70005_c_());
            GroupManager.sync();
        }
    }

    private static Group getGroup(int groupID) {
        for (Group theGroup : groups) {
            if (theGroup.getGroupID() != groupID) continue;
            return theGroup;
        }
        return Group.EMPTY;
    }

    static Group getMembersGroup(Integer memberID) {
        for (Group theGroup : groups) {
            for (Member theMember : theGroup.getMembers()) {
                if (theMember.getMemberID() != memberID.intValue()) continue;
                return theGroup;
            }
        }
        return Group.EMPTY;
    }

    private static boolean isNotGroupMember(Integer memberID) {
        boolean notMember = false;
        for (Group theGroup : groups) {
            for (Member theMember : theGroup.getMembers()) {
                if (theMember.getMemberID() != memberID.intValue()) continue;
                notMember = true;
            }
        }
        return !notMember;
    }

    static void setMembersPartDuration(Integer membersID, int duration) {
        Group group = GroupManager.getMembersGroup(membersID);
        if (!group.isEmpty()) {
            group.setPartDuration(duration);
        }
    }

    static int getGroupDuration(Integer membersID) {
        Group group = GroupManager.getMembersGroup(membersID);
        if (!group.isEmpty()) {
            return group.getMaxDuration();
        }
        ModLogger.error("%s %s", GroupManager.class.getSimpleName(), "#getGroupDuration was passed an invalid memberID which resulted in a null groupID which caused this method to return a duration value of ZERO.");
        return 0;
    }

    public static void dump() {
        for (Group theGroup : groups) {
            GroupManager.debug("Group: " + theGroup.getGroupID());
            GroupManager.debug("  Leader: " + theGroup.getLeaderEntityID());
            for (Member theMember : theGroup.getMembers()) {
                GroupManager.debug("    member: " + theMember.getMemberID());
            }
        }
    }

    public static void sync() {
        StringBuilder buildGroups = new StringBuilder("|");
        StringBuilder buildMembers = new StringBuilder("|");
        GroupManager.debug("Sync to client -----");
        for (Group theGroup : groups) {
            GroupManager.debug("Group: " + theGroup.getGroupID());
            GroupManager.debug("  Leader: " + theGroup.getLeaderEntityID());
            buildGroups.append(theGroup.getGroupID()).append("=").append(theGroup.getLeaderEntityID()).append("|");
            for (Member theMember : theGroup.getMembers()) {
                GroupManager.debug("    member: " + theMember.getMemberID());
                buildMembers.append(theMember.getMemberID()).append("=").append(theGroup.getGroupID()).append("|");
            }
        }
        GroupHelper.setClientGroups(buildGroups.toString());
        GroupHelper.setClientMembers(buildMembers.toString());
        PacketDispatcher.sendToAll(new SyncGroupMessage(buildGroups.toString(), buildMembers.toString()));
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (ModConfig.isJAMPartyRightClickDisabled()) {
            return;
        }
        if (event.getTarget() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityPlayer && event.getHand() == EnumHand.MAIN_HAND && !event.getWorld().field_72995_K) {
            EntityPlayer playerInitiator = event.getEntityPlayer();
            EntityPlayer playerTarget = (EntityPlayer)event.getTarget();
            GroupManager.debug(playerInitiator.func_70005_c_() + " pokes " + playerTarget.func_70005_c_());
            Group targetGroup = GroupManager.getMembersGroup(playerTarget.func_145782_y());
            Group initiatorGroup = GroupManager.getMembersGroup(playerInitiator.func_145782_y());
            if (!targetGroup.isEmpty() && targetGroup.getLeaderEntityID() == playerTarget.func_145782_y() && initiatorGroup.isEmpty()) {
                if (!this.notMuted(playerInitiator, playerTarget)) {
                    return;
                }
                MusicOptionsUtil.setSParams(playerInitiator, String.valueOf(targetGroup.getGroupID()), "", "");
                PacketDispatcher.sendTo(new JoinGroupMessage(targetGroup.getGroupID()), (EntityPlayerMP)playerInitiator);
            } else if (!targetGroup.isEmpty()) {
                if (!GroupManager.isLeader(playerTarget.func_145782_y()) && initiatorGroup.isEmpty()) {
                    playerInitiator.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.groupManager.player_not_leader", new Object[]{playerTarget.func_70005_c_()}));
                } else {
                    playerInitiator.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.groupManager.cannot_join_if_group_member", new Object[0]));
                }
            }
        }
    }

    private boolean notMuted(EntityPlayer playerInitiator, EntityPlayer playerTarget) {
        boolean noMute = true;
        if (MusicOptionsUtil.isMuteAll(playerInitiator)) {
            playerInitiator.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.gm.noJoinGroupWhenMuteAll", new Object[0]));
            noMute = false;
        } else if (!MusicOptionsUtil.playerNotMuted(playerInitiator, playerTarget)) {
            playerInitiator.func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.gm.noJoinGroupWhenPlayerIsMuted", new Object[]{playerTarget.func_70005_c_()}));
            noMute = false;
        }
        return noMute;
    }

    @SubscribeEvent
    public void onPlayerSleepInBedEvent(PlayerSleepInBedEvent event) {
        Group group = GroupManager.getMembersGroup(event.getEntityPlayer().func_145782_y());
        if (!group.isEmpty()) {
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_NOW);
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("mxtune.chat.gm.noSleepInJam", new Object[0]));
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            GroupManager.removeMember(player.func_145782_y());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (MXTune.proxy.getEffectiveSide() == Side.SERVER) {
            GroupManager.sync();
            ServerCSDManager.queryClient(event.player);
            ModWorldPlaylistHelper.sync(event.player, event.player.field_70170_p);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (MXTune.proxy.getEffectiveSide() == Side.SERVER) {
            GroupManager.removeMember(event.player.func_145782_y());
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (MXTune.proxy.getEffectiveSide() == Side.SERVER) {
            GroupManager.removeMember(event.player.func_145782_y());
            ModWorldPlaylistHelper.sync(event.player, event.player.field_70170_p);
        }
    }

    @SubscribeEvent
    public static void onEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (MXTune.proxy.getEffectiveSide() == Side.SERVER) {
            GroupManager.sync();
            ServerCSDManager.queryClient(event.player);
            ModWorldPlaylistHelper.sync(event.player, event.player.field_70170_p);
        }
    }

    @Nullable
    private static EntityPlayer getEntityPlayer(Integer entityID) {
        return MXTune.proxy.getPlayerByEntityID(entityID);
    }

    private static void debug(String message) {
        ModLogger.debug("----- " + message, new Object[0]);
    }
}

