/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import java.util.Timer;
import java.util.TimerTask;
import net.aeronica.mods.mxtune.managers.PlayManager;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SheetMusicUtil;

public class DurationTimer {
    private static Timer timer;

    private DurationTimer() {
    }

    public static void start() {
        timer = new Timer("mxTune Duration Timer");
    }

    public static void shutdown() {
        if (timer != null) {
            timer.purge();
            timer.cancel();
        }
    }

    static void scheduleStop(final int playID, final int duration) {
        if (timer != null) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    DurationTimer.stop(playID, duration);
                }
            };
            long delay = (long)duration * 1000L;
            timer.schedule(task, delay);
        }
    }

    private static synchronized void stop(int playID, int duration) {
        if (timer != null) {
            ModLogger.debug("A scheduled stop was sent for playID: %d that had a duration of %s", playID, SheetMusicUtil.formatDuration(duration));
            PlayManager.stopPlayID(playID);
        }
    }
}

