/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.managers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.Reference;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.managers.records.BaseData;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.aeronica.mods.mxtune.managers.records.RecordType;
import net.aeronica.mods.mxtune.managers.records.Song;
import net.aeronica.mods.mxtune.managers.records.SongProxy;
import net.aeronica.mods.mxtune.network.PacketDispatcher;
import net.aeronica.mods.mxtune.network.bidirectional.GetServerDataMessage;
import net.aeronica.mods.mxtune.util.CallBack;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.util.MXTuneRuntimeException;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;

public enum ClientFileManager implements CallBack
{
    INSTANCE;

    private static UUID cachedServerID;
    private static Minecraft mc;
    private static final String DIR_PLAY_LISTS = "playlists";
    private static final String DIR_MUSIC = "music";
    private static Path pathPlayLists;
    private static Path pathMusic;
    private static final Map<GUID, PlayList> mapPlayLists;
    private static final Map<GUID, SongProxy> mapSongProxies;
    private static final Set<GUID> badPlayLists;
    private static final Set<GUID> badSongs;
    private static boolean waitPlayList;
    private static boolean waitSong;
    private static UUID cachedPlayerUUID;
    private static final Map<GUID, SongProxy> mapServerSongProxies;

    public static void setCachedServerID(long msb, long lsb) {
        cachedServerID = new UUID(msb, lsb);
        ModLogger.debug("Cached Server ID received: %s", cachedServerID.toString());
        ClientFileManager.createClientSideCacheDirectories();
        mapPlayLists.clear();
        mapSongProxies.clear();
        mapServerSongProxies.clear();
        badPlayLists.clear();
        badSongs.clear();
    }

    public static void clearCache() {
        if (!cachedPlayerUUID.equals(Reference.EMPTY_UUID) && !cachedServerID.equals(Reference.EMPTY_UUID)) {
            ClientFileManager.clearCache(pathPlayLists);
            ClientFileManager.clearCache(pathMusic);
        }
    }

    private static void createClientSideCacheDirectories() {
        cachedPlayerUUID = ClientFileManager.mc.field_71439_g.func_110124_au();
        Path clientSidePlayerServerCachePath = Paths.get("mxtune/server_cache", cachedPlayerUUID.toString(), ClientFileManager.getCachedServerID().toString());
        pathPlayLists = ClientFileManager.getSubDirectory(clientSidePlayerServerCachePath.toString(), DIR_PLAY_LISTS);
        pathMusic = ClientFileManager.getSubDirectory(clientSidePlayerServerCachePath.toString(), DIR_MUSIC);
    }

    private static Path getSubDirectory(String parent, String child) {
        Path join = Paths.get(parent, child);
        return FileHelper.getDirectory(join.toString(), Side.CLIENT);
    }

    private static UUID getCachedServerID() {
        if (Reference.EMPTY_UUID.equals(cachedServerID)) {
            throw new MXTuneRuntimeException("EMPTY_UUID detected! Something is seriously wrong.");
        }
        return cachedServerID;
    }

    @Override
    public void onFailure(@Nonnull ITextComponent textComponent) {
        ModLogger.warn("ClientFileManager onFailure: %s", textComponent.func_150254_d());
    }

    @Override
    public void onResponse(@Nullable Object payload, RecordType recordType) {
        if (payload == null) {
            return;
        }
        switch (recordType) {
            case PLAY_LIST: {
                for (PlayList playList : (List)payload) {
                    NBTTagCompound compound = new NBTTagCompound();
                    playList.writeToNBT(compound);
                    ClientFileManager.addPlayList(playList.getGUID(), compound, false);
                }
                break;
            }
            case SONG_PROXY: {
                ((List)payload).forEach(songProxy -> mapServerSongProxies.put(songProxy.getGUID(), (SongProxy)songProxy));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SongProxy> getCachedServerSongList() {
        ArrayList<SongProxy> songProxies = new ArrayList<SongProxy>();
        Map<GUID, SongProxy> map = mapServerSongProxies;
        synchronized (map) {
            mapServerSongProxies.forEach((key, value) -> songProxies.add((SongProxy)value));
        }
        return songProxies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PlayList> getPlayLists() {
        ArrayList<PlayList> playLists = new ArrayList<PlayList>();
        Map<GUID, PlayList> map = mapPlayLists;
        synchronized (map) {
            for (Map.Entry<GUID, PlayList> entry : mapPlayLists.entrySet()) {
                playLists.add(entry.getValue());
            }
        }
        return playLists;
    }

    public static void addPlayList(GUID guid, NBTTagCompound data, boolean error) {
        Path path;
        if (error) {
            ClientFileManager.addBadPlayList(guid);
            return;
        }
        PlayList playList = new PlayList();
        playList.readFromNBT(data);
        mapPlayLists.put(guid, playList);
        try {
            path = FileHelper.getCacheFile(pathPlayLists.toString(), guid.toString() + ".dat", Side.CLIENT);
        }
        catch (IOException e) {
            ModLogger.error(e);
            ModLogger.error("Unable to write PlayList file: %s to cache folder: %s", guid.toString() + ".dat", pathPlayLists.toString());
            return;
        }
        waitPlayList = false;
        FileHelper.sendCompoundToFile(path, data);
    }

    public static void addSong(GUID uuid, NBTTagCompound data, boolean error) {
        Boolean fileExists;
        if (error) {
            ClientFileManager.addBadSong(uuid);
            return;
        }
        if (!mapSongProxies.containsKey(uuid)) {
            SongProxy proxy = new SongProxy();
            proxy.readFromNBT(data);
            mapSongProxies.put(uuid, proxy);
        }
        if (!(fileExists = Boolean.valueOf(FileHelper.fileExists(pathMusic.toString(), uuid.toString() + ".dat", Side.CLIENT))).booleanValue()) {
            Path path;
            try {
                path = FileHelper.getCacheFile(pathMusic.toString(), uuid.toString() + ".dat", Side.CLIENT);
            }
            catch (IOException e) {
                ModLogger.error(e);
                ModLogger.error("Unable to write Music file: %s to cache folder: %s", uuid.toString() + ".dat", pathMusic.toString());
                return;
            }
            waitSong = false;
            FileHelper.sendCompoundToFile(path, data);
        }
    }

    static boolean hasSongProxy(GUID guid) {
        return mapSongProxies.containsKey(guid);
    }

    @Nullable
    static SongProxy getSongProxy(GUID guid) {
        if (ClientFileManager.hasSongProxy(guid)) {
            return mapSongProxies.get(guid);
        }
        return null;
    }

    private static void addBadPlayList(GUID guid) {
        badPlayLists.add(guid);
    }

    private static void addBadSong(GUID guid) {
        badSongs.add(guid);
    }

    private static boolean isNotBadPlayList(GUID guid) {
        return !badPlayLists.contains(guid);
    }

    static boolean isNotBadSong(GUID guid) {
        return !badSongs.contains(guid);
    }

    private static <T extends BaseData> void loadCache(Path loc, Map<GUID, T> map, Class<T> type) {
        List<Object> files = new ArrayList();
        map.clear();
        Path path = FileHelper.getDirectory(loc.toString(), Side.CLIENT);
        PathMatcher filter = FileHelper.getDatMatcher(path);
        try (Stream<Path> paths = Files.list(path);){
            files = paths.filter(filter::matches).collect(Collectors.toList());
        }
        catch (IOException | NullPointerException e) {
            ModLogger.error(e);
        }
        for (Path file : files) {
            NBTTagCompound compound = FileHelper.getCompoundFromFile(file);
            if (compound == null) continue;
            try {
                BaseData data = (BaseData)type.newInstance();
                data.readFromNBT(compound);
                GUID guid = data.getGUID();
                map.put(guid, data);
            }
            catch (IllegalAccessException | InstantiationException e) {
                ModLogger.error(e);
                ModLogger.error("What did you do? What's this thing?: %s", type.getSimpleName());
                throw new MXTuneRuntimeException(e);
            }
        }
    }

    private static void clearCache(Path loc) {
        List<Object> files = new ArrayList();
        Path path = FileHelper.getDirectory(loc.toString(), Side.CLIENT);
        PathMatcher filter = FileHelper.getDatMatcher(path);
        try (Stream<Path> paths = Files.list(path);){
            files = paths.filter(filter::matches).collect(Collectors.toList());
        }
        catch (IOException | NullPointerException e) {
            ModLogger.error(e);
        }
        for (Path file : files) {
            try {
                if (file.toFile().isDirectory()) continue;
                Files.delete(file);
            }
            catch (IOException | SecurityException | UnsupportedOperationException e) {
                ModLogger.error(e);
            }
        }
    }

    static boolean songAvailable(GUID guidPlayList) {
        return ClientFileManager.resolvePlayList(guidPlayList) && ClientFileManager.isNotBadPlayList(guidPlayList) && !waitPlayList && !waitSong;
    }

    private static boolean resolvePlayList(GUID guid) {
        if (mapPlayLists.containsKey(guid)) {
            waitPlayList = false;
            return true;
        }
        if (!Reference.EMPTY_GUID.equals(guid) && ClientFileManager.isNotBadPlayList(guid)) {
            waitPlayList = true;
            PacketDispatcher.sendToServer(new GetServerDataMessage(guid, RecordType.PLAY_LIST));
        }
        return false;
    }

    @Nullable
    public static PlayList getPlayList(GUID guid) {
        if (ClientFileManager.resolvePlayList(guid)) {
            return mapPlayLists.get(guid);
        }
        return null;
    }

    @Nullable
    static Song getSongFromCache(GUID guid) {
        if (mapSongProxies.containsKey(guid) && ClientFileManager.isNotBadSong(guid)) {
            try {
                Path path = FileHelper.getCacheFile(pathMusic.toString(), guid.toString() + ".dat", Side.CLIENT);
                NBTTagCompound compound = FileHelper.getCompoundFromFile(path);
                Song song = new Song();
                song.readFromNBT(compound);
                return song;
            }
            catch (IOException e) {
                ModLogger.error(e);
                Path path = Paths.get(pathMusic.toString(), guid.toString() + ".dat");
                ModLogger.error("Unable to read file: " + path, new Object[0]);
            }
        }
        return null;
    }

    static {
        cachedServerID = Reference.EMPTY_UUID;
        mc = Minecraft.func_71410_x();
        mapPlayLists = new HashMap<GUID, PlayList>();
        mapSongProxies = new HashMap<GUID, SongProxy>();
        badPlayLists = new HashSet<GUID>();
        badSongs = new HashSet<GUID>();
        waitPlayList = false;
        waitSong = false;
        mapServerSongProxies = new HashMap<GUID, SongProxy>();
    }
}

