/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.init;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.aeronica.mods.mxtune.blocks.BlockPiano;
import net.aeronica.mods.mxtune.blocks.RendererPiano;
import net.aeronica.mods.mxtune.blocks.TilePiano;
import net.aeronica.mods.mxtune.init.MeshDefinitionFix;
import net.aeronica.mods.mxtune.init.ModBlocks;
import net.aeronica.mods.mxtune.init.ModItems;
import net.aeronica.mods.mxtune.items.ItemIngredients;
import net.aeronica.mods.mxtune.model.StateMapperBandAmp;
import net.aeronica.mods.mxtune.util.IVariant;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModModelManager {
    public static final ModModelManager INSTANCE = new ModModelManager();
    private static List<Object> tesrRenderer = new ArrayList<Object>();
    private final Set<Item> itemsRegistered = new HashSet<Item>();

    private ModModelManager() {
    }

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        INSTANCE.registerTileRenderer();
        INSTANCE.registerBlockModels();
        INSTANCE.registerItemModels();
    }

    private void registerBlockModels() {
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SPINET_PIANO, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockPiano.OCCUPIED}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.BAND_AMP, (IStateMapper)new StateMapperBandAmp());
        this.registerItemModel(ModBlocks.SPINET_PIANO);
    }

    private void registerTileRenderer() {
        this.registerTESR(TilePiano.class, new RendererPiano());
    }

    private void registerItemModels() {
        this.registerVariantItemModels(ModItems.ITEM_INGREDIENTS, "ingredient", ItemIngredients.EnumType.values());
        ModItems.RegistrationHandler.ITEMS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    public static List<Object> getTESRRenderer() {
        return tesrRenderer;
    }

    private <T extends TileEntity> void registerTESR(Class<T> tile, TileEntitySpecialRenderer<T> renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tile, renderer);
        tesrRenderer.add(renderer);
    }

    private <T extends Block> void registerItemModel(T block) {
        this.registerItemModel((Item)Item.field_150901_e.func_82594_a((Object)block.getRegistryName()));
    }

    private void registerItemModel(Item item) {
        this.registerItemModel(item, Objects.requireNonNull(item.getRegistryName()).toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        this.registerItemModel(item, MeshDefinitionFix.create(stack -> fullModelLocation));
    }

    private void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    private <T extends IVariant> void registerItemModelsWithSubtypes(Item item, T[] values) {
        for (T value : values) {
            this.registerItemModelForMetaAndType(item, value.getMeta(), value.func_176610_l());
        }
    }

    private void registerItemModelForMetaAndType(Item item, int metadata, String type) {
        this.registerItemModelForMeta(item, metadata, new ModelResourceLocation(new ResourceLocation(Objects.requireNonNull(item.getRegistryName()).toString() + "_" + type), "inventory"));
    }

    private <T extends IVariant> void registerVariantItemModels(Item item, String variantName, T[] values) {
        for (T value : values) {
            this.registerItemModelForMeta(item, value.getMeta(), variantName + "=" + value.func_176610_l());
        }
    }

    private void registerItemModelForMeta(Item item, int metadata, String variant) {
        this.registerItemModelForMeta(item, metadata, new ModelResourceLocation(item.getRegistryName(), variant));
    }

    private void registerItemModelForMeta(Item item, int metadata, ModelResourceLocation modelResourceLocation) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)modelResourceLocation);
    }
}

