/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.gui.util.GuiScrollingListMX;
import net.aeronica.mods.mxtune.gui.util.IHooverText;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;

public abstract class GuiScrollingListOf<E>
extends GuiScrollingListMX
implements List<E>,
IHooverText {
    private final List<E> arrayList = new CopyOnWriteArrayList();
    protected GuiScreen gui;
    protected Minecraft mc;
    protected int entryHeight;
    private final List<String> hooverTexts = new ArrayList<String>();
    private final List<String> hooverTextsCopy = new ArrayList<String>();
    private String hooverStatusText = "";
    protected int guiLeft = 0;
    protected int guiTop = 0;

    public <T extends GuiScreen> GuiScrollingListOf(T gui, int entryHeight, int width, int height, int top, int bottom, int left) {
        super(gui.field_146297_k, width, height, top, bottom, left, entryHeight, gui.field_146294_l, gui.field_146295_m);
        this.gui = gui;
        this.mc = gui.field_146297_k;
        this.entryHeight = entryHeight;
    }

    public <T extends GuiScreen> GuiScrollingListOf(T gui) {
        super(gui.field_146297_k);
        this.gui = gui;
        this.mc = gui.field_146297_k;
    }

    public void setLayout(int entryHeight, int width, int height, int top, int bottom, int left) {
        super.setLayout(entryHeight, width, height, top, bottom, left, this.gui.field_146294_l, this.gui.field_146295_m);
        this.entryHeight = entryHeight;
    }

    public void setGui(int guiLeft, int guiTop) {
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
    }

    public void resetScroll() {
        this.scrollDistance = this.keepSelectionInViewableArea();
    }

    private float keepSelectionInViewableArea() {
        int listHeight = this.getContentHeight() - (this.bottom - this.top - 4);
        float scrollDistance = this.selectedIndex * this.entryHeight;
        if (listHeight < 0) {
            listHeight = this.entryHeight;
        }
        if (scrollDistance < 0.0f) {
            scrollDistance = 0.0f;
        }
        if (scrollDistance > (float)listHeight) {
            scrollDistance = listHeight;
        }
        return scrollDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToEnd() {
        List<E> list = this.arrayList;
        synchronized (list) {
            this.setSelectedIndex(this.arrayList.size());
            this.resetScroll();
        }
    }

    public void scrollToTop() {
        this.setSelectedIndex(0);
        this.resetScroll();
    }

    public void keyTyped(char typedChar, int keyCode) {
        if (this.isPointInRegion()) {
            int pageSize = (this.bottom - this.top) / this.entryHeight;
            switch (keyCode) {
                case 199: {
                    this.scrollToTop();
                    break;
                }
                case 207: {
                    this.scrollToEnd();
                    break;
                }
                case 208: {
                    int next = this.selectedIndex + 1;
                    this.setSelectedIndex(next < this.getSize() ? next : this.getSize());
                    this.resetScroll();
                    break;
                }
                case 200: {
                    int prev = this.selectedIndex - 1;
                    this.setSelectedIndex(prev > 0 ? prev : 0);
                    this.resetScroll();
                    break;
                }
                case 209: {
                    int next = this.selectedIndex + pageSize - 1;
                    this.setSelectedIndex(next < this.getSize() ? next : this.getSize());
                    this.resetScroll();
                    break;
                }
                case 201: {
                    int prev = this.selectedIndex - pageSize + 1;
                    this.setSelectedIndex(prev > 0 ? prev : 0);
                    this.resetScroll();
                    break;
                }
                case 211: {
                    this.deleteAction(this.selectedIndex);
                    break;
                }
            }
            if (this.selectedIndex >= 0 && this.selectedIndex < this.arrayList.size()) {
                this.selectedClickedCallback(this.selectedIndex);
            }
        }
    }

    @Override
    public boolean isMouseOverElement(int guiLeft, int guiTop, int mouseX, int mouseY) {
        return ModGuiUtils.isPointInRegion(this.left, this.top, this.bottom - this.top, this.listWidth, guiLeft, guiTop, mouseX, mouseY);
    }

    protected boolean isPointInRegion() {
        return ModGuiUtils.isPointInRegion(this.left, this.top, this.bottom - this.top, this.listWidth, this.guiLeft, this.guiTop, this.mouseX, this.mouseY);
    }

    @Override
    public List<String> getHooverTexts() {
        this.hooverTextsCopy.clear();
        this.hooverTextsCopy.addAll(this.hooverTexts);
        if (!this.hooverStatusText.equals("")) {
            this.hooverTextsCopy.add(this.hooverStatusText);
        }
        return this.hooverTextsCopy;
    }

    public void setHooverStatusText(String hooverStatusText) {
        this.hooverStatusText = hooverStatusText;
    }

    @Override
    public void addHooverTexts(String hooverText) {
        this.hooverTexts.add(hooverText);
    }

    private boolean isEnableHighlightSelected() {
        return this.highlightSelected;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int index) {
        List<E> list = this.arrayList;
        synchronized (list) {
            this.selectedIndex = index < 0 ? -1 : (index >= this.arrayList.size() ? this.arrayList.size() - 1 : index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public E get() {
        List<E> list = this.arrayList;
        synchronized (list) {
            if (this.isSelected(this.selectedIndex)) {
                return this.arrayList.get(this.selectedIndex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getSize() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> getList() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList;
        }
    }

    public void elementClicked(int index) {
        this.elementClicked(index, false);
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        if (this.isEnableHighlightSelected() && index == this.selectedIndex && !doubleClick) {
            return;
        }
        this.setSelectedIndex(index);
        if (this.selectedIndex >= 0) {
            if (!doubleClick) {
                this.selectedClickedCallback(this.selectedIndex);
            } else {
                this.selectedDoubleClickedCallback(this.selectedIndex);
            }
        }
    }

    protected abstract void selectedClickedCallback(int var1);

    protected abstract void selectedDoubleClickedCallback(int var1);

    protected void deleteAction(int index) {
    }

    @Override
    public boolean isSelected(int index) {
        return index == this.selectedIndex && index > -1 && index < this.arrayList.size();
    }

    @Override
    protected void drawBackground() {
        Gui.func_73734_a((int)(this.left - 1), (int)(this.top - 1), (int)(this.left + this.listWidth + 1), (int)(this.top + this.listHeight + 1), (int)-6250336);
        Gui.func_73734_a((int)this.left, (int)this.top, (int)(this.left + this.listWidth), (int)(this.top + this.listHeight), (int)-16777216);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Iterator<E> iterator() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Object[] toArray() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends E> c) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.addAll(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        List<E> list = this.arrayList;
        synchronized (list) {
            this.arrayList.replaceAll(operator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<E> spliterator() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.spliterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<E> list = this.arrayList;
        synchronized (list) {
            this.arrayList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        List<E> list = this.arrayList;
        synchronized (list) {
            this.arrayList.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.lastIndexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ListIterator<E> listIterator() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.listIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ListIterator<E> listIterator(int index) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.listIterator(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<E> subList(int fromIndex, int toIndex) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.subList(fromIndex, toIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.removeIf(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<E> stream() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.stream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<E> parallelStream() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.parallelStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(Consumer<? super E> action) {
        List<E> list = this.arrayList;
        synchronized (list) {
            this.arrayList.forEach(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Comparator<? super E> c) {
        List<E> list = this.arrayList;
        synchronized (list) {
            this.arrayList.sort(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        List<E> list = this.arrayList;
        synchronized (list) {
            return obj instanceof List && this.arrayList.equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        List<E> list = this.arrayList;
        synchronized (list) {
            return this.arrayList.hashCode();
        }
    }
}

