/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import com.google.common.io.Files;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.aeronica.libs.mml.readers.mml3mle.MMLFile;
import net.aeronica.libs.mml.readers.ms2mml.MapMS2Instruments;
import net.aeronica.libs.mml.readers.ms2mml.Ms2MmlReader;
import net.aeronica.mods.mxtune.caches.FileHelper;
import net.aeronica.mods.mxtune.mxt.MXTuneFile;
import net.aeronica.mods.mxtune.mxt.MXTunePart;
import net.aeronica.mods.mxtune.mxt.MXTuneStaff;
import net.aeronica.mods.mxtune.util.ModLogger;
import net.aeronica.mods.mxtune.util.SoundFontProxyManager;

public class ImportHelper {
    private static final int MAX_STAVES = 10;

    private ImportHelper() {
    }

    @Nullable
    public static MXTuneFile importToMXTFile(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        switch (ImportHelper.getExtension(path)) {
            case "ms2mml": {
                return ImportHelper.importMs2mml(path);
            }
            case "mml": {
                return MMLFile.parse(path);
            }
            case "zip": {
                return ImportHelper.importZippedMs2mml(path);
            }
        }
        return null;
    }

    private static String getExtension(Path path) {
        return Files.getFileExtension((String)path.getFileName().toString().toLowerCase(Locale.ROOT));
    }

    private static boolean hasExtension(String test, String ext) {
        return Files.getFileExtension((String)test).equalsIgnoreCase(ext);
    }

    @Nullable
    private static MXTuneFile importMs2mml(Path path) {
        Ms2MmlReader ms2MmlReader = new Ms2MmlReader();
        if (ms2MmlReader.parseFile(path)) {
            String title = FileHelper.removeExtension(path.getFileName().toString());
            List<MXTuneStaff> staves = ImportHelper.getStaves(ms2MmlReader.getMML());
            if (staves.isEmpty()) {
                return null;
            }
            MXTuneFile mxTuneFile = new MXTuneFile();
            mxTuneFile.setTitle(title);
            MXTunePart part = new MXTunePart("piano", "piano", 0, staves);
            mxTuneFile.getParts().add(part);
            return mxTuneFile;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static MXTuneFile importZippedMs2mml(Path path) {
        if (path == null) {
            return null;
        }
        try (ZipFile file = new ZipFile(path.toString());){
            String title = FileHelper.removeExtension(path.getFileName().toString());
            MXTuneFile mxTuneFile = new MXTuneFile();
            mxTuneFile.setTitle(title);
            Enumeration<? extends ZipEntry> entries = file.entries();
            ModLogger.debug("---- Zip File: %s", file.getName().substring(file.getName().lastIndexOf(92) + 1));
            int count = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !ImportHelper.hasExtension(entry.getName(), "ms2mml")) continue;
                Ms2MmlReader ms2MmlReader = new Ms2MmlReader();
                ModLogger.debug("Ext: %s, File: %s, size: %s", Files.getFileExtension((String)entry.getName()), entry.getName(), entry.getSize());
                InputStream is = file.getInputStream(entry);
                if (!ms2MmlReader.parseStream(is)) continue;
                title = FileHelper.removeExtension(entry.getName());
                String soundFontProxyID = MapMS2Instruments.getSoundFontProxyNameFromMeta(title);
                int packedPatch = SoundFontProxyManager.getPackedPreset(soundFontProxyID);
                List<MXTuneStaff> staves = ImportHelper.getStaves(ms2MmlReader.getMML());
                ModLogger.debug("  Part: packedPatch %05d, sfpId: %s, meta: %s", packedPatch, soundFontProxyID, title);
                if (staves.isEmpty()) continue;
                MXTunePart part = new MXTunePart(soundFontProxyID, title, packedPatch, staves);
                mxTuneFile.getParts().add(part);
                ++count;
            }
            MXTuneFile mXTuneFile = count > 0 ? mxTuneFile : null;
            return mXTuneFile;
        }
        catch (IOException e) {
            ModLogger.error(e);
            return null;
        }
    }

    public static List<MXTuneStaff> getStaves(String data) {
        ArrayList<MXTuneStaff> staves = new ArrayList<MXTuneStaff>();
        int i = 0;
        for (String mml : data.replaceAll("MML@|MML|;", "").split(",")) {
            if (i >= 10) break;
            staves.add(new MXTuneStaff(i++, mml));
        }
        return staves;
    }
}

