/*
 * Decompiled with CFR 0.152.
 */
package net.aeronica.mods.mxtune.gui.mml;

import javax.annotation.Nullable;
import net.aeronica.mods.mxtune.gui.hud.HudData;
import net.aeronica.mods.mxtune.gui.hud.HudDataFactory;
import net.aeronica.mods.mxtune.gui.util.ModGuiUtils;
import net.aeronica.mods.mxtune.items.ItemChunkTool;
import net.aeronica.mods.mxtune.items.ItemStaffOfMusic;
import net.aeronica.mods.mxtune.managers.ClientFileManager;
import net.aeronica.mods.mxtune.managers.ClientPlayManager;
import net.aeronica.mods.mxtune.managers.records.PlayList;
import net.aeronica.mods.mxtune.network.server.ChunkToolMessage;
import net.aeronica.mods.mxtune.options.MusicOptionsUtil;
import net.aeronica.mods.mxtune.util.GUID;
import net.aeronica.mods.mxtune.world.caps.chunk.ModChunkPlaylistHelper;
import net.aeronica.mods.mxtune.world.caps.world.ModWorldPlaylistHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.DebugRendererChunkBorder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class GuiStaffOverlay
extends Gui {
    private Minecraft mc = Minecraft.func_71410_x();
    private FontRenderer fontRenderer;
    private DebugRenderer.IDebugRenderer chunkBorder;
    private boolean holdingTriggerItem;
    private boolean holdingStaffOfMusic;
    private boolean holdingChunkTool;
    private static final String DASHES = "--";

    public static GuiStaffOverlay getInstance() {
        return GuiStaffOverlayHolder.INSTANCE;
    }

    private GuiStaffOverlay() {
        this.fontRenderer = this.mc.field_71466_p;
        this.chunkBorder = new DebugRendererChunkBorder(this.mc);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEvent(RenderGameOverlayEvent.Post event) {
        if (this.mc.field_71474_y.field_74330_P) {
            return;
        }
        RenderGameOverlayEvent.ElementType elementType = event.getType();
        if (event.isCancelable() || elementType != RenderGameOverlayEvent.ElementType.EXPERIENCE && elementType != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        EntityPlayerSP playerSP = this.mc.field_71439_g;
        Item heldItem = playerSP.func_184614_ca().func_77973_b();
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b() - 40;
        HudData hudData = HudDataFactory.calcHudPositions(0, width, height);
        this.holdingStaffOfMusic = heldItem instanceof ItemStaffOfMusic;
        this.holdingChunkTool = heldItem instanceof ItemChunkTool;
        boolean bl = this.holdingTriggerItem = this.holdingStaffOfMusic || this.holdingChunkTool;
        if (this.holdingStaffOfMusic) {
            this.renderHud(hudData, width, elementType, this::drawPlayListInfo, 6);
        }
        if (this.holdingChunkTool) {
            this.renderHud(hudData, width, elementType, this::drawChunkToolInfo, 6);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEvent(RenderWorldLastEvent event) {
        if (this.holdingTriggerItem && !this.mc.field_71474_y.field_74330_P) {
            this.render(event.getPartialTicks(), 0L);
        }
    }

    public void setTexture(ResourceLocation texture) {
        this.mc.field_71446_o.func_110577_a(texture);
    }

    private void renderHud(HudData hd, int width, RenderGameOverlayEvent.ElementType elementType, HudInfo hudInfo, int numLines) {
        int maxWidth = width - 4;
        int maxHeight = (this.fontRenderer.field_78288_b + 2) * numLines;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)hd.getPosX(), (float)hd.getPosY(), (float)0.0f);
        if (elementType == RenderGameOverlayEvent.ElementType.TEXT) {
            hudInfo.drawHud(hd, maxWidth, maxHeight);
        }
        int iconX = hd.quadX(maxWidth, 0, 2, maxWidth);
        int iconY = hd.quadY(maxHeight, 0, 2, maxHeight);
        if (elementType == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            this.drawBox(iconX, iconY, maxWidth, maxHeight);
        }
        GL11.glPopMatrix();
    }

    private void drawPlayListInfo(HudData hd, int maxWidth, int maxHeight) {
        int fontHeight = this.fontRenderer.field_78288_b + 2;
        int y = 0;
        boolean isCtrlDown = MusicOptionsUtil.isCtrlKeyDown((EntityPlayer)this.mc.field_71439_g);
        String normalBoldUnderline = isCtrlDown ? TextFormatting.BOLD + TextFormatting.UNDERLINE.toString() : TextFormatting.RESET.toString();
        BlockPos pos = this.mc.field_71439_g.func_180425_c();
        Chunk chunk = this.mc.field_71441_e.func_175726_f(pos);
        GUID chunkPlayListGuid = ModChunkPlaylistHelper.getPlaylistGuid(chunk);
        PlayList chunkPlaylists = ClientFileManager.getPlayList(chunkPlayListGuid);
        String chunkPlaylistName = ModGuiUtils.getPlaylistName(chunkPlaylists);
        GUID worldPlayListGuid = ModWorldPlaylistHelper.getPlaylistGuid((World)this.mc.field_71441_e);
        PlayList worldPlaylists = ClientFileManager.getPlayList(worldPlayListGuid);
        String worldPlaylistName = ModGuiUtils.getPlaylistName(worldPlaylists);
        PlayList selectedPlaylistToApply = ClientFileManager.getPlayList(MusicOptionsUtil.getSelectedPlayListGuid((EntityPlayer)this.mc.field_71439_g));
        String selectedPlaylistName = ModGuiUtils.getPlaylistName(selectedPlaylistToApply);
        String delayTimer = ClientPlayManager.getDelayTimerDisplay();
        int delayWidth = this.fontRenderer.func_78256_a(delayTimer);
        int spaceWidth = this.fontRenderer.func_78256_a(" ");
        int widthMinusDelayTimerText = (maxWidth - delayWidth - 2) / spaceWidth;
        StringBuilder paddedText = new StringBuilder();
        for (int i = 0; i < widthMinusDelayTimerText; ++i) {
            paddedText.append(" ");
        }
        paddedText.append(ClientPlayManager.getDelayTimerDisplay());
        this.renderLine(paddedText.toString(), y, hd, maxWidth, maxHeight, fontHeight);
        String formattedText = I18n.func_135052_a((String)"mxtune.gui.guiStaffOverlay.play_list_name_world_chunk", (Object[])new Object[]{worldPlaylistName, String.format("%+d", chunk.field_76635_g), String.format("%+d", chunk.field_76647_h), chunkPlaylistName});
        this.renderLine(formattedText, y += fontHeight, hd, maxWidth, maxHeight, fontHeight);
        formattedText = I18n.func_135052_a((String)"mxtune.gui.guiStaffOverlay.help", (Object[])new Object[0]);
        this.renderLine(formattedText, y += fontHeight, hd, maxWidth, maxHeight, fontHeight, 0xAAAAAA);
        formattedText = ClientPlayManager.getLastSongLine01();
        this.renderLine(formattedText, y += fontHeight, hd, maxWidth, maxHeight, fontHeight, 0xFFCC00);
        formattedText = ClientPlayManager.getLastSongLine02();
        this.renderLine(formattedText, y += fontHeight, hd, maxWidth, maxHeight, fontHeight, 0xFFFF00);
        formattedText = normalBoldUnderline + I18n.func_135052_a((String)"mxtune.gui.guiStaffOverlay.selected_play_list_to_apply", (Object[])new Object[]{selectedPlaylistName});
        this.renderLine(formattedText, y += fontHeight, hd, maxWidth, maxHeight, fontHeight, isCtrlDown ? 65280 : 0x7FFFFF);
    }

    private void drawChunkToolInfo(HudData hd, int maxWidth, int maxHeight) {
        int fontHeight;
        int y = fontHeight = this.fontRenderer.field_78288_b + 2;
        PlayList selectedPlaylistToApply = ClientFileManager.getPlayList(MusicOptionsUtil.getSelectedPlayListGuid((EntityPlayer)this.mc.field_71439_g));
        String selectedPlaylistName = ModGuiUtils.getPlaylistName(selectedPlaylistToApply);
        Chunk chunk = this.getThisChunk();
        GUID chunkPlayListGuid = ModChunkPlaylistHelper.getPlaylistGuid(chunk);
        PlayList chunkPlaylists = ClientFileManager.getPlayList(chunkPlayListGuid);
        String chunkPlaylistName = ModGuiUtils.getPlaylistName(chunkPlaylists);
        ChunkToolMessage.Operation op = MusicOptionsUtil.getChunkToolOperation((EntityPlayer)this.mc.field_71439_g);
        Chunk chunkStart = MusicOptionsUtil.getChunkStart((EntityPlayer)this.mc.field_71439_g);
        Chunk chunkEnd = MusicOptionsUtil.getChunkEnd((EntityPlayer)this.mc.field_71439_g);
        int totalChunks = chunkStart != null && chunkEnd != null ? (Math.abs(chunkStart.field_76635_g - chunkEnd.field_76635_g) + 1) * (Math.abs(chunkStart.field_76647_h - chunkEnd.field_76647_h) + 1) : 0;
        String formattedText = I18n.func_135052_a((String)"mxtune.gui.guiStaffOverlay.selected_play_list_to_apply", (Object[])new Object[]{selectedPlaylistName});
        this.renderLine(formattedText, y, hd, maxWidth, maxHeight, fontHeight, 0x7FFFFF);
        formattedText = I18n.func_135052_a((String)"mxtune.gui.guiStaffOverlay.play_list_name_this_chunk", (Object[])new Object[]{chunk != null ? String.format("%+d", chunk.field_76635_g) : DASHES, chunk != null ? String.format("%+d", chunk.field_76647_h) : DASHES, chunkPlaylistName});
        this.renderLine(formattedText, y += fontHeight, hd, maxWidth, maxHeight, fontHeight);
        formattedText = this.embolden(op, ChunkToolMessage.Operation.START, I18n.func_135052_a((String)"mxtune.gui.guiStaffOverlay.play_list_name_start_chunk", (Object[])new Object[]{chunkStart != null ? String.format("%+d", chunkStart.field_76635_g) : DASHES, chunkStart != null ? String.format("%+d", chunkStart.field_76647_h) : DASHES}));
        this.renderLine(formattedText, y += fontHeight, hd, maxWidth, maxHeight, fontHeight, 65313);
        formattedText = this.embolden(op, ChunkToolMessage.Operation.END, I18n.func_135052_a((String)"mxtune.gui.guiStaffOverlay.play_list_name_end_chunk", (Object[])new Object[]{chunkEnd != null ? String.format("%+d", chunkEnd.field_76635_g) : DASHES, chunkEnd != null ? String.format("%+d", chunkEnd.field_76647_h) : DASHES}));
        this.renderLine(formattedText, y += fontHeight, hd, maxWidth, maxHeight, fontHeight, 38143);
        formattedText = I18n.func_135052_a((String)"mxtune.gui.guiStaffOverlay.play_list_name_total_chunks", (Object[])new Object[]{String.format("%d", totalChunks)});
        this.renderLine(formattedText, y += fontHeight, hd, maxWidth, maxHeight, fontHeight, 16749903);
    }

    @Nullable
    private Chunk getThisChunk() {
        if (this.mc != null && this.mc.field_71441_e != null) {
            BlockPos pos = this.mc.field_71439_g.func_180425_c();
            Chunk chunk = this.mc.field_71441_e.func_175726_f(pos);
            return chunk;
        }
        return null;
    }

    private String embolden(ChunkToolMessage.Operation op, ChunkToolMessage.Operation opTest, String string) {
        return opTest == op ? TextFormatting.BOLD + string : string;
    }

    private void renderLine(String formattedText, int y, HudData hd, int maxWidth, int maxHeight, int fontHeight) {
        this.renderLine(formattedText, y, hd, maxWidth, maxHeight, fontHeight, 0xFFFFFF);
    }

    private void renderLine(String formattedText, int y, HudData hd, int maxWidth, int maxHeight, int fontHeight, int fontColor) {
        String trimmedText = this.fontRenderer.func_78269_a(formattedText, maxWidth);
        int qX = hd.quadX(maxWidth, 0, 4, maxWidth - 4);
        int qY = hd.quadY(maxHeight, y, 4, fontHeight);
        this.fontRenderer.func_175063_a(trimmedText, (float)qX, (float)qY, fontColor);
    }

    private void drawBox(int x, int y, int width, int height) {
        GuiStaffOverlay.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + width + 2), (int)(y + height + 2), (int)-2011028958);
        GuiStaffOverlay.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)-867941308);
    }

    private void render(float partialTicks, long finishTimeNano) {
        EntityPlayerSP entityplayer = this.mc.field_71439_g;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double d0 = entityplayer.field_70142_S + (entityplayer.field_70165_t - entityplayer.field_70142_S) * (double)partialTicks;
        double d1 = entityplayer.field_70137_T + (entityplayer.field_70163_u - entityplayer.field_70137_T) * (double)partialTicks;
        double d2 = entityplayer.field_70136_U + (entityplayer.field_70161_v - entityplayer.field_70136_U) * (double)partialTicks;
        double d3 = 0.0 - d1;
        double d4 = 256.0 - d1;
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        double d5 = (double)(entityplayer.field_70176_ah << 4) - d0;
        double d6 = (double)(entityplayer.field_70164_aj << 4) - d2;
        GlStateManager.func_187441_d((float)1.0f);
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int i = -16; i <= 32; i += 16) {
            for (int j = -16; j <= 32; j += 16) {
                bufferbuilder.func_181662_b(d5 + (double)i, d3, d6 + (double)j).func_181666_a(1.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(d5 + (double)i, d3, d6 + (double)j).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
                bufferbuilder.func_181662_b(d5 + (double)i, d4, d6 + (double)j).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
                bufferbuilder.func_181662_b(d5 + (double)i, d4, d6 + (double)j).func_181666_a(1.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
            }
        }
        for (int k = 2; k < 16; k += 2) {
            bufferbuilder.func_181662_b(d5 + (double)k, d3, d6).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + (double)k, d3, d6).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + (double)k, d4, d6).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + (double)k, d4, d6).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + (double)k, d3, d6 + 16.0).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + (double)k, d3, d6 + 16.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + (double)k, d4, d6 + 16.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + (double)k, d4, d6 + 16.0).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
        }
        for (int l = 2; l < 16; l += 2) {
            bufferbuilder.func_181662_b(d5, d3, d6 + (double)l).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d3, d6 + (double)l).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d4, d6 + (double)l).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d4, d6 + (double)l).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + 16.0, d3, d6 + (double)l).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + 16.0, d3, d6 + (double)l).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + 16.0, d4, d6 + (double)l).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + 16.0, d4, d6 + (double)l).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
        }
        for (int i1 = 0; i1 <= 256; i1 += 2) {
            double d7 = (double)i1 - d1;
            bufferbuilder.func_181662_b(d5, d7, d6).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d7, d6).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d7, d6 + 16.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + 16.0, d7, d6 + 16.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + 16.0, d7, d6).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d7, d6).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d7, d6).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)2.0f);
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int j1 = 0; j1 <= 16; j1 += 16) {
            for (int l1 = 0; l1 <= 16; l1 += 16) {
                bufferbuilder.func_181662_b(d5 + (double)j1, d3, d6 + (double)l1).func_181666_a(0.25f, 0.25f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(d5 + (double)j1, d3, d6 + (double)l1).func_181666_a(0.25f, 0.25f, 1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(d5 + (double)j1, d4, d6 + (double)l1).func_181666_a(0.25f, 0.25f, 1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(d5 + (double)j1, d4, d6 + (double)l1).func_181666_a(0.25f, 0.25f, 1.0f, 0.0f).func_181675_d();
            }
        }
        for (int k1 = 0; k1 <= 256; k1 += 16) {
            double d8 = (double)k1 - d1;
            bufferbuilder.func_181662_b(d5, d8, d6).func_181666_a(0.25f, 0.25f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d8, d6).func_181666_a(0.25f, 0.25f, 1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d8, d6 + 16.0).func_181666_a(0.25f, 0.25f, 1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + 16.0, d8, d6 + 16.0).func_181666_a(0.25f, 0.25f, 1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5 + 16.0, d8, d6).func_181666_a(0.25f, 0.25f, 1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d8, d6).func_181666_a(0.25f, 0.25f, 1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(d5, d8, d6).func_181666_a(0.25f, 0.25f, 1.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
    }

    private static interface HudInfo {
        public void drawHud(HudData var1, int var2, int var3);
    }

    private static class GuiStaffOverlayHolder {
        private static final GuiStaffOverlay INSTANCE = new GuiStaffOverlay();

        private GuiStaffOverlayHolder() {
        }
    }
}

